/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.publickey;

import com.maverick.ssh.SshPublicKey;
import com.maverick.ssh.crypto.digests.Hash;
import com.maverick.ssh.crypto.digests.SHA1Digest;
import com.maverick.ssh.publickey.C;
import com.maverick.ssh.publickey.Dsa;
import com.maverick.ssh.publickey.DsaKey;
import java.io.IOException;
import java.math.BigInteger;

public abstract class DsaPublicKey
extends DsaKey
implements SshPublicKey {
    protected BigInteger y;

    public DsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(bigInteger, bigInteger2, bigInteger3);
        this.y = bigInteger4;
    }

    public DsaPublicKey() {
    }

    public BigInteger getY() {
        return this.y;
    }

    public int getBitLength() {
        return this.p.bitLength();
    }

    public abstract byte[] getEncoded() throws IOException;

    public String getFingerprint() throws IOException {
        return C.A(this.getEncoded());
    }

    public boolean equals(Object object) {
        if (object instanceof DsaPublicKey) {
            try {
                return ((DsaPublicKey)object).getFingerprint().equals(this.getFingerprint());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws IOException {
        Hash hash = new Hash(new SHA1Digest());
        hash.putBytes(byArray2);
        byArray2 = hash.doFinal();
        return Dsa.verify(this.y, this.p, this.q, this.g, byArray, byArray2);
    }

    protected boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        Hash hash = new Hash(new SHA1Digest());
        hash.putBytes(byArray);
        byArray = hash.doFinal();
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        bigInteger3 = bigInteger3.mod(this.q);
        if (BigInteger.valueOf(0L).compareTo(bigInteger) >= 0 || this.q.compareTo(bigInteger) <= 0) {
            return false;
        }
        if (BigInteger.valueOf(0L).compareTo(bigInteger2) >= 0 || this.q.compareTo(bigInteger2) <= 0) {
            return false;
        }
        BigInteger bigInteger4 = bigInteger2.modInverse(this.q);
        BigInteger bigInteger5 = bigInteger3.multiply(bigInteger4).mod(this.q);
        BigInteger bigInteger6 = bigInteger.multiply(bigInteger4).mod(this.q);
        BigInteger bigInteger7 = this.g.modPow(bigInteger5, this.p).multiply(this.y.modPow(bigInteger6, this.p)).mod(this.p).mod(this.q);
        return bigInteger7.compareTo(bigInteger) == 0;
    }

    public abstract /* synthetic */ String getAlgorithm();

    public abstract /* synthetic */ void init(byte[] var1, int var2, int var3) throws IOException;
}

