/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.publickey;

import com.maverick.ssh.SshPublicKey;
import com.maverick.ssh.crypto.digests.Hash;
import com.maverick.ssh.crypto.digests.SHA1Digest;
import com.maverick.ssh.publickey.C;
import com.maverick.ssh.publickey.Rsa;
import com.maverick.ssh.publickey.RsaKey;
import java.io.IOException;
import java.math.BigInteger;

public abstract class RsaPublicKey
extends RsaKey
implements SshPublicKey {
    protected BigInteger publicExponent;

    public RsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger);
        this.publicExponent = bigInteger2;
    }

    public RsaPublicKey() {
    }

    public String getFingerprint() throws IOException {
        return C.A(this.getEncoded());
    }

    public abstract byte[] getEncoded() throws IOException;

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws IOException {
        BigInteger bigInteger = new BigInteger(1, byArray);
        bigInteger = Rsa.doPublic(bigInteger, this.modulus, this.publicExponent);
        bigInteger = Rsa.removePKCS1(bigInteger, 1);
        byArray = bigInteger.toByteArray();
        Hash hash = new Hash(new SHA1Digest());
        hash.putBytes(byArray2);
        byArray2 = hash.doFinal();
        if (byArray2.length != byArray.length - RsaKey.ASN_SHA1.length) {
            return false;
        }
        byte[] byArray3 = RsaKey.ASN_SHA1;
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            if (n == RsaKey.ASN_SHA1.length) {
                byArray3 = byArray2;
                n2 = 0;
            }
            if (byArray[n] != byArray3[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof RsaPublicKey) {
            try {
                return ((RsaPublicKey)object).getFingerprint().equals(this.getFingerprint());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public abstract /* synthetic */ String getAlgorithm();

    public abstract /* synthetic */ void init(byte[] var1, int var2, int var3) throws IOException;
}

