/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.security;

import com.maverick.ssh.crypto.digests.SHA1Digest;
import java.util.Random;

public class SecureRandom
extends Random {
    private static SecureRandom E = new SecureRandom();
    private byte[] C;
    private long B = 1L;
    private SHA1Digest G = new SHA1Digest();
    private byte[] F = new byte[this.G.getDigestSize()];
    private byte[] A = new byte[4];
    private byte[] D = new byte[8];

    public SecureRandom() {
        super(0L);
        this.setSeed(System.currentTimeMillis());
    }

    public SecureRandom(byte[] byArray) {
        this.setSeed(byArray);
    }

    public static SecureRandom getInstance(String string) {
        return new SecureRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecureRandom getInstance() {
        SecureRandom secureRandom = E;
        synchronized (secureRandom) {
            E.setSeed(System.currentTimeMillis());
            return E;
        }
    }

    public static SecureRandom getInstance(String string, String string2) {
        return new SecureRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSeed(int n) {
        byte[] byArray = new byte[n];
        SecureRandom secureRandom = E;
        synchronized (secureRandom) {
            E.setSeed(System.currentTimeMillis());
            E.nextBytes(byArray);
        }
        return byArray;
    }

    public byte[] generateSeed(int n) {
        byte[] byArray = new byte[n];
        this.nextBytes(byArray);
        return byArray;
    }

    public synchronized void setSeed(byte[] byArray) {
        this.G.update(byArray, 0, byArray.length);
    }

    public synchronized void nextBytes(byte[] byArray) {
        this.nextBytes(byArray, 0, byArray.length);
    }

    public synchronized void nextBytes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        this.G.doFinal(this.F, 0);
        for (int i = 0; i != n2; ++i) {
            if (n3 == this.F.length) {
                byte[] byArray2 = this.A(this.B++);
                this.G.update(byArray2, 0, byArray2.length);
                this.G.update(this.F, 0, this.F.length);
                this.G.doFinal(this.F, 0);
                n3 = 0;
            }
            byArray[i + n] = this.F[n3++];
        }
        byte[] byArray3 = this.A(this.B++);
        this.G.update(byArray3, 0, byArray3.length);
        this.G.update(this.F, 0, this.F.length);
    }

    public synchronized void setSeed(long l) {
        if (l != 0L) {
            this.setSeed(this.A(l));
        }
    }

    public synchronized int nextInt() {
        this.nextBytes(this.A);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n = (n << 8) + (this.A[i] & 0xFF);
        }
        return n;
    }

    protected final synchronized int next(int n) {
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        this.nextBytes(byArray);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[i] & 0xFF);
        }
        return n3 & (1 << n) - 1;
    }

    private synchronized byte[] A(long l) {
        for (int i = 0; i != 8; ++i) {
            this.D[i] = (byte)l;
            l >>>= 8;
        }
        return this.D;
    }
}

