/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh1;

import com.maverick.ssh.ChannelEventListener;
import com.maverick.ssh.ForwardingRequestListener;
import com.maverick.ssh.PasswordAuthentication;
import com.maverick.ssh.PublicKeyAuthentication;
import com.maverick.ssh.SshAuthentication;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshConnector;
import com.maverick.ssh.SshContext;
import com.maverick.ssh.SshSession;
import com.maverick.ssh.SshTransport;
import com.maverick.ssh.SshTunnel;
import com.maverick.ssh.crypto.digests.Hash;
import com.maverick.ssh.crypto.digests.MD5Digest;
import com.maverick.ssh.io.ByteArrayReader;
import com.maverick.ssh.io.ByteArrayWriter;
import com.maverick.ssh.publickey.Rsa;
import com.maverick.ssh.publickey.RsaPrivateCrtKey;
import com.maverick.ssh.publickey.RsaPublicKey;
import com.maverick.ssh1.A;
import com.maverick.ssh1.E;
import java.io.IOException;
import java.math.BigInteger;

public class Ssh1Client
implements SshClient {
    static final int M = 9;
    static final int D = 6;
    static final int L = 7;
    static final int J = 8;
    static final int E = 29;
    static final int I = 28;
    String C;
    boolean H = false;
    A G;
    E K;
    String F;
    SshAuthentication A;
    SshConnector B;

    public void connect(SshTransport sshTransport, SshContext sshContext, SshConnector sshConnector, String string, String string2, String string3) throws IOException {
        if (sshConnector == null || !sshConnector.isLicensed()) {
            throw new IOException("You cannot create Ssh1Client instances directly");
        }
        this.K = new E(sshTransport, sshContext);
        this.C = string;
        this.B = sshConnector;
        this.F = string3;
        if (string == null) {
            throw new IOException("You must supply a valid username!");
        }
        this.K.A();
        this.K.F();
        this.H = this.K.A(string);
    }

    public String getRemoteIdentification() {
        return this.F;
    }

    public boolean isAuthenticated() {
        return this.H;
    }

    public int authenticate(SshAuthentication sshAuthentication) throws IOException {
        if (this.H) {
            throw new IOException("The connection has already been authenticated!");
        }
        if (sshAuthentication.getUsername() == null) {
            sshAuthentication.setUsername(this.C);
        }
        this.A = sshAuthentication;
        if (sshAuthentication instanceof PasswordAuthentication) {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(9);
            byteArrayWriter.writeString(((PasswordAuthentication)sshAuthentication).getPassword());
            this.K.B(byteArrayWriter.toByteArray());
            this.H = this.K.E();
            return this.H ? 1 : 2;
        }
        if (sshAuthentication instanceof PublicKeyAuthentication) {
            PublicKeyAuthentication publicKeyAuthentication = (PublicKeyAuthentication)sshAuthentication;
            if (publicKeyAuthentication.getPublicKey() instanceof RsaPublicKey) {
                RsaPublicKey rsaPublicKey = (RsaPublicKey)publicKeyAuthentication.getPublicKey();
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.write(6);
                byteArrayWriter.writeMPINT(rsaPublicKey.getModulus());
                this.K.B(byteArrayWriter.toByteArray());
                ByteArrayReader byteArrayReader = new ByteArrayReader(this.K.nextMessage());
                if (byteArrayReader.read() == 7) {
                    byte[] byArray = new byte[16];
                    if (publicKeyAuthentication.isAuthenticating() && publicKeyAuthentication.getPrivateKey() != null) {
                        RsaPrivateCrtKey rsaPrivateCrtKey = (RsaPrivateCrtKey)((PublicKeyAuthentication)sshAuthentication).getPrivateKey();
                        BigInteger bigInteger = byteArrayReader.readMPINT();
                        bigInteger = Rsa.doPrivateCrt(bigInteger, rsaPrivateCrtKey.getPrimeP(), rsaPrivateCrtKey.getPrimeQ(), rsaPrivateCrtKey.getPrimeExponentP(), rsaPrivateCrtKey.getPrimeExponentQ(), rsaPrivateCrtKey.getCrtCoefficient());
                        bigInteger = Rsa.removePKCS1(bigInteger, 2);
                        byArray = bigInteger.toByteArray();
                        Hash hash = new Hash(new MD5Digest());
                        if (byArray[0] == 0) {
                            hash.putBytes(byArray, 1, 32);
                        } else {
                            hash.putBytes(byArray, 0, 32);
                        }
                        hash.putBytes(this.K.W);
                        byArray = hash.doFinal();
                    }
                    byteArrayWriter.reset();
                    byteArrayWriter.write(8);
                    byteArrayWriter.write(byArray);
                    this.K.B(byteArrayWriter.toByteArray());
                    this.H = this.K.E();
                    if (publicKeyAuthentication.isAuthenticating()) {
                        return this.H ? 1 : 2;
                    }
                    return 5;
                }
                return 2;
            }
            throw new IOException("Only SSH1 RSA private keys are acceptable for SSH1 RSA Authentication");
        }
        throw new IOException("Unsupported SSH1 authentication type!");
    }

    public SshSession openSessionChannel() throws IOException {
        return this.openSessionChannel(null);
    }

    public SshSession openSessionChannel(ChannelEventListener channelEventListener) throws IOException {
        if (!this.H) {
            throw new IOException("The connection must be authenticated first!");
        }
        if (this.G == null) {
            this.G = new A(this.K, this, channelEventListener);
            if (this.K.B.getX11Display() != null && !this.G.v) {
                this.G.A(this.K.B.getX11Display(), this.K.B.getX11RequestListener());
            }
            return this.G;
        }
        return this.duplicate().openSessionChannel();
    }

    public SshTunnel openForwardingChannel(String string, int n, String string2, int n2, String string3, int n3, SshTransport sshTransport, ChannelEventListener channelEventListener) throws IOException {
        if (this.G == null || !this.G.\u00b5) {
            throw new IOException("SSH1 forwarding channels can only be opened after the user's shell has been started!");
        }
        return this.G.A(string, n, string2, n2, string3, n3, sshTransport, channelEventListener);
    }

    public boolean requestXForwarding(String string, ForwardingRequestListener forwardingRequestListener) throws IOException {
        if (this.G != null && this.G.\u00b5) {
            throw new IOException("SSH1 X forwarding requests must be made before starting the user's shell!");
        }
        this.K.B.setX11Display(string);
        this.K.B.setX11RequestListener(forwardingRequestListener);
        if (this.G == null) {
            this.openSessionChannel();
        } else {
            this.G.A(string, forwardingRequestListener);
        }
        return this.G.v;
    }

    public boolean requestRemoteForwarding(String string, int n, String string2, int n2, ForwardingRequestListener forwardingRequestListener) throws IOException {
        if (this.G != null && this.G.\u00b5) {
            throw new IOException("SSH1 forwarding requests must be made before starting the user's shell!");
        }
        if (this.G == null) {
            this.openSessionChannel();
        }
        return this.G.A(n, string2, n2, forwardingRequestListener);
    }

    public void cancelRemoteForwarding(String string, int n) throws IOException {
        throw new IOException("SSH1 clients cannot cancel forwarding requests, disconnect instead!!");
    }

    public void disconnect() {
        try {
            this.K.B("The user disconnected the application");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.K.D() == 2;
    }

    public String getUsername() {
        return this.C;
    }

    public SshClient duplicate() throws IOException {
        if (!this.isConnected() || !this.isAuthenticated()) {
            throw new IOException("Duplication requires an authenticated connection");
        }
        SshConnector sshConnector = SshConnector.getInstance();
        sshConnector.setSupportedVersions(1);
        SshClient sshClient = sshConnector.connect(this.K.Y.duplicate(), this.C, this.K.B);
        if (sshClient.authenticate(this.A) != 1) {
            throw new IOException("Duplication attempt failed to authenicate user!");
        }
        return sshClient;
    }

    public SshContext getContext() {
        return this.K.B;
    }

    public int getChannelCount() {
        if (this.G == null) {
            return 0;
        }
        return this.G.getChannelCount();
    }
}

