/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.ssh.ChannelAdapter;
import com.maverick.ssh.ChannelEventListener;
import com.maverick.ssh.ForwardingRequestListener;
import com.maverick.ssh.PasswordAuthentication;
import com.maverick.ssh.PublicKeyAuthentication;
import com.maverick.ssh.SshAuthentication;
import com.maverick.ssh.SshChannel;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshConnector;
import com.maverick.ssh.SshContext;
import com.maverick.ssh.SshSession;
import com.maverick.ssh.SshTransport;
import com.maverick.ssh.SshTunnel;
import com.maverick.ssh.io.ByteArrayReader;
import com.maverick.ssh.io.ByteArrayWriter;
import com.maverick.ssh.message.SshAbstractChannel;
import com.maverick.ssh2.A;
import com.maverick.ssh2.B;
import com.maverick.ssh2.ChannelFactory;
import com.maverick.ssh2.ChannelOpenException;
import com.maverick.ssh2.D;
import com.maverick.ssh2.E;
import com.maverick.ssh2.GlobalRequest;
import com.maverick.ssh2.GlobalRequestHandler;
import com.maverick.ssh2.H;
import com.maverick.ssh2.KBIAuthentication;
import com.maverick.ssh2.Ssh2Channel;
import com.maverick.ssh2.Ssh2Context;
import com.maverick.ssh2.Ssh2PasswordAuthentication;
import com.maverick.ssh2.Ssh2PublicKeyAuthentication;
import com.maverick.ssh2.Ssh2Session;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Ssh2Client
implements SshClient {
    B R;
    SshTransport X;
    E W;
    A O;
    String S;
    String Y;
    String[] U;
    String T;
    Hashtable b = new Hashtable();
    Hashtable a = new Hashtable();
    _B _ = new _B();
    SshAuthentication P;
    SshConnector Q;
    Vector V = new Vector();
    boolean N = false;
    _A Z = new _A();

    public void connect(SshTransport sshTransport, SshContext sshContext, SshConnector sshConnector, String string, String string2, String string3) throws IOException {
        if (sshConnector == null || !sshConnector.isLicensed()) {
            throw new IOException("You cannot create Ssh2Client instances directly");
        }
        this.X = sshTransport;
        this.S = string2;
        this.Y = string3;
        this.T = string;
        if (string == null) {
            throw new IOException("You must supply a valid username!");
        }
        if (!(sshContext instanceof Ssh2Context)) {
            throw new IOException("Ssh2Context required!");
        }
        this.R = new B();
        this.R.A(sshTransport, (Ssh2Context)sshContext, string2, string3);
        this.W = new E(this.R);
        this.W.A(((Ssh2Context)sshContext).getBannerDisplay());
        this.O = new A(this.R, sshContext);
        this.O.A(this._);
        this.getAuthenticationMethods(string);
    }

    public String[] getAuthenticationMethods(String string) throws IOException {
        this.A(false);
        if (this.U == null) {
            String string2 = this.W.A(string, "ssh-connection");
            Vector<String> vector = new Vector<String>();
            while (string2 != null) {
                int n = string2.indexOf(44);
                if (n > -1) {
                    vector.addElement(string2.substring(0, n));
                    string2 = string2.substring(n + 1);
                    continue;
                }
                vector.addElement(string2);
                string2 = null;
            }
            this.U = new String[vector.size()];
            vector.copyInto(this.U);
        }
        return this.U;
    }

    public int authenticate(SshAuthentication sshAuthentication) throws IOException {
        this.A(false);
        if (sshAuthentication.getUsername() == null) {
            sshAuthentication.setUsername(this.T);
        }
        this.P = sshAuthentication;
        if (sshAuthentication instanceof Ssh2PasswordAuthentication) {
            return this.W.A((D)sshAuthentication, "ssh-connection");
        }
        if (sshAuthentication instanceof PasswordAuthentication) {
            Ssh2PasswordAuthentication ssh2PasswordAuthentication = new Ssh2PasswordAuthentication();
            ssh2PasswordAuthentication.setUsername(((PasswordAuthentication)sshAuthentication).getUsername());
            ssh2PasswordAuthentication.setPassword(((PasswordAuthentication)sshAuthentication).getPassword());
            int n = this.W.A(ssh2PasswordAuthentication, "ssh-connection");
            if (ssh2PasswordAuthentication.requiresPasswordChange()) {
                throw new IOException("Password change required!");
            }
            return n;
        }
        if (sshAuthentication instanceof Ssh2PublicKeyAuthentication || sshAuthentication instanceof KBIAuthentication) {
            return this.W.A((D)sshAuthentication, "ssh-connection");
        }
        if (sshAuthentication instanceof PublicKeyAuthentication) {
            Ssh2PublicKeyAuthentication ssh2PublicKeyAuthentication = new Ssh2PublicKeyAuthentication();
            ssh2PublicKeyAuthentication.setUsername(((PublicKeyAuthentication)sshAuthentication).getUsername());
            ssh2PublicKeyAuthentication.setPublicKey(((PublicKeyAuthentication)sshAuthentication).getPublicKey());
            ssh2PublicKeyAuthentication.setPrivateKey(((PublicKeyAuthentication)sshAuthentication).getPrivateKey());
            return this.W.A(ssh2PublicKeyAuthentication, "ssh-connection");
        }
        throw new IOException("Unsupported SSH2 authentication type");
    }

    public boolean isAuthenticated() {
        return this.W.B();
    }

    public void disconnect() {
        try {
            this.R.A(11, "The user disconnected the application");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.R.isConnected();
    }

    public void forceKeyExchange() throws IOException {
        this.R.L();
    }

    public SshSession openSessionChannel() throws IOException, ChannelOpenException {
        return this.openSessionChannel(32768, 32768, null);
    }

    public SshSession openSessionChannel(ChannelEventListener channelEventListener) throws IOException, ChannelOpenException {
        return this.openSessionChannel(32768, 32768, channelEventListener);
    }

    public Ssh2Session openSessionChannel(int n, int n2, ChannelEventListener channelEventListener) throws IOException, ChannelOpenException {
        this.A(true);
        Ssh2Session ssh2Session = new Ssh2Session(n, n2, this);
        if (channelEventListener != null) {
            ssh2Session.addChannelEventListener(channelEventListener);
        }
        this.O.A(ssh2Session, null);
        if (this.O.E().getX11Display() != null) {
            String string = this.O.E().getX11Display();
            int n3 = string.indexOf(58);
            int n4 = 0;
            n4 = n3 != -1 ? Integer.parseInt(string.substring(n3 + 1)) : Integer.parseInt(string);
            byte[] byArray = this.O.E().getX11AuthenticationCookie();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < 16; ++i) {
                String string2 = Integer.toHexString(byArray[i] & 0xFF);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                stringBuffer.append(string2);
            }
            if (ssh2Session.A(false, "MIT-MAGIC-COOKIE-1", stringBuffer.toString(), n4)) {
                this.N = true;
                ssh2Session.addChannelEventListener(this.Z);
            }
        }
        return ssh2Session;
    }

    public SshTunnel openForwardingChannel(String string, int n, String string2, int n2, String string3, int n3, SshTransport sshTransport, ChannelEventListener channelEventListener) throws IOException {
        H h = new H("direct-tcpip", 32768, 32768, string, n, string2, n2, string3, n3, sshTransport);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(string);
        byteArrayWriter.writeInt(n);
        byteArrayWriter.writeString(string3);
        byteArrayWriter.writeInt(n3);
        h.addChannelEventListener(channelEventListener);
        this.openChannel(h, byteArrayWriter.toByteArray());
        return h;
    }

    public boolean requestRemoteForwarding(String string, int n, String string2, int n2, ForwardingRequestListener forwardingRequestListener) throws IOException {
        if (forwardingRequestListener == null) {
            throw new IOException("You must specify a listener to receive connection requests");
        }
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(string);
        byteArrayWriter.writeInt(n);
        GlobalRequest globalRequest = new GlobalRequest("tcpip-forward", byteArrayWriter.toByteArray());
        if (this.sendGlobalRequest(globalRequest, true)) {
            this.b.put(string + ":" + String.valueOf(n), forwardingRequestListener);
            this.a.put(string + ":" + String.valueOf(n), string2 + ":" + String.valueOf(n2));
            return true;
        }
        return false;
    }

    public void cancelRemoteForwarding(String string, int n) {
    }

    public void openChannel(Ssh2Channel ssh2Channel, byte[] byArray) throws IOException, ChannelOpenException {
        this.A(true);
        this.O.A(ssh2Channel, byArray);
    }

    public void openChannel(SshAbstractChannel sshAbstractChannel) throws IOException, ChannelOpenException {
        this.A(true);
        if (!(sshAbstractChannel instanceof Ssh2Channel)) {
            throw new IOException("The channel is not an SSH2 channel!");
        }
        this.O.A((Ssh2Channel)sshAbstractChannel, null);
    }

    public void addChannelFactory(ChannelFactory channelFactory) throws IOException {
        this.O.A(channelFactory);
    }

    public SshContext getContext() {
        return this.R.\u00c4;
    }

    public void addRequestHandler(GlobalRequestHandler globalRequestHandler) throws IOException {
        this.O.A(globalRequestHandler);
    }

    public boolean sendGlobalRequest(GlobalRequest globalRequest, boolean bl) throws IOException {
        this.A(true);
        return this.O.A(globalRequest, bl);
    }

    public String getRemoteIdentification() {
        return this.Y;
    }

    void A(boolean bl) throws IOException {
        if (this.W == null || this.R == null || this.O == null) {
            throw new IOException("Not connected!");
        }
        if (!this.R.isConnected()) {
            throw new IOException("The connection has been terminated!");
        }
        if (!this.W.B() && bl) {
            throw new IOException("The connection is not authenticated!");
        }
    }

    public String getUsername() {
        return this.T;
    }

    public SshClient duplicate() throws IOException {
        if (!this.isConnected() || !this.isAuthenticated()) {
            throw new IOException("Duplication requires an authenticated connection");
        }
        SshConnector sshConnector = SshConnector.getInstance();
        sshConnector.setSupportedVersions(2);
        SshClient sshClient = sshConnector.connect(this.X.duplicate(), this.T, this.R.\u00c4);
        if (sshClient.authenticate(this.P) != 1) {
            throw new IOException("Duplication attempt failed to authenicate user!");
        }
        return sshClient;
    }

    public int getChannelCount() {
        return this.O.getChannelCount();
    }

    class _A
    extends ChannelAdapter {
        _A() {
        }

        public void channelClosed(SshChannel sshChannel) {
            Enumeration enumeration = Ssh2Client.this.V.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                if (!(enumeration.nextElement() instanceof Ssh2Session)) continue;
                bl = true;
                break;
            }
            Ssh2Client.this.N = bl && Ssh2Client.this.O.E().getX11Display() != null;
        }
    }

    class _B
    implements ChannelFactory {
        String[] A = new String[]{"forwarded-tcpip", "x11"};

        _B() {
        }

        public String[] supportedChannelTypes() {
            return this.A;
        }

        public Ssh2Channel createChannel(String string, byte[] byArray) throws ChannelOpenException {
            if (string.equals("forwarded-tcpip")) {
                try {
                    ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                    String string2 = byteArrayReader.readString();
                    int n = (int)byteArrayReader.readInt();
                    String string3 = byteArrayReader.readString();
                    int n2 = (int)byteArrayReader.readInt();
                    String string4 = string2 + ":" + String.valueOf(n);
                    if (Ssh2Client.this.b.containsKey(string4)) {
                        ForwardingRequestListener forwardingRequestListener = (ForwardingRequestListener)Ssh2Client.this.b.get(string4);
                        String string5 = (String)Ssh2Client.this.a.get(string4);
                        String string6 = string5.substring(0, string5.indexOf(58));
                        int n3 = Integer.parseInt(string5.substring(string5.indexOf(58) + 1));
                        H h = new H("forwarded-tcpip", 32768, 32768, string6, n3, string2, n, string3, n2, forwardingRequestListener.createConnection(string6, n3));
                        forwardingRequestListener.initializeTunnel(h);
                        return h;
                    }
                    throw new ChannelOpenException("Forwarding had not previously been requested", 1);
                }
                catch (IOException iOException) {
                    throw new ChannelOpenException(iOException.getMessage(), 2);
                }
            }
            if (string.equals("x11")) {
                if (!Ssh2Client.this.N) {
                    throw new ChannelOpenException("X Forwarding had not previously been requested", 1);
                }
                try {
                    int n;
                    String string7;
                    ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                    String string8 = byteArrayReader.readString();
                    int n4 = (int)byteArrayReader.readInt();
                    String string9 = byteArrayReader.readString();
                    int n5 = (int)byteArrayReader.readInt();
                    String string10 = Ssh2Client.this.O.E().getX11Display();
                    int n6 = string10.indexOf(":");
                    if (n6 != -1) {
                        string7 = string10.substring(0, n6);
                        n = Integer.parseInt(string10.substring(n6 + 1));
                    } else {
                        string7 = string10;
                        n = 6000;
                    }
                    if (n <= 10) {
                        n += 6000;
                    }
                    ForwardingRequestListener forwardingRequestListener = Ssh2Client.this.O.E().getX11RequestListener();
                    H h = new H("x11", 32768, 32768, string7, n, string8, n4, string9, n5, forwardingRequestListener.createConnection(string7, n));
                    forwardingRequestListener.initializeTunnel(h);
                    return h;
                }
                catch (Throwable throwable) {
                    throw new ChannelOpenException(throwable.getMessage(), 2);
                }
            }
            throw new ChannelOpenException(string + " is not supported", 3);
        }
    }
}

