/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.ssh.ForwardingRequestListener;
import com.maverick.ssh.HostKeyVerification;
import com.maverick.ssh.SshContext;
import com.maverick.ssh.crypto.digests.GeneralDigest;
import com.maverick.ssh.security.SecureRandom;
import com.maverick.ssh2.AbstractComponentFactory;
import com.maverick.ssh2.BannerDisplay;
import com.maverick.ssh2.SshHmac;
import java.io.IOException;

public class Ssh2Context
implements SshContext {
    AbstractComponentFactory _;
    AbstractComponentFactory P;
    AbstractComponentFactory a;
    AbstractComponentFactory L;
    AbstractComponentFactory V;
    public static final String CIPHER_TRIPLEDES_CBC = "3des-cbc";
    public static final String CIPHER_BLOWFISH_CBC = "blowfish-cbc";
    public static final String HMAC_SHA1 = "hmac-sha1";
    public static final String HMAC_MD5 = "hmac-md5";
    public static final String COMPRESSION_NONE = "none";
    public static final String COMPRESSION_ZLIB = "zlib";
    public static final String KEX_DIFFIE_HELLMAN_GROUP1_SHA1 = "diffie-hellman-group1-sha1";
    public static final String PUBLIC_KEY_SSHDSS = "ssh-dss";
    public static final String PUBLIC_KEY_SSHRSA = "ssh-rsa";
    String K = "blowfish-cbc";
    String c = "blowfish-cbc";
    String U = "hmac-sha1";
    String O = "hmac-sha1";
    String T = "none";
    String M = "none";
    String X = "diffie-hellman-group1-sha1";
    String Z = "ssh-dss";
    String W = "/usr/libexec/sftp-server";
    int R = 100;
    BannerDisplay S;
    HostKeyVerification J;
    String Y = null;
    byte[] b = null;
    byte[] Q = null;
    ForwardingRequestListener N = null;

    public Ssh2Context() throws IOException {
        try {
            this._ = new AbstractComponentFactory(Class.forName("com.maverick.ssh.cipher.SshCipher")){

                public Object createInstance(String string, Class clazz) throws Throwable {
                    return clazz.newInstance();
                }
            };
            this._.add(CIPHER_TRIPLEDES_CBC, Class.forName("com.maverick.ssh2.TripleDesCbc"));
            this._.add(CIPHER_BLOWFISH_CBC, Class.forName("com.maverick.ssh2.BlowfishCbc"));
            this.P = new AbstractComponentFactory(Class.forName("com.maverick.ssh.crypto.digests.GeneralDigest")){

                public Object createInstance(String string, Class clazz) throws Throwable {
                    return new SshHmac(string, (GeneralDigest)clazz.newInstance());
                }
            };
            this.P.add(HMAC_SHA1, Class.forName("com.maverick.ssh.crypto.digests.SHA1Digest"));
            this.P.add(HMAC_MD5, Class.forName("com.maverick.ssh.crypto.digests.MD5Digest"));
            this.a = new AbstractComponentFactory(Class.forName("com.maverick.ssh.compression.SshCompression")){

                public Object createInstance(String string, Class clazz) throws Throwable {
                    if (!string.equals(Ssh2Context.COMPRESSION_NONE)) {
                        return clazz.newInstance();
                    }
                    return null;
                }
            };
            this.a.add(COMPRESSION_NONE, Class.forName("java.lang.Object"));
            try {
                this.a.add(COMPRESSION_ZLIB, Class.forName("com.sshtools.zlib.ZLibCompression"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.L = new AbstractComponentFactory(Class.forName("com.maverick.ssh2.G")){

                public Object createInstance(String string, Class clazz) throws Throwable {
                    return clazz.newInstance();
                }
            };
            this.L.add(KEX_DIFFIE_HELLMAN_GROUP1_SHA1, Class.forName("com.maverick.ssh2.C"));
            this.V = new AbstractComponentFactory(Class.forName("com.maverick.ssh.SshPublicKey")){

                public Object createInstance(String string, Class clazz) throws Throwable {
                    return clazz.newInstance();
                }
            };
            this.V.add(PUBLIC_KEY_SSHDSS, Class.forName("com.maverick.ssh2.Ssh2DsaPublicKey"));
            this.V.add(PUBLIC_KEY_SSHRSA, Class.forName("com.maverick.ssh2.Ssh2RsaPublicKey"));
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName());
        }
    }

    public void setChannelLimit(int n) {
        this.R = n;
    }

    public int getChannelLimit() {
        return this.R;
    }

    public void setX11Display(String string) {
        this.Y = string;
    }

    public String getX11Display() {
        return this.Y;
    }

    public byte[] getX11AuthenticationCookie() {
        if (this.b == null) {
            this.b = new byte[16];
            SecureRandom.getInstance().nextBytes(this.b);
        }
        return this.b;
    }

    public void setX11RealCookie(byte[] byArray) {
        this.Q = byArray;
    }

    public byte[] getX11RealCookie() {
        if (this.Q == null) {
            this.Q = this.getX11AuthenticationCookie();
        }
        return this.Q;
    }

    public void setX11RequestListener(ForwardingRequestListener forwardingRequestListener) {
        this.N = forwardingRequestListener;
    }

    public ForwardingRequestListener getX11RequestListener() {
        return this.N;
    }

    public BannerDisplay getBannerDisplay() {
        return this.S;
    }

    public void setBannerDisplay(BannerDisplay bannerDisplay) {
        this.S = bannerDisplay;
    }

    public AbstractComponentFactory supportedCiphers() {
        return this._;
    }

    public String getPreferredCipherCS() {
        return this.K;
    }

    public void setPreferredCipherCS(String string) throws IOException {
        if (!this._.contains(string)) {
            throw new IOException(string + " is not supported");
        }
        this.K = string;
    }

    public String getPreferredCipherSC() {
        return this.c;
    }

    public void setPreferredCipherSC(String string) throws IOException {
        if (!this._.contains(string)) {
            throw new IOException(string + " is not supported");
        }
        this.c = string;
    }

    public AbstractComponentFactory supportedMacs() {
        return this.P;
    }

    public String getPreferredMacCS() {
        return this.U;
    }

    public void setPreferredMacCS(String string) throws IOException {
        if (!this.P.contains(string)) {
            throw new IOException(string + " is not supported");
        }
        this.U = string;
    }

    public String getPreferredMacSC() {
        return this.O;
    }

    public void setPreferredMacSC(String string) throws IOException {
        if (!this.P.contains(string)) {
            throw new IOException(string + " is not supported");
        }
        this.O = string;
    }

    public AbstractComponentFactory supportedCompressions() {
        return this.a;
    }

    public String getPreferredCompressionCS() {
        return this.T;
    }

    public void setPreferredCompressionCS(String string) throws IOException {
        if (!this.a.contains(string)) {
            throw new IOException(string + " is not supported");
        }
        this.T = string;
    }

    public String getPreferredCompressionSC() {
        return this.M;
    }

    public void setPreferredCompressionSC(String string) throws IOException {
        if (!this.a.contains(string)) {
            throw new IOException(string + " is not supported");
        }
        this.M = string;
    }

    public AbstractComponentFactory supportedKeyExchanges() {
        return this.L;
    }

    public String getPreferredKeyExchange() {
        return this.X;
    }

    public void setPreferredKeyExchange(String string) throws IOException {
        if (!this.L.contains(string)) {
            throw new IOException(string + " is not supported");
        }
        this.X = string;
    }

    public AbstractComponentFactory supportedPublicKeys() {
        return this.V;
    }

    public String getPreferredPublicKey() {
        return this.Z;
    }

    public void setPreferredPublicKey(String string) throws IOException {
        if (!this.V.contains(string)) {
            throw new IOException(string + " is not supported");
        }
        this.Z = string;
    }

    public void setHostKeyVerification(HostKeyVerification hostKeyVerification) {
        this.J = hostKeyVerification;
    }

    public HostKeyVerification getHostKeyVerification() {
        return this.J;
    }

    public void setSFTPProvider(String string) {
        this.W = string;
    }

    public String getSFTPProvider() {
        return this.W;
    }
}

