/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.ssh.io.ByteArrayReader;
import com.maverick.ssh.io.ByteArrayWriter;
import com.maverick.ssh.publickey.DsaPublicKey;
import java.io.IOException;
import java.math.BigInteger;

public class Ssh2DsaPublicKey
extends DsaPublicKey {
    public Ssh2DsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public String getAlgorithm() {
        return "ssh-dss";
    }

    public Ssh2DsaPublicKey() {
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(this.getAlgorithm());
        byteArrayWriter.writeBigInteger(this.p);
        byteArrayWriter.writeBigInteger(this.q);
        byteArrayWriter.writeBigInteger(this.g);
        byteArrayWriter.writeBigInteger(this.y);
        return byteArrayWriter.toByteArray();
    }

    public void init(byte[] byArray, int n, int n2) throws IOException {
        ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, n, n2);
        String string = byteArrayReader.readString();
        if (!string.equals(this.getAlgorithm())) {
            throw new IOException("Invalid public key header");
        }
        this.p = byteArrayReader.readBigInteger();
        this.q = byteArrayReader.readBigInteger();
        this.g = byteArrayReader.readBigInteger();
        this.y = byteArrayReader.readBigInteger();
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws IOException {
        if (byArray.length != 40) {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, 0, byArray.length);
            byte[] byArray3 = byteArrayReader.readBinaryString();
            String string = new String(byArray3);
            if (!string.equals(this.getAlgorithm())) {
                throw new IOException("Invalid signature");
            }
            byArray = byteArrayReader.readBinaryString();
        }
        return super.verifySignature(byArray, byArray2);
    }
}

