/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.ssh.io.ByteArrayReader;
import com.maverick.ssh.io.ByteArrayWriter;
import com.maverick.ssh.publickey.RsaPublicKey;
import java.io.IOException;
import java.math.BigInteger;

public class Ssh2RsaPublicKey
extends RsaPublicKey {
    public Ssh2RsaPublicKey() {
    }

    public Ssh2RsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger, bigInteger2);
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(this.getAlgorithm());
        byteArrayWriter.writeBigInteger(this.getPublicExponent());
        byteArrayWriter.writeBigInteger(this.getModulus());
        return byteArrayWriter.toByteArray();
    }

    public void init(byte[] byArray, int n, int n2) throws IOException {
        ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
        String string = byteArrayReader.readString();
        if (!string.equals(this.getAlgorithm())) {
            throw new IOException("Invalid ssh-rsa key");
        }
        this.publicExponent = byteArrayReader.readBigInteger();
        this.modulus = byteArrayReader.readBigInteger();
    }

    public String getAlgorithm() {
        return "ssh-rsa";
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, 0, byArray.length);
        byte[] byArray3 = byteArrayReader.readBinaryString();
        String string = new String(byArray3);
        if (!string.equals(this.getAlgorithm())) {
            throw new IOException("Invalid signature");
        }
        byArray = byteArrayReader.readBinaryString();
        return super.verifySignature(byArray, byArray2);
    }

    public boolean equals(Object object) {
        if (object instanceof Ssh2RsaPublicKey) {
            try {
                return ((Ssh2RsaPublicKey)object).getFingerprint().equals(this.getFingerprint());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

