// launch a new 'application' (page containing applet)
// args:
//    windowname -- name of the browser window ('target')
//    filename -- name of the toplevel HTML file within the tar file
//    tarname -- name of the tar file (MINUS the ".tar" suffix)
//    baseurl -- the protocol + ip address used to access the router
// e.g., startApp("_IPS_", "html/runIPS.shtml", "ips", "http://10.10.10.1")

function calcWindowDims(w, h) {
    var x = (screen.width - w)/2;
    var y = (screen.height - h)/2;
    return "width="+w+",height="+h+",top="+y+",left="+x;
}
function discoverFsName(tarname) {
    var dirStr = opener.top.FILES.document.forms[0].elements[0].value;
    var index = dirStr.indexOf("Directory of");
    var searchStr = dirStr.substring(index);
    var fsName = searchStr.substring(13, searchStr.indexOf(":"));
    var tarIndex = dirStr.indexOf(tarname);
    if (tarIndex == -1) return "";
    while (index != -1) {
        var nextIndex = dirStr.indexOf("Directory of", index + 14);
        if ((tarIndex > index) && ((tarIndex < nextIndex) || (nextIndex == -1))) {
            // found app tar file
            return fsName + ":";
        }
        index = nextIndex;
        searchStr = dirStr.substring(index);
        fsName = searchStr.substring(13, searchStr.indexOf(":"));
    }
}

function startApp(windowname, filename, tarname, baseurl) {
    var fs = discoverFsName(tarname + ".tar");
    if (fs == "") return false;
    var appWindow = window.open(baseurl + "/archive/" + fs + tarname + "/" + filename,
        windowname, calcWindowDims(360,200)+",toolbar=no,resizable=no,scrollbars=no,status=yes");
    return true;
}

