/*
 * File: common.js
 *
 * September 2002, Jason Jiang
 *   Ported from PDM
 *
 * Copyright (c) 2002 by Cisco Systems, Inc.
 * All rights reserved.
 *
 */

var isExplorer = (navigator.appName.indexOf("Internet Explorer") >= 0
  && navigator.userAgent.indexOf("Opera") < 0);
var isNetscape = (navigator.appName.indexOf("Netscape") >= 0);

var loadingComplete = false;

function getBrowser() {
    var browser = navigator.appName;
    if (browser == "Microsoft Internet Explorer") {
        browser = "Internet Explorer";
    }
  
    var version = navigator.appVersion;

    var userAgent = navigator.userAgent;
    if (userAgent.search(/MSIE [5-9]/) >= 0) {
        if (userAgent.indexOf("Opera") >= 0) {
            // It's really Opera.
            browser = "Opera";
            version = userAgent.replace(/^.*Opera ([^;]+).*$/, "$1");
        } else {
            // IE 5.0+ has the real version embedded inside this string.
            version = version.replace(/^.*MSIE ([^;]+).*$/, "$1");
        }
    } else if (userAgent.search(/Gecko/) >= 0) {  // Netscape 6?
        version = userAgent.replace(/^.*\//, "");
    } else {
        version = parseFloat(version);
    }

    return browser + " " + version;
}

function getBrowserVersion() {
    var verString = navigator.appVersion;

    // IE 5.0+ has the real version embedded inside this string.
    if (verString.search(/MSIE [5-9]/) >= 0) {
        return verString.replace(/^.*MSIE ([^;]+).*$/, "$1");
    } else {
        return parseFloat(navigator.appVersion);
    }
}

function check() {
    // Java check
    if (!navigator.javaEnabled()) {
        document.writeln('<p><font color="red"><strong>ERROR:</strong></font> Java is not enabled on your browser.</p><p>');
        if (isNetscape) {
            document.writeln('RSDM requires Java.  You can enable Java by selecting the <strong>Edit|Preferences</strong> menu.  Click <em>Advanced</em> and then click <em>Enable Java</em>.');
        } else if (isExplorer) {
            document.writeln('RSDM requires Java.  You can enable Java by selecting the <strong>Tools|Internet Options</strong> menu.  Click the <em>Security</em> tab.  Choose a Web content zone that supports Java or click the <em>Custom Level</em> button and scroll down to the <em>Microsoft VM</em> section.  In the <em>Java permissions</em>, click any choice besides <em>Disable Java</em>.');
        } else {
            document.writeln('RSDM requires you to enable Java or to use a Java-enabled browser.</font>');
        }
        document.writeln('</p>');
        return 1;
    }

    // browser check
    ver = getBrowserVersion();
    if (isNetscape) {
        if (ver < 4.5) {
            document.writeln('<p><font color="red"><strong>ERROR:</strong></font> RSDM requires Netscape 4.5 or higher.  Please upgrade your browser.</p>');
            return 1;
        }
    } else if (isExplorer) {
        if (ver < 5) {
            document.writeln('<p><font color="red"><strong>ERROR:</strong></font> RSDM supports Internet Explorer 5.0 or higher.  Please upgrade your browser.</p>');
            return 1;
        }
    } else {
        document.writeln('<p><font color="blue"><strong>WARNING:</strong></font> You are not running Netscape Navigator or Internet Explorer.  You may encounter problems running RSDM.</p>');
    }

    return 0;
}

function getCookie(key) { 
    return unescape(document.cookie);
}

function setCookie(key, value) {   
    var expireDate = new Date();
    expireDate.setFullYear(expireDate.getFullYear() + 5); 
    document.cookie = key + "=" + escape(value) + "; expires=" + expireDate.toGMTString(); 
}

function displayHelp(url) {
    var helpWin = window.open(url, "RSDM_Help");
    helpWin.focus();
}

// called by Java when it is done initializing
function clearLoadingMessage() {
    // clear out loading image
    document.images["loading"].src = "blank.gif";
    loadingComplete = true;
}

function isLoadingComplete() {
    return loadingComplete;
}

// called by Java to update this page
// must have a tag named 'infoTable'
function updateHTMLPage(hostname, platform, pixVersion, xdmVersion, user, 
        privilege, jdkVersion, os, msg1, msg2) {
    var userName = new String(user); // must convert to a String
    userName = userName.replace(/</, "&lt;");
    userName = userName.replace(/>/, "&gt;");

    var infoHTML ='<center>' +
'<table border="1" cellpadding="2">' +
'<tr>' +
'<td align="right"><font size=-2 face="Arial,Helvetica">Hostname</td>' +
'<td align="left"><font size=-2 face="Arial,Helvetica">' +
hostname + '</font></td>' +
'<td align="right"><font size=-2 face="Arial,Helvetica">Device</td>' +
'<td align="left"><font size=-2 face="Arial,Helvetica">' + 
platform + '</font></td>' +
'</tr>' +
'<tr>' +
'<td align="right"><font size="-2" face="Arial,Helvetica">RSDM Version</font></td>' +
'<td align="left"><font size="-2" face="Arial,Helvetica">' +
xdmVersion + '</font></td>' +
'<td align="right"><font size="-2" face="Arial,Helvetica">IOS Version</font></td>' +
'<td align="left"><font size="-2" face="Arial,Helvetica">' +
pixVersion + '</font></td>' +
'</tr>' +
'<tr>' +
'<td align="right"><font size="-2" face="Arial,Helvetica">User</font></td>' +
'<td align="left"><font size="-2" face="Arial,Helvetica">' +
userName + '</font></td>' +
'<td align="right"><font size="-2" face="Arial,Helvetica">Privilege Level</font></td>' +
'<td align="left"><font size="-2" face="Arial,Helvetica">' +
privilege + '</font></td>' +
'</tr>' +

'<tr>' +
'<td align="right"><font size="-2" face="Arial,Helvetica">JavaScript</font></td>' +
'<td align="left"><font size="-2" face="Arial,Helvetica">Enabled</font></td>' +
'<td align="right"><font size="-2" face="Arial,Helvetica">Java</font></td>' +
'<td align="left"><font size="-2" face="Arial,Helvetica">Enabled</font></td>' +
'</tr>' +
'<tr>' +
'<td align="right"><font size="-2" face="Arial,Helvetica">Browser</font></td>' +
'<td align="left"><font size="-2" face="Arial,Helvetica">' +
getBrowser() + '</font></td>' +
'<td align="right"><font size="-2" face="Arial,Helvetica">JDK Version</font></td>' +
'<td align="left"><font size="-2" face="Arial,Helvetica">' +
jdkVersion + '</font></td>' +
'</tr>' +
'<tr>' +
'<td align="right"><font size="-2" face="Arial,Helvetica">OS</font></td>' +
'<td align="left" colspan="3"><font size="-2" face="Arial,Helvetica">' +
os + '</font></td>' +
'</tr>' +
'</table>' +
'</center>' +
'<hr />' +
'<center>' +
'<font color="blue" size="+1"><strong>' + msg1 + '</strong></font>' +
'<h4><font color="blue">' + msg2 + '</font></h4>' +
'</center>';

    if (document.all) {
        document.all('infoTable').outerHTML = infoHTML;
    } else if (document.layers) {
        document.layers['infoTable'].document.open();
        document.layers['infoTable'].document.writeln(infoHTML);
        document.layers['infoTable'].document.close();
    } else {
        document.getElementById('infoTable').innerHTML = infoHTML;
    }
}

