/*
 * Copyright (c) 2002, 2003, 2004 by cisco Systems, Inc.
 * All rights reserved.
 */

var listFilterName = new Array();
var listUsedFilterName = new Array();

function aclElementObject(text, command) {
  this.text = text;
  this.command = command;
}

function aclObject(name, element) {
  this.name = name;
  this.element = element;
}

function onCancel() {
  displayFilter();
}

function getFiltersName(pattern, string, array) {
  var results, count =0;
  
  results = string.match(pattern);
   while (results) {
     array[count++] = results[1];
     results = results.input.substring(results[0].length + results.index).match(pattern);
   }
}

function getAllFiltersListNames() {
   var pattern, results, count =0;
   var form = document.forms[0];
   
   if (typeString == "IP Class") { 
         pattern = " ip access-group (\\S+) (in|out)";
	 getFiltersName(pattern, form.showRun.value, listUsedFilterName);
	 pattern = "Extended IP access list (\\S+)";
	 getFiltersName(pattern, form.showAcl.value, listFilterName);
   }
   
   if (typeString == "EtherType") { 
         pattern = "bridge-group \\d+ \\w+-type-list (\\S+)";
	 getFiltersName(pattern, form.showRun.value, listUsedFilterName);
	 pattern = "Type code access list (\\S+)";
	 getFiltersName(pattern, form.showAcl.value, listFilterName);
   }
   
   if (typeString == "Mac Address") { 
         pattern = "bridge-group \\d+ \\w+-address-list (\\S+)";
	 getFiltersName(pattern, form.showRun.value, listUsedFilterName);
	 pattern = "Bridge address access list (\\S+)";
	 getFiltersName(pattern, form.showAcl.value, listFilterName);
   }
}

function isFilterUsed(name) {
  var i;

  for (i=0; i < listUsedFilterName.length; i++) {
    if (listUsedFilterName[i] == name) {
	  return true;
	}
  }
  return false;
}

function isACLExist(name) {
  var i;
  
  for (i=0; i < listFilterName.length; i++) {
    if (listFilterName[i] == name) {
	  return true;
	}
  }
  return false;
}

function changeFilterDisplay() {
  filterIndex = document.forms[0].filterList.selectedIndex;
  displayFilter();
}

function changeDefaultAction() {
  var form = document.forms[0], index;
  
  if (form.filterDescrList.options.length != 0) {
    index = form.defaultAction.selectedIndex;
    filterListRunning.element[form.filterDescrList.options.length - 1] = 
	new aclElementObject("Default - " + form.defaultAction.options[index].text, form.defaultAction.options[index].value);
    form.filterDescrList.options[form.filterDescrList.options.length - 1] = 
	new Option("Default - " + form.defaultAction.options[index].text, form.defaultAction.options[index].value);
  }
}


function displayFilter(){
  var form = document.forms[0];
  var index = 0, i, element;

  clearSelectList(form.filterDescrList, 0, 
	form.filterDescrList.options.length);

  for (i = 0; i < filterListStartup[filterIndex].element.length; i++) {
    form.filterDescrList.options[i] = 
	new Option(filterListStartup[filterIndex].element[i].text, 
	           filterListStartup[filterIndex].element[i].command);
  }

  form.filterName.defaultValue = form.filterName.value = 
	filterListStartup[filterIndex].name;

  if (filterListStartup[filterIndex].element.length != 0) {
    index = filterListStartup[filterIndex].element.length - 1;
    if (form.filterDescrList.options[index].value.search("permit") != -1) {
      form.defaultAction.options[0].selected = true;
    } else {
      form.defaultAction.options[1].selected = true;
    }
  }
  form.filterList.options[filterIndex].selected = true;

  delete filterListRunning;
  index = filterListStartup[filterIndex];
  element = new Array();

  for (i = 0; i < filterListStartup[filterIndex].element.length; i++) {
    element[i] = new aclElementObject(index.element[i].text, 
	                              index.element[i].command);
  }
  filterListRunning = new aclObject(index.name, element);
  
}


function deleteFilterElement() {
  var form = document.forms[0];
  var index = form.filterDescrList.selectedIndex;

  if (index == -1) {
    var msgFormatedStr = replacedString(deleteFilterElement,typeString);
    alert(msgFormatedStr);
    //alert(warning184+ typeString + warning185);// 1193 1194
    return false;
  }

  if (index == form.filterDescrList.options.length - 1) {
    alert(warning186); //1195
    return false;
  }

  form.filterDescrList.options[index] = null;
  for (var i = index; i < form.filterDescrList.options.length; i ++) {
    filterListRunning.element[i] = null;
    filterListRunning.element[i] = filterListRunning.element[i+1];
  }
  filterListRunning.element[form.filterDescrList.options.length] = null;
  filterListRunning.element.length = form.filterDescrList.options.length;
  
  if (form.filterDescrList.options.length == 1) {
    filterListRunning.element[0] = null;
    filterListRunning.element.length = 0;
    form.filterDescrList.options[0] = null;
  }
}

function onConfigure(type)
{
  var form = document.forms[0];
  var cmd, tmpCmd, index, pattern;
  
  if (type == "createFilter") {
    cmd = createFilterCmd();
  }

  if (type == "deleteFilter") {
    cmd = deleteFilterCmd();
  }

  if (!isBlank(cmd)) {
    if (!confirm(ConfigMsg)) {
      return false;
    }
    cmd += "write memory quiet\n";
    form.comback.value = "true";
    cmd = storeCmd(cmd, form.filterName.value, cookieNameString);
    if (isBlank(cmd)) {
	  if (form.filterList.selectedIndex ) {
	    alert(warning187); //1196
      } else {
	    alert(warning188); //1197
	  }
	  return false;
    } else {
      form.action = "/" + encode(cmd);
    }
    form.VERSION.value="";
    form.NTP_SYNC.value="";
    form.showRun.value="";
    form.showVLAN.value="";
    form.vlan_ID.value= "";
    form.showAcl.value="";
    form.submit();
  }
  return true
}

function clearSelectList(selectBox, start, ii){
  for (i = start; i < ii; i++) {
    selectBox.options[start] = null;
  }
}

function sysInit()
{
  var form = document.forms[0];
  var filterName = "";
  var element = new cookieElement();
 
  if (getCookieCmd(element, cookieNameString)) {
    if (!isBlank(element.cmd)) {
      form.comback.value = "true";
      form.action = "/" + encode(element.cmd);
      form.showRun.value="";
      form.NTP_SYNC.value="";
      form.showVLAN.value="";
      form.vlan_ID.value= "";
      form.showAcl.value="";
      form.submit();
      return true;
     } else {
       filterName = element.name;
     }
  }

  if (form.comback.value != "false") {
    location.reload(true);
    return true;
  }

  initDefaultValue();
  filterAclListName(filterName);
  displayFilter();
  getAllFiltersListNames();
}

function onResize()
{
  if (document.layers && navigator.appVersion.indexOf("SunOS") != -1) {
    location.reload(true);
  } else {
    sysInit();
  }
}
