/*
 * Copyright (c) 2002, 2003, 2004 by cisco Systems, Inc.
 * All rights reserved.
 */
/*
####################################################################
### Author : Ramya
### Version :1.0
### Modified the js file to get the interface name and pattern based on the product types.
####################################################################
*/
var atg_ret_value= isATG(product);

function ifNameObject(text, value){
  this.text = text;
  this.value = value;
}

function getInterfaceName(showRun, showInt) {
  var i = 0, slot;
  var resultsName, patternName;
  var interfaceName = new Array();
  
   if (atg_ret_value == 1) 
  {
  var pattern = /![\r\n]+interface (Dot11Radio\d+)[\r\n]+/;
  }
  else if (atg_ret_value == 2)
  {
  var pattern = /![\r\n]+interface (Dot11Radio\d\/\d\/\d+)[\r\n]+/;
  }
  else
  {
  var pattern = /![\r\n]+interface (Dot11Radio\d+)[\r\n]+/;
  }
  var results;
  
  results = showRun.match(pattern);
  
  
  
  while (results != null) {
    patternName = new RegExp(results[1] + " [^\\r\\n]+[\\r\\n]+  Hardware is (\\S+) *(\\S*),");
    resultsName = showInt.match(patternName);
    
    if (resultsName != null) {
	  if (resultsName[2] == "Radio") {
	  if (atg_ret_value == 1) 
	    {
	    slot = results[1].match(/Dot11Radio(\d+)/);
	    }
	    else if (atg_ret_value == 2)
	    {
	    slot = results[1].match(/Dot11Radio(\d\/\d\/\d+)/);
	    }
	    else
	    {
	    slot = results[1].match(/Dot11Radio(\d+)/);
            }
	    	    
	    interfaceName[i]  = new ifNameObject(resultsName[2] + slot[1] + "-" + resultsName[1], results[1]);
	    
	    i++;
	  } 
    }
   
    
    results = results.input.substring(results[0].length + results.index).match(pattern);
       
  }
  
  return interfaceName;
}

function getInterfaces(showRun) {
  var results, count = 0;
  if (atg_ret_value == 1) {
     var pattern = /![\r\n]+interface (Dot11Radio\d)[\r\n]+( [^\r\n]+[\r\n]+)+/;
    }
    else if (atg_ret_value == 2)
   {
   var pattern = /![\r\n]+interface (Dot11Radio\d\/\d\/\d)[\r\n]+( [^\r\n]+[\r\n]+)+/;
   }
    else
    {
    var pattern = /![\r\n]+interface (Dot11Radio\d)[\r\n]+( [^\r\n]+[\r\n]+)+/;
    }
 
  var vlanArray = new Array();
  var subIf = new Array();
  var bridge;

  results = showRun.match(pattern);
  while (results != null) {
    subIf[count++] = results[1];
	bridge = results[3];
    results = results.input.substring(results[0].length + results.index).match(pattern);
  }
  vlanArray[0] = new vlanObject("", null, bridge, subIf, null);
  return vlanArray;
}

var filterList = new Array(new Array(), new Array(), new Array());
var MAC = 0;
var ETHERTYPE = 1;
var IP = 2;

function filterAclListName(filterNb, filterPage){

  var form = document.forms[0], count = 0;
  var pattern = null, results, filterPattern, filterNumber;

  if (filterPage) {
    filterList[filterNb][count++] = null;
  }

   if (filterNb == MAC) {
	pattern = /access-list (7\d\d) (permit|deny) +\S+ +\S+[\r\n]+/
    results = form.showRun.value.match(pattern);
  }

  if (filterNb == IP) {
    pattern = /ip access-list extended (\S+)[\r\n]+(( (permit|deny) [^\r\n]+[\r\n]+)+)/
    results = form.showRun.value.match(pattern);
  }

  if (pattern == null) {
    return false;
  }

  while (results != null) {
    if (filterNb == IP) {
      if (isValidName(results[1])) {
        if (isGoodIpFilter(results[2])) {
          filterList[filterNb][count++] = results[1];  
        }
      }
    } else {
	  filterNumber = results[1];
	  filterPattern = "(access-list " + filterNumber + " (permit|deny) +(\\S+) +(\\S+)[\\r\\n]+)+";
      results = results.input.match(filterPattern);
      if (isGoodFilter(filterNb, results[0])) {
        filterList[filterNb][count++] = filterNumber; 
      }  
    }
    results = results.input.substring(results[0].length  + results.index).match(pattern);
  }

  return true;
}

function isValidName(name){
  if (name.search(/\D/) != -1) {
    return true;
  } else {
    return false;
  } 
}

function isGoodIpElementFilter(string){
  var pattern, results;

  pattern = / (permit|deny) +(tcp|udp) any any eq \S+[\r\n]+/;
  results = string.match(pattern);
  if (results) {
    return true;
  }

  pattern = / (permit|deny) +\S+ any any[\r\n]+/;
  results = string.match(pattern);
  if (results) {
    return true;
  }

  pattern = / (permit|deny) +ip [^\r\n]+[\r\n]+/;
  results = string.match(pattern);
  if (results) {
    return true;
  }
  return false;
}

function isGoodIpFilter(descString){
  var form = window.document.forms[0];
  var pattern, results, count = 0;

  pattern = / (permit|deny) [^\r\n]+[\r\n]+/
  results = descString.match(pattern);

  while (results != null) {
    if (results.input.substring(results[0].length + results.index) != "") {
      if (!isGoodIpElementFilter(results[0])) {
        return false;
      }
    } else {
      if (results[0].search(/ (permit|deny) +ip any any[\r\n]+/) == -1) {
        return false;
      }
    }
    count++;
    results = results.input.substring(results[0].length + results.index).match(pattern);
  }

  if (count == 0) {
    return false;
  } else {
    return true;
  }
} 

/* code modified by Ramya
set the default mask to MAC as Ethertype was not supported
*/

function isGoodFilter(filterNb, filter){
  var form = window.document.forms[0];
  var pattern, results, count = 0;

  
    defaultMask = "ffff.ffff.ffff";
 

  pattern = /access-list \d+ (permit|deny) +(\S+) +(\S+)[\r\n]+/;
  results = filter.match(pattern);
  
  while (results != null) {
    if ((results.input.substring(results[0].length + results.index) == "") 
        && (results[3] != defaultMask)) {
      return false;
    }
    count++;
    results = results.input.substring(results[0].length + results.index).match(pattern);
  }

  if (count == 0) {
    return false;
  } else {
    return true;
  }
} 
