/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.util.sgz;

import com.cisco.nm.util.sgz.SgzApplet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class CachingInputStream
extends InputStream {
    private String _filename;
    private File _outF;
    private FileOutputStream _out;
    private InputStream _inp;

    CachingInputStream(String string, InputStream inputStream) throws IOException {
        this._filename = string;
        this._outF = new File(string + ".new");
        this._out = SgzApplet._Env.createFileOutputStream(this._outF);
        this._inp = inputStream;
    }

    public int read() throws IOException {
        int n;
        block2: {
            n = this._inp.read();
            if (this._out == null) break block2;
            try {
                this._out.write(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.disableCache();
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block2: {
            n3 = this._inp.read(byArray, n, n2);
            if (this._out == null) break block2;
            try {
                this._out.write(byArray, n, n3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.disableCache();
            }
        }
        return n3;
    }

    public void close() throws IOException {
        this._inp.close();
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.disableCache();
            }
        }
        SgzApplet._Env.fileRenameTo(this._outF, new File(this._filename));
    }

    void write(byte[] byArray) throws IOException {
        block2: {
            if (this._out == null) break block2;
            try {
                this._out.write(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.disableCache();
            }
        }
    }

    private void disableCache() {
        try {
            this._out = null;
            this._outF.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

