/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.util.sgz;

import com.cisco.nm.util.sgz.Loader;
import com.cisco.nm.util.sgz.SgzApplet;
import com.cisco.nm.util.sgz.SgzReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;

class Httpd
extends Thread {
    private static final boolean DEBUG = false;
    private static Httpd _Httpd;
    ServerSocket _socket = Httpd.createServerSocket();
    static int _LocalPort;
    String _localhostAddress = "127.0.0.1";
    int _threadCount = 0;
    static final int MAX_THREAD_COUNT = 5;
    static final String SERVER_VERSION = "SGZHTTPD 1.0";
    private static final Hashtable _ContentTypeMap;

    Httpd() throws IOException {
    }

    private static ServerSocket createServerSocket() throws IOException {
        int n = 0;
        while (n < 3) {
            try {
                ServerSocket serverSocket = new ServerSocket(_LocalPort);
                _LocalPort = serverSocket.getLocalPort();
                return serverSocket;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                _LocalPort = 0;
                ++n;
            }
        }
        throw new IOException("unable to create server socket");
    }

    static String createHttpd() {
        try {
            _Httpd = new Httpd();
            _Httpd.start();
            return "http://" + Httpd._Httpd._localhostAddress + ":" + Httpd._Httpd._socket.getLocalPort();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static void kill() {
        try {
            Httpd._Httpd._socket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run() {
        try {
            while (true) {
                Socket socket;
                String string;
                if (!(string = (socket = SgzApplet.socketAccept(this._socket)).getInetAddress().getHostAddress()).equals(this._localhostAddress)) {
                    socket.close();
                    continue;
                }
                if (this._threadCount >= 5) {
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write("HTTP/1.0 503 Service unavailable\r\nServer: SGZHTTPD 1.0\r\nConnection: close\r\n\r\nServer overloaded. Plase try again later.\r\n".getBytes());
                    outputStream.close();
                    socket.close();
                    continue;
                }
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Httpd httpd = Httpd.this;
                        synchronized (httpd) {
                            ++Httpd.this._threadCount;
                        }
                        Httpd.this.handleRequest(socket);
                        Httpd httpd2 = Httpd.this;
                        synchronized (httpd2) {
                            --Httpd.this._threadCount;
                        }
                    }
                }.start();
            }
        }
        catch (Exception exception) {
            block5: {
                if (!Loader._Verbose) break block5;
                exception.printStackTrace();
            }
            return;
        }
    }

    void handleRequest(Socket socket) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null && string.length() >= 1) {
                int n;
                if (!string.startsWith("GET /") || (n = string.indexOf(" HTTP/")) <= -1) continue;
                if (Loader._Verbose) {
                    System.out.println("Httpd: " + string);
                }
                string2 = string.substring(5, n);
            }
            if (string2 != null) {
                int n = string2.indexOf(63);
                if (n > -1) {
                    string2 = string2.substring(0, n);
                }
                byte[] byArray = SgzReader._Reader.getEntryBytes(string2);
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(("HTTP/1.0 200 OK\r\nServer: SGZHTTPD 1.0\r\nContent-Type: " + this.getContentType(string2) + "\r\n" + "Content-Length: " + byArray.length + "\r\n" + "Connection: Keep-Alive\r\n\r\n").getBytes());
                outputStream.write(byArray);
                outputStream.close();
            }
            socket.close();
        }
        catch (Exception exception) {
            try {
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write("HTTP/1.0 404 Not Found\r\nServer: SGZHTTPD 1.0\r\nConnection: close\r\n\r\n".getBytes());
                outputStream.close();
                socket.close();
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    private String getContentType(String string) {
        Object v;
        int n = string.lastIndexOf(46);
        if (n > -1 && (v = _ContentTypeMap.get(string.substring(n + 1))) != null) {
            return (String)v;
        }
        return "application/octet-stream";
    }

    static {
        _LocalPort = 0;
        _ContentTypeMap = new Hashtable();
        _ContentTypeMap.put("class", "application/octet-stream");
        _ContentTypeMap.put("css", "text/css");
        _ContentTypeMap.put("gif", "image/gif");
        _ContentTypeMap.put("htm", "text/html");
        _ContentTypeMap.put("html", "text/html");
        _ContentTypeMap.put("jpg", "image/jpeg");
    }
}

