/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.util.sgz;

import com.cisco.nm.util.sgz.CachingInputStream;
import com.cisco.nm.util.sgz.Httpd;
import com.cisco.nm.util.sgz.JarEntry;
import com.cisco.nm.util.sgz.Loader;
import com.cisco.nm.util.sgz.SgzApplet;
import com.cisco.nm.util.sgz.StoredJarEntry;
import com.cisco.nm.util.sgz.Verifier;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;

public class SgzReader {
    static final boolean DEBUG = false;
    private Hashtable _entryTab = new Hashtable();
    private long _bytesRead;
    boolean _isSigned;
    String _httpdHostPort;
    private Toolkit _toolkit;
    static SgzReader _Reader;
    private String _awaitingName;
    private boolean _loadingCompleted;

    static SgzReader New() {
        if (_Reader == null) {
            _Reader = !Loader._TraceLoading ? new SgzReader() : new SgzReader(){
                Vector msgVec = new Vector();

                private void appMsg(String string, String string2) {
                    String string3 = "SgzReader." + string + "@" + System.currentTimeMillis() + ": " + string2;
                    if (this.msgVec == null) {
                        System.out.println(string3);
                    } else {
                        this.msgVec.addElement(string3);
                    }
                }

                void loadFromStream(InputStream inputStream, String string) {
                    this.appMsg("loadFromStream", string);
                    super.loadFromStream(inputStream, string);
                }

                synchronized JarEntry retrieveEntry(String string) {
                    this.appMsg("retrieveEntry", string);
                    return super.retrieveEntry(string);
                }

                synchronized void loadingCompleted() {
                    super.loadingCompleted();
                    this.appMsg("loadingCompleted", "done");
                    Enumeration enumeration = this.msgVec.elements();
                    while (enumeration.hasMoreElements()) {
                        System.out.println(enumeration.nextElement());
                    }
                    this.msgVec = null;
                }
            };
        }
        SgzReader._Reader._httpdHostPort = Httpd.createHttpd();
        SgzReader._Reader._toolkit = Toolkit.getDefaultToolkit();
        if (Loader._Verbose) {
            System.out.println("httpd port = " + SgzReader._Reader._httpdHostPort);
        }
        return _Reader;
    }

    private int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = inputStream.read(byArray, n, n2);
            if (n4 < 0) break;
            n3 += n4;
            n += n4;
            n2 -= n4;
        }
        this._bytesRead += (long)n3;
        return n3;
    }

    void loadFromStream(InputStream inputStream, String string) {
        try {
            Object object;
            Object object2;
            byte by;
            block16: {
                byte[] byArray = new byte[17];
                inputStream.read(byArray);
                byte[] byArray2 = new byte[16];
                System.arraycopy(byArray, 0, byArray2, 0, 16);
                by = byArray[16];
                if (Loader._Verbose) {
                    System.out.println("compression = " + by);
                }
                try {
                    if (SgzApplet._CacheDir != null) {
                        object2 = SgzApplet._CacheDir + "/" + SgzReader.toHex(byArray2) + ".sgz";
                        object = new File((String)object2);
                        if (SgzApplet._Env.fileExists((File)object)) {
                            if (Loader._Verbose) {
                                System.out.println("SgzReader: using cached archive " + (String)object2);
                            }
                            inputStream.close();
                            inputStream = SgzApplet._Env.createFileInputStream((File)object);
                            inputStream.read(byArray);
                        } else {
                            if (Loader._Verbose) {
                                System.out.println("SgzReader: storing archive " + (String)object2 + " in cache");
                            }
                            CachingInputStream cachingInputStream = new CachingInputStream((String)object2, inputStream);
                            cachingInputStream.write(byArray);
                            inputStream = cachingInputStream;
                        }
                    }
                }
                catch (Exception exception) {
                    SgzApplet._CacheException = exception;
                    if (!Loader._Verbose) break block16;
                    exception.printStackTrace();
                }
            }
            switch (by) {
                case 0: {
                    object2 = inputStream;
                    break;
                }
                case 2: {
                    object2 = new CBZip2InputStream(inputStream);
                    break;
                }
                default: {
                    object2 = new GZIPInputStream(inputStream);
                }
            }
            object = new byte[1024];
            while (this.read((InputStream)object2, (byte[])object, 0, 2) == 2) {
                int n;
                byte[] byArray;
                int n2 = SgzReader.get2(object, 0);
                while (((byte[])object).length < n2) {
                    object = new byte[2 * ((byte[])object).length];
                }
                if (this.read((InputStream)object2, (byte[])object, 0, n2) != n2) break;
                String string2 = new String((byte[])object, 0, n2);
                if (this.read((InputStream)object2, (byte[])object, 0, 4) != 4 || this.read((InputStream)object2, byArray = new byte[n = (int)SgzReader.get4(object, 0)], 0, n) != n) break;
                StoredJarEntry storedJarEntry = new StoredJarEntry();
                storedJarEntry._data = byArray;
                this.storeEntry(string2, storedJarEntry);
            }
            ((InputStream)object2).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    synchronized void loadingCompleted() {
        this._loadingCompleted = true;
        if (this._awaitingName != null) {
            this.notify();
            this._awaitingName = null;
        }
    }

    private synchronized void storeEntry(String string, JarEntry jarEntry) {
        if (string.equals("SIGNATURE")) {
            if (Verifier.init(jarEntry._data)) {
                this._isSigned = true;
                if (Loader._Verbose) {
                    System.out.println("SgzReader: ADP is signed");
                }
            }
        } else {
            if (this._isSigned && !Verifier.verify(jarEntry._data)) {
                this._isSigned = false;
                if (Loader._Verbose) {
                    System.out.println("SgzReader: signing failed for " + string);
                }
            }
            if (this._entryTab.get(string) != null) {
                return;
            }
            this._entryTab.put(string, jarEntry);
            if (string.equals(this._awaitingName)) {
                this.notify();
            }
        }
    }

    synchronized JarEntry retrieveEntry(String string) {
        Object v = this._entryTab.get(string);
        if (this._loadingCompleted || v != null) {
            return (JarEntry)v;
        }
        this._awaitingName = string;
        try {
            this.wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._awaitingName = null;
        return (JarEntry)this._entryTab.get(string);
    }

    byte[] getEntryBytes(String string) {
        JarEntry jarEntry = this.retrieveEntry(string);
        return jarEntry != null ? jarEntry.getBytes() : null;
    }

    InputStream getEntryStream(String string) {
        JarEntry jarEntry = this.retrieveEntry(string);
        return jarEntry != null ? jarEntry.getStream() : null;
    }

    URL getEntryURL(String string) {
        try {
            if (this.retrieveEntry(string) != null) {
                return new URL(this._httpdHostPort + "/" + string);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    Image getEntryAsImage(String string) {
        return this._toolkit.createImage(this.getEntryBytes(string));
    }

    void removeEntry(String string) {
        this._entryTab.remove(string);
    }

    static int get2(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    static long get4(byte[] byArray, int n) {
        return (long)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8) | (long)(byArray[n + 2] & 0xFF) << 16 | (long)(byArray[n + 3] & 0xFF) << 24;
    }

    static String toHex1(int n) {
        return Integer.toHexString(n >> 4 & 0xF) + Integer.toHexString(n & 0xF);
    }

    static String toHex(byte[] byArray) {
        return byArray == null ? null : SgzReader.toHex(byArray, 0, byArray.length);
    }

    static String toHex(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(SgzReader.toHex1(byArray[n + n3]));
            ++n3;
        }
        return stringBuffer.toString();
    }
}

