/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.util.sgz;

import com.cisco.nm.util.sgz.SgzReader;
import com.cisco.nm.util.sgz.security.MD5;
import com.cisco.nm.util.sgz.security.RIPEMD160_RSA_PKCS1Signature;
import com.cisco.nm.util.sgz.security.RawRSAPublicKey;
import java.io.IOException;
import java.io.InputStream;

public class Verifier {
    private static final boolean DEBUG = false;
    private static int _Src;
    private static byte[] _HashData;
    private static int _HashDataPtr;
    private static RawRSAPublicKey _PublicKey;
    private static RIPEMD160_RSA_PKCS1Signature _Signer;
    private static MD5 _Hasher;
    static final String SIG_FILENAME = "SIGNATURE";
    public static final Class _Class;
    static /* synthetic */ Class class$com$cisco$nm$util$sgz$Verifier;

    private static void readPublicKey() throws IOException {
        String string = "/" + _Class.getName().replace('.', '/');
        int n = string.lastIndexOf(47);
        if (n > -1) {
            string = string.substring(0, n);
        }
        InputStream inputStream = _Class.getResourceAsStream(string + "/publickey.t");
        _PublicKey = new RawRSAPublicKey(inputStream);
        inputStream.close();
        _Signer = new RIPEMD160_RSA_PKCS1Signature();
        _Hasher = new MD5();
    }

    static boolean init(byte[] byArray) {
        try {
            if (_PublicKey == null) {
                Verifier.readPublicKey();
            }
            _HashDataPtr = 4;
            _HashData = byArray;
            int n = (int)SgzReader.get4(_HashData, 0);
            byte[] byArray2 = new byte[byArray.length - n];
            System.arraycopy(_HashData, n, byArray2, 0, byArray.length - n);
            _Signer.initVerify(_PublicKey);
            _Signer.update(_HashData, 4, n - 4);
            boolean bl = _Signer.verify(byArray2);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static boolean verify(byte[] byArray) {
        _Hasher.reset();
        try {
            _Hasher.update(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            return false;
        }
        byte[] byArray2 = _Hasher.digest();
        if (_HashDataPtr + byArray2.length >= _HashData.length) {
            return false;
        }
        int n = 0;
        while (n < byArray2.length) {
            if (byArray2[n] != _HashData[_HashDataPtr++]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _HashDataPtr = 0;
        _Class = class$com$cisco$nm$util$sgz$Verifier == null ? (class$com$cisco$nm$util$sgz$Verifier = Verifier.class$("com.cisco.nm.util.sgz.Verifier")) : class$com$cisco$nm$util$sgz$Verifier;
    }
}

