/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.util.sgz.security;

import com.cisco.nm.util.sgz.security.CryptixRSAPublicKey;
import com.cisco.nm.util.sgz.security.RIPEMD160;
import com.cisco.nm.util.sgz.security.RSAAlgorithm;
import com.cisco.nm.util.sgz.security.RSAFactors;
import com.cisco.nm.util.sgz.security.RawRSAPublicKey;
import com.cisco.nm.util.sgz.security.Signature;
import java.io.PrintWriter;
import java.math.BigInteger;

public abstract class Any_RSA_PKCS1Signature
extends Signature {
    private static final boolean DEBUG = false;
    private static final int debuglevel = 0;
    private static final PrintWriter err = null;
    private static final int POSITIVE = 1;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private BigInteger n;
    private BigInteger exp;
    private BigInteger p;
    private BigInteger q;
    private BigInteger u;
    private RIPEMD160 md;

    private static void debug(String string) {
        err.println("Any_RSA_PKCS1Signature: " + string);
    }

    protected Any_RSA_PKCS1Signature(RIPEMD160 rIPEMD160) {
        this.md = rIPEMD160;
    }

    protected void engineInitVerify(RawRSAPublicKey rawRSAPublicKey) throws Exception {
        if (!(rawRSAPublicKey instanceof CryptixRSAPublicKey)) {
            throw new Exception(this.getAlgorithm() + ": Not an RSA public key");
        }
        RawRSAPublicKey rawRSAPublicKey2 = rawRSAPublicKey;
        this.n = rawRSAPublicKey2.getModulus();
        this.exp = rawRSAPublicKey2.getExponent();
        if (rawRSAPublicKey instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)((Object)rawRSAPublicKey);
            this.p = rSAFactors.getP();
            this.q = rSAFactors.getQ();
            this.u = rSAFactors.getInverseOfQModP();
        }
        this.md.reset();
        int n = this.md.digest().length;
        int n2 = (this.n.bitLength() + 7) / 8;
        int n3 = this.getAlgorithmEncoding().length;
        int n4 = n2 - 3 - n3 - n;
        if (n4 < 0) {
            throw new Exception("Signer's public key modulus too short.");
        }
    }

    protected void engineUpdate(byte by) throws Exception {
        this.md.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws Exception {
        this.md.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws Exception {
        long l = 0L;
        BigInteger bigInteger = this.makePKCS1();
        BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.n, this.exp, this.p, this.q, this.u);
        return bigInteger2.toByteArray();
    }

    protected boolean engineVerify(byte[] byArray) throws Exception {
        long l = 0L;
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.n, this.exp, this.p, this.q, this.u);
        BigInteger bigInteger3 = this.makePKCS1();
        boolean bl = bigInteger2.equals(bigInteger3);
        return bl;
    }

    protected void engineSetParameter(String string, Object object) throws Exception {
        throw new Exception(this.getAlgorithm() + ": " + string);
    }

    protected Object engineGetParameter(String string) throws Exception {
        throw new Exception(this.getAlgorithm() + ": " + string);
    }

    private BigInteger makePKCS1() throws Exception {
        byte[] byArray = this.md.digest();
        int n = byArray.length;
        int n2 = (this.n.bitLength() + 7) / 8;
        byte[] byArray2 = new byte[n2];
        byArray2[1] = 1;
        byte[] byArray3 = this.getAlgorithmEncoding();
        int n3 = byArray3.length;
        int n4 = n2 - 3 - n3 - n;
        if (n4 < 0) {
            throw new Exception("Signer's public key modulus too short.");
        }
        int n5 = 0;
        while (n5 < n4) {
            byArray2[2 + n5++] = -1;
        }
        System.arraycopy(byArray3, 0, byArray2, n4 + 3, n3);
        System.arraycopy(byArray, 0, byArray2, n2 - n, n);
        return new BigInteger(byArray2);
    }

    protected abstract byte[] getAlgorithmEncoding();
}

