/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.util.sgz.security;

import com.cisco.nm.util.sgz.security.BI;
import com.cisco.nm.util.sgz.security.BaseRSAPublicKey;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigInteger;

public class RawRSAPublicKey
extends BaseRSAPublicKey {
    private static final boolean DEBUG = false;
    private static final int debuglevel = 0;
    private static final PrintWriter err = null;
    private static final BigInteger F4 = BigInteger.valueOf(65537L);

    private static void debug(String string) {
        err.println("RawRSAPublicKey: " + string);
    }

    public RawRSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.setRsaParams(bigInteger, bigInteger2);
    }

    public RawRSAPublicKey(BigInteger bigInteger) {
        this(bigInteger, F4);
    }

    public RawRSAPublicKey(InputStream inputStream) throws IOException {
        BigInteger bigInteger = BI.fromStream(inputStream);
        BigInteger bigInteger2 = BI.fromStream(inputStream);
        this.setRsaParams(bigInteger2, bigInteger);
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        try {
            BI.toStream(this.getExponent(), bufferedOutputStream);
            BI.toStream(this.getModulus(), bufferedOutputStream);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

