/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import netscape.javascript.JSObject;
import netscape.security.PrivilegeManager;

public class MiniWebSvr
extends Applet {
    private Httpd _Httpd;
    private int _port = 80;
    private static String rootPath = "C:\\Program Files\\Cisco Systems\\MWS";
    static final int MAX_THREAD_COUNT = 5;
    static final String SERVER_VERSION = "MiniWebSvr 1.0";
    static final int BLOCK_SIZE = 32768;
    private static int MAX_TRIES = 10;
    private static boolean DEBUG;
    private static final Hashtable _ContentTypeMap;

    private static String reformat(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = "";
        while ((n = string.indexOf("%20", n)) != -1) {
            string2 = String.valueOf(string2) + string.substring(n2, n) + " ";
            n = n2 = n + 3;
        }
        string2 = String.valueOf(string2) + string.substring(n2);
        return string2;
    }

    String createHttpd(Applet applet) {
        try {
            if (this._Httpd == null) {
                this._Httpd = new Httpd(applet);
                this._Httpd.start();
                return "http://" + this._Httpd._localhostAddress + ":" + this._Httpd._socket.getLocalPort();
            }
            return "Already started";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    void kill() {
        try {
            this._Httpd._socket.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static String getContentType(String string) {
        Object v;
        int n = string.lastIndexOf(46);
        if (n > -1 && (v = _ContentTypeMap.get(string.substring(n + 1))) != null) {
            return (String)v;
        }
        return "application/octet-stream";
    }

    public void init() {
    }

    public void destroy() {
    }

    public void start() {
        String string;
        String string2;
        SecurityManager securityManager = null;
        securityManager = System.getSecurityManager();
        PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
        PrivilegeManager.enablePrivilege((String)"UniversalFileWrite");
        PrivilegeManager.enablePrivilege((String)"UniversalConnect");
        try {
            securityManager.checkPropertiesAccess();
        }
        catch (SecurityException securityException) {
            JSObject jSObject = JSObject.getWindow(this);
            Integer n = new Integer(0);
            jSObject.call("setPort", new Integer[]{n});
            return;
        }
        String string3 = this.getParameter("DEBUG");
        if (string3 != null && !string3.equals("")) {
            DEBUG = true;
        }
        if ((string2 = this.getParameter("ROOTPATH")) != null && string2.length() != 0) {
            rootPath = MiniWebSvr.reformat(string2);
        }
        if ((string = this.getParameter("PORT")) != null && string.length() != 0) {
            try {
                this._port = Integer.parseInt(string);
                this.createHttpd(this);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        int n = MAX_TRIES;
        while (n > 0) {
            try {
                double d = Math.random() * 5000.0;
                this._port = (int)d + 5000;
                this._Httpd = new Httpd(this);
                JSObject jSObject = JSObject.getWindow(this);
                Integer n2 = new Integer(this._port);
                jSObject.call("setPort", new Integer[]{n2});
                this._Httpd.start();
                break;
            }
            catch (Exception exception) {
                if (DEBUG) {
                    exception.printStackTrace();
                }
                --n;
            }
        }
        if (n == 0) {
            if (DEBUG) {
                System.out.println("Cannot start web server");
            }
            return;
        }
    }

    public void stop() {
        if (this._Httpd != null) {
            this.kill();
        }
    }

    static {
        _ContentTypeMap = new Hashtable();
        _ContentTypeMap.put("class", "application/octet-stream");
        _ContentTypeMap.put("css", "text/css");
        _ContentTypeMap.put("gif", "image/gif");
        _ContentTypeMap.put("htm", "text/html");
        _ContentTypeMap.put("html", "text/html");
        _ContentTypeMap.put("shtml", "text/html");
        _ContentTypeMap.put("jpg", "image/jpeg");
    }

    class Httpd
    extends Thread {
        ServerSocket _socket;
        String _localhostAddress;
        int _threadCount;
        Applet _applet;
        boolean goodbyeOccurred = false;

        Httpd(Applet applet) throws IOException {
            MiniWebSvr.this = MiniWebSvr.this;
            this._applet = applet;
            this._socket = new ServerSocket(MiniWebSvr.this._port);
            this._localhostAddress = "127.0.0.1";
        }

        public void run() {
            try {
                while (true) {
                    Socket socket;
                    String string;
                    if (!(string = (socket = this._socket.accept()).getInetAddress().getHostAddress()).equals(this._localhostAddress)) {
                        if (DEBUG) {
                            System.out.println("*** rejecting request from " + string);
                        }
                        socket.close();
                        continue;
                    }
                    if (this._threadCount >= 5) {
                        OutputStream outputStream = socket.getOutputStream();
                        outputStream.write("HTTP/1.0 503 Service unavailable\r\nServer: MiniWebSvr 1.0\r\nConnection: close\r\n\r\nServer overloaded. Plase try again later.\r\n".getBytes());
                        outputStream.close();
                        socket.close();
                        continue;
                    }
                    new 1(socket, this).start();
                }
            }
            catch (Exception exception) {
                if (DEBUG) {
                    if (exception.getMessage().indexOf("socket") != -1 && exception.getMessage().indexOf("closed") != -1) {
                        if (DEBUG) {
                            System.out.println("MiniWebSvr: terminating");
                        }
                    } else {
                        exception.printStackTrace();
                    }
                }
                return;
            }
        }

        void handleRequest(Socket socket) {
            String string = "";
            String string2 = null;
            String string3 = null;
            String string4 = null;
            try {
                int n;
                String string5;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                while ((string5 = bufferedReader.readLine()) != null && string5.length() >= 1) {
                    if (!string5.startsWith("GET /") || (n = string5.indexOf(" HTTP/")) <= -1) continue;
                    if (DEBUG) {
                        System.out.println("MiniWebSvr: " + string5);
                    }
                    string2 = string5.substring(5, n);
                }
                if (string2.indexOf("GOODBYE") != -1) {
                    this.goodbyeOccurred = true;
                    return;
                }
                int n2 = string2.indexOf("ROOTPATH=");
                if (n2 != -1) {
                    n = string2.indexOf("&", n2);
                    if (n == -1) {
                        n = string2.length();
                    }
                    string3 = MiniWebSvr.reformat(string2.substring(n2 + 9, n));
                }
                if (string2 != null) {
                    n = string2.indexOf(63);
                    if (n > -1) {
                        string2 = string2.substring(0, n);
                    }
                    string = string2;
                    if (string3 != null) {
                        string4 = rootPath;
                        rootPath = string3;
                    }
                    if (rootPath != null) {
                        string = String.valueOf(rootPath) + "/" + string2;
                    }
                    File file = new File(string);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    byte[] byArray = new byte[32768];
                    OutputStream outputStream = socket.getOutputStream();
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                    bufferedOutputStream.write(("HTTP/1.0 200 OK\r\nServer: MiniWebSvr 1.0\r\nContent-Type: " + MiniWebSvr.getContentType(string2) + "\r\n" + "Content-Length: " + file.length() + "\r\n" + "Connection: Keep-Alive\r\n\r\n").getBytes());
                    int n3 = 0;
                    while ((n3 = bufferedInputStream.read(byArray)) > 0) {
                        bufferedOutputStream.write(byArray, 0, n3);
                    }
                    ((FilterInputStream)bufferedInputStream).close();
                    if (n3 != -1) {
                        bufferedOutputStream.write(byArray, 0, n3);
                    }
                    bufferedOutputStream.close();
                }
                socket.close();
                return;
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.out.println("MiniWebSvr: warning on file " + string);
                }
                try {
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write("HTTP/1.0 404 Not Found\r\nServer: MiniWebSvr 1.0\r\nConnection: close\r\n\r\n".getBytes());
                    outputStream.close();
                    socket.close();
                    return;
                }
                catch (Exception exception2) {
                    return;
                }
            }
        }

        static /* synthetic */ MiniWebSvr access$0(Httpd httpd) {
            return httpd.MiniWebSvr.this;
        }
    }
}

