/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.BaseNode;
import com.cisco.nm.xms.cliparser.ChoiceNode;
import com.cisco.nm.xms.cliparser.CliContainer;
import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.ClipArgs;
import com.cisco.nm.xms.cliparser.CmdSet;
import com.cisco.nm.xms.cliparser.CmdTree;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.Debug;
import com.cisco.nm.xms.cliparser.GrammarLocator;
import com.cisco.nm.xms.cliparser.KeywordNode;
import com.cisco.nm.xms.cliparser.KeywordParamNode;
import com.cisco.nm.xms.cliparser.ModeNode;
import com.cisco.nm.xms.cliparser.util.Comparable;
import com.cisco.nm.xms.cliparser.util.Sort;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class CliBuilder {
    CmdSet _cmdSet;
    ConfigValues _configValues;
    String _iosVersion;
    String _deviceType;
    String _goPath;
    CmdSet _modeCmdSet;
    Vector _clis;
    Vector _noClis;
    static final int FIRST_PASS = 1;
    static final int SECOND_PASS = 2;
    static final int ONLY_ONE_PASS = 3;
    private static final long MAX_VALUE = Long.MAX_VALUE;
    private static boolean _repeat;
    private long _nextCliPriority;

    public CliBuilder(String iosVersion, String deviceType, String goPath) throws CliGPBException {
        this._iosVersion = iosVersion;
        this._deviceType = deviceType;
        this._goPath = goPath;
        this._cmdSet = GrammarLocator.getCmdSet(this._iosVersion, this._deviceType, this._goPath);
    }

    public CliBuilder(CmdSet cmdSet) {
        this._cmdSet = cmdSet;
    }

    public CmdSet getCmdSet() {
        return this._cmdSet;
    }

    public Vector getClis(ConfigValues configValues) throws CliGPBException {
        return this.getClis(configValues, true);
    }

    public Vector getClis(ConfigValues configValues, boolean bNoCmdsFirst) throws CliGPBException {
        return this.getClis(configValues, bNoCmdsFirst, false);
    }

    public Vector getClis(ConfigValues configValues, ClipArgs args) throws CliGPBException {
        return this.getClis(configValues, args.noCmdsFirst, args.encryptData, args.sortClis, false);
    }

    public Vector getClis(ConfigValues configValues, boolean bNoCmdsFirst, boolean encryptData) throws CliGPBException {
        return this.getClis(configValues, bNoCmdsFirst, encryptData, false);
    }

    public Vector getClis(ConfigValues configValues, boolean bNoCmdsFirst, boolean encryptData, boolean sortClis) throws CliGPBException {
        return this.getClis(configValues, bNoCmdsFirst, encryptData, sortClis, false);
    }

    public CliContainer[] getCliContainers(ConfigValues configValues, ClipArgs args) throws CliGPBException {
        Vector v = this.getClis(configValues, args.noCmdsFirst, args.encryptData, args.sortClis, true);
        if (v.size() == 0) {
            return null;
        }
        Object[] result = new CliContainer[v.size()];
        v.copyInto(result);
        return result;
    }

    private Vector getClis(ConfigValues configValues, boolean bNoCmdsFirst, boolean encryptData, boolean sortClis, boolean wrapCli) throws CliGPBException {
        Debug.log(this, " *********  CLI BUILDER ***********", 1);
        if (this._cmdSet == null) {
            this._cmdSet = GrammarLocator.getCmdSet(this._iosVersion, this._deviceType, this._goPath);
        }
        this._clis = new Vector();
        this._noClis = new Vector();
        this._configValues = configValues;
        if (bNoCmdsFirst) {
            this.buildConfigClis(this._configValues, this._cmdSet, this._noClis, 1, 0, encryptData, sortClis, wrapCli);
            this.buildConfigClis(this._configValues, this._cmdSet, this._clis, 2, 0, encryptData, sortClis, wrapCli);
        } else {
            this.buildConfigClis(this._configValues, this._cmdSet, this._clis, 3, 0, encryptData, sortClis, wrapCli);
        }
        if (sortClis) {
            this.sort(this._noClis);
            this.sort(this._clis);
        }
        Vector result = this.appendVectors(this._clis, this._noClis, wrapCli);
        return result;
    }

    private void sort(Vector v) {
        int size = v.size();
        if (size != 0) {
            Object[] clis = new CliContainer[size];
            v.copyInto(clis);
            Sort.insertionSort((Comparable[])clis);
            v.removeAllElements();
            int i = 0;
            while (i < size) {
                v.addElement(clis[i]);
                ++i;
            }
        }
    }

    private Vector appendVectors(Vector _clis, Vector _noClis, boolean wrapCli) {
        Vector<Object> result = new Vector<Object>();
        int i = 0;
        while (i < _noClis.size()) {
            CliContainer nextcli = (CliContainer)_noClis.elementAt(i);
            if (wrapCli) {
                result.addElement(nextcli);
            } else {
                result.addElement(nextcli._cli);
            }
            if (nextcli.subcmds != null) {
                int j = 0;
                while (j < nextcli.subcmds.size()) {
                    result.addElement(nextcli.subcmds.elementAt(j));
                    ++j;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < _clis.size()) {
            CliContainer nextcli = (CliContainer)_clis.elementAt(i2);
            if (wrapCli) {
                result.addElement(nextcli);
            } else {
                result.addElement(nextcli._cli);
            }
            if (nextcli.subcmds != null) {
                int j = 0;
                while (j < nextcli.subcmds.size()) {
                    result.addElement(nextcli.subcmds.elementAt(j));
                    ++j;
                }
            }
            ++i2;
        }
        return result;
    }

    private CliContainer addCli(StringBuffer cli, Vector clis, long priority, CmdValues cv) {
        String cliStr = cli.toString();
        Debug.log(this, cliStr, 1);
        CliContainer nextCli = null;
        if (_repeat) {
            StringTokenizer st = new StringTokenizer(cliStr, String.valueOf('\u1234'));
            while (st.hasMoreTokens()) {
                String oneCli = st.nextToken();
                nextCli = new CliContainer(priority++, oneCli, cv);
                this.debug(2, "CLI --> " + nextCli.toString());
                clis.addElement(nextCli);
            }
            _repeat = false;
        } else {
            String oneCli = cliStr;
            nextCli = new CliContainer(priority++, oneCli, cv);
            this.debug(2, "CLI --> " + nextCli.toString());
            clis.addElement(nextCli);
        }
        return nextCli;
    }

    private void debug(String message) {
        this.debug(1, message);
    }

    private void debug(int level, String message) {
        Debug.log(this, message, level);
    }

    private void error(String message) {
        Debug.log(this, "%%%%% ERROR: " + message, 4);
    }

    private void buildConfigClis(ConfigValues configValues, CmdSet cmdSet, Vector clis, int whichPass, int nestedLevel, boolean encryptData, boolean sortClis, boolean wrapCli) throws CliGPBException {
        this.debug("inside buildConfigClis " + whichPass + " Pass");
        this.debug("--- num commands = " + configValues.numCmds());
        int i = 0;
        while (i < configValues.numCmds()) {
            CmdValues cmdValues = configValues.getCmdValues(i);
            StringBuffer cmdStr = new StringBuffer();
            if (whichPass == 3 || whichPass == 1 && cmdValues.getAction() == 2 || whichPass == 2 && cmdValues.getAction() != 2) {
                this.buildCmdClis(cmdValues, cmdSet, cmdStr, nestedLevel, encryptData);
                CliContainer mycliobj = this.addCli(cmdStr, clis, this._nextCliPriority, cmdValues);
                ConfigValues modeConfigValues = cmdValues.getModeCmdsValues();
                if (modeConfigValues != null) {
                    Vector result;
                    Vector myclis = new Vector();
                    Vector noclis = new Vector();
                    ++nestedLevel;
                    if (whichPass == 3) {
                        this.buildConfigClis(modeConfigValues, this._modeCmdSet, myclis, whichPass, nestedLevel, encryptData, sortClis, wrapCli);
                    } else {
                        CmdSet temp = this._modeCmdSet;
                        this.buildConfigClis(modeConfigValues, this._modeCmdSet, noclis, 1, nestedLevel, encryptData, sortClis, wrapCli);
                        this._modeCmdSet = temp;
                        this.buildConfigClis(modeConfigValues, this._modeCmdSet, myclis, 2, nestedLevel, encryptData, sortClis, wrapCli);
                    }
                    StringBuffer exitCli = new StringBuffer();
                    this.addIndent(exitCli, nestedLevel);
                    exitCli.append("exit");
                    this.addCli(exitCli, myclis, Long.MAX_VALUE, null);
                    --nestedLevel;
                    if (sortClis) {
                        this.sort(noclis);
                        this.sort(myclis);
                    }
                    mycliobj.subcmds = result = this.appendVectors(myclis, noclis, wrapCli);
                }
            }
            ++i;
        }
    }

    private void addIndent(StringBuffer cmdStr, int nestedLevel) {
        int i = 0;
        while (i < nestedLevel) {
            cmdStr.append(' ');
            ++i;
        }
    }

    private void buildCmdClis(CmdValues cmdValues, CmdSet cmdSet, StringBuffer cmdStr, int nestedLevel, boolean encryptData) throws CliGPBException {
        this.debug("inside buildCmdClis()");
        String cmdName = cmdValues.getCmdName();
        this.addIndent(cmdStr, nestedLevel);
        this.debug("----- cmd = " + cmdName);
        if (cmdName.equals("extraCmd")) {
            cmdStr.append(cmdValues.getValue("extraCmdValue"));
            ++this._nextCliPriority;
            return;
        }
        Vector cmdTrees = cmdSet.findCmdTrees(cmdName);
        if (cmdTrees.size() == 0) {
            throw new CliGPBException("Unrecognized command in config values: " + cmdName + "\nCmdValues: " + cmdValues);
        }
        int saveAction = cmdValues.getAction();
        boolean bFixedUpForChangeActionDelete = false;
        int i = 0;
        while (i < cmdTrees.size()) {
            block19: {
                CmdTree cmdTree;
                block18: {
                    cmdTree = (CmdTree)cmdTrees.elementAt(i);
                    this._nextCliPriority = cmdTree.getPriority() * 100;
                    if (saveAction == 3) {
                        if (cmdTree.getCmdType() == 2) {
                            if (!bFixedUpForChangeActionDelete) {
                                cmdValues.fixUpForChangeActionDelete();
                                bFixedUpForChangeActionDelete = true;
                            }
                        } else {
                            cmdValues.setAction(1);
                        }
                    }
                    if (cmdValues.getAction() != 2) break block18;
                    if (!cmdTree.hasNoCmd()) break block19;
                    cmdStr.append("no" + String.valueOf(' '));
                }
                if (cmdValues.getAction() == 1 && cmdValues.isDefaultCmd()) {
                    cmdStr.append("default" + String.valueOf(' '));
                }
                if (cmdTree.hasSeq() && cmdValues.getSeq() != -1) {
                    cmdStr.append(cmdValues.getValue("__SEQ"));
                    cmdStr.append(' ');
                }
                cmdStr.append(cmdName);
                try {
                    this.buildNodeClis(cmdTree, cmdValues, cmdStr, 0, encryptData);
                    if (saveAction == 3 && cmdTree.getCmdType() == 2) {
                        cmdStr.append('\u1234');
                        System.out.println("REPEAT is TRUE");
                        _repeat = true;
                        this.addIndent(cmdStr, nestedLevel);
                        cmdValues.fixUpForChangeActionAdd();
                        if (cmdTree.hasSeq() && cmdValues.getSeq() != -1) {
                            cmdStr.append(cmdValues.getValue("__SEQ"));
                            cmdStr.append(' ');
                        }
                        cmdStr.append(cmdName);
                        this.buildNodeClis(cmdTree, cmdValues, cmdStr, 0, encryptData);
                    }
                    if (saveAction == 3 && cmdTree.getCmdType() == 2) {
                        cmdValues.revertBackForChangeActionDelete();
                    }
                    return;
                }
                catch (CliGPBException cliGPBException) {
                    cmdStr.setLength(0);
                    this.addIndent(cmdStr, nestedLevel);
                }
            }
            ++i;
        }
        throw new CliGPBException("Command contains missing or incorrect information.\nBad Command Value at ---> " + cmdValues);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildNodeClis(CmdTree cmdTree, CmdValues cmdValues, StringBuffer cmdStr, int index, boolean encryptData) throws CliGPBException {
        this.debug("inside buildNodeClis: nodes = " + cmdTree.numNodes());
        boolean bInternalError = true;
        int nodeIndex = 0;
        while (nodeIndex < cmdTree.numNodes()) {
            StringBuffer paramCli;
            BaseNode node = cmdTree.getNode(nodeIndex);
            if (node == null) {
                throw new CliGPBException("CliBuilder: No nodes in cmd tree.", bInternalError);
            }
            if (node instanceof KeywordNode) {
                paramCli = ((KeywordNode)node).generateClis(cmdValues, index);
                if (paramCli == null) {
                    throw new CliGPBException("No cli generated for keyword node.", bInternalError);
                }
                cmdStr.append((Object)paramCli);
            } else if (node instanceof KeywordParamNode) {
                KeywordParamNode keywordParamNode = (KeywordParamNode)node;
                paramCli = keywordParamNode.generateClis(cmdValues, index, encryptData);
                if (paramCli == null) {
                    throw new CliGPBException("No cli generated for keyword node.", bInternalError);
                }
                cmdStr.append((Object)paramCli);
            } else if (node instanceof ChoiceNode) {
                ChoiceNode choiceNode = (ChoiceNode)node;
                int numCmdTrees = choiceNode.numCmdTrees();
                StringBuffer subCmdStr = new StringBuffer();
                int i = 0;
                block3: while (i < numCmdTrees) {
                    CmdTree subCmdTree = choiceNode.getCmdTree(i);
                    try {
                        this.buildNodeClis(subCmdTree, cmdValues, subCmdStr, 0, encryptData);
                        if (!choiceNode.isRepeat()) break;
                        int valueIndex = 1;
                        while (true) {
                            StringBuffer repeatStr = new StringBuffer();
                            this.buildNodeClis(subCmdTree, cmdValues, repeatStr, valueIndex, encryptData);
                            if (repeatStr.length() == 0) break block3;
                            subCmdStr.append((Object)repeatStr);
                            ++valueIndex;
                        }
                    }
                    catch (CliGPBException cliGPBException) {
                        ++i;
                    }
                }
                this.debug(" --- done with choice node.");
                if (subCmdStr.length() > 0) {
                    cmdStr.append((Object)subCmdStr);
                } else if (!choiceNode.isOptional()) {
                    if (cmdValues.getAction() != 2) throw new CliGPBException("Missing keys for sub command in config values.", bInternalError);
                    if (choiceNode.isPartOfNoCmd()) {
                        throw new CliGPBException("Missing keys for sub command in config values.", bInternalError);
                    }
                }
            } else if (node instanceof ModeNode) {
                ModeNode modeNode = (ModeNode)node;
                String modeStr = cmdValues.getValue(modeNode.getParamKey());
                if (modeStr == null) {
                    modeStr = "dummy";
                }
                if (!modeStr.equals("dummy")) {
                    cmdStr.append(String.valueOf(String.valueOf(' ')) + modeStr);
                }
                this.debug("--- mode node: " + modeStr);
                this._modeCmdSet = modeNode.getFullCmdSet(modeStr);
                if (this._modeCmdSet == null) {
                    throw new CliGPBException("Missing keys for sub command in config values.", bInternalError);
                }
                this._nextCliPriority += (long)this._modeCmdSet._priority;
            }
            ++nodeIndex;
        }
    }

    public Vector print(PrintStream out, ConfigValues cv) throws CliGPBException {
        this.getClis(cv);
        int i = 0;
        while (i < this._clis.size()) {
            out.println(this._clis.elementAt(i).toString());
            ++i;
        }
        return this._clis;
    }
}

