/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.BaseNode;
import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdTree;
import com.cisco.nm.xms.cliparser.Debug;
import com.cisco.nm.xms.cliparser.KeywordParamNode;
import com.cisco.nm.xms.cliparser.ModeNode;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class CmdSet
implements Serializable {
    int _priority;
    static final long serialVersionUID = 1000L;
    Vector _cmdTrees = new Vector();
    boolean _bModeSection = false;

    CmdSet() {
    }

    CmdSet(CmdSet cmdSet) {
        int i = 0;
        while (i < cmdSet.numCmdTrees()) {
            this.addCmdTree(cmdSet.elementAt(i));
            ++i;
        }
        this._priority = cmdSet._priority;
    }

    void setModeSection(boolean value) {
        this._bModeSection = value;
    }

    boolean isModeSection() {
        return this._bModeSection;
    }

    CmdSet append(CmdSet cmdSet) {
        CmdSet newCmdSet = new CmdSet(this);
        int i = 0;
        while (i < cmdSet.numCmdTrees()) {
            newCmdSet.addCmdTree(cmdSet.elementAt(i));
            ++i;
        }
        return newCmdSet;
    }

    public Vector findCmdTrees(String token) {
        Vector<CmdTree> v = new Vector<CmdTree>();
        int i = 0;
        while (i < this._cmdTrees.size()) {
            CmdTree cmdTree = (CmdTree)this._cmdTrees.elementAt(i);
            if (cmdTree.matchCmd(token)) {
                v.addElement(cmdTree);
            }
            ++i;
        }
        return v;
    }

    public boolean isEmpty() {
        return this._cmdTrees.isEmpty();
    }

    void addCmdTree(CmdTree cmdTree) {
        this._cmdTrees.addElement(cmdTree);
    }

    void update(CmdSet cmdSet) throws CliGPBException {
        int i = 0;
        while (i < cmdSet.numCmdTrees()) {
            CmdTree cmdTree = cmdSet.elementAt(i);
            this.updateCmdTree(cmdTree);
            ++i;
        }
    }

    Vector findMatchingTrees(Vector cmdTrees, CmdTree newCmdTree) throws CliGPBException {
        Vector<CmdTree> matchingTrees = new Vector<CmdTree>();
        String newKeyword = "";
        String keyword = "";
        boolean bDone = false;
        int i = 0;
        Vector curMatchingTrees = new Vector();
        while (!bDone) {
            BaseNode newNode = newCmdTree.getNode(i);
            int j = 0;
            while (j < cmdTrees.size()) {
                CmdTree cmdTree = (CmdTree)cmdTrees.elementAt(j);
                BaseNode node = cmdTree.getNode(i);
                if (newNode == null) {
                    matchingTrees.addElement(cmdTree);
                } else if (node != null && node.matchNode(newNode)) {
                    matchingTrees.addElement(cmdTree);
                }
                ++j;
            }
            curMatchingTrees = matchingTrees;
            if (matchingTrees.size() <= 1 || newNode == null) {
                bDone = true;
                continue;
            }
            cmdTrees = matchingTrees;
            matchingTrees = new Vector();
            ++i;
        }
        return curMatchingTrees;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void updateCmdTree(CmdTree cmdTree) throws CliGPBException {
        if (cmdTree.addCmd()) {
            this.addCmdTree(cmdTree);
            return;
        }
        ModeNode modeNode = cmdTree.getModeNode();
        Vector oldCmdTrees = this.findCmdTrees(cmdTree.getCmdName());
        if (oldCmdTrees.size() == 0) {
            if (cmdTree.removeCmd()) throw new CliGPBException(" GrammarBuilder (incremental mode): No matching cmd trees found.");
            this.addCmdTree(cmdTree);
            return;
        } else {
            Vector matchingTrees = this.findMatchingTrees(oldCmdTrees, cmdTree);
            if (matchingTrees.size() == 0) {
                if (cmdTree.removeCmd()) throw new CliGPBException(" GrammarBuilder (incremental mode): No matching cmd trees found.");
                this.addCmdTree(cmdTree);
                return;
            } else if (cmdTree.removeCmd()) {
                int i = 0;
                while (i < matchingTrees.size()) {
                    this._cmdTrees.removeElement(matchingTrees.elementAt(i));
                    ++i;
                }
                return;
            } else {
                if (matchingTrees.size() != 1) throw new CliGPBException(" GrammarBuilder (incremental mode): more than one matching cmd trees found.");
                this.updateCmdNodes((CmdTree)matchingTrees.elementAt(0), cmdTree);
            }
        }
    }

    void updateCmdNodes(CmdTree oldTree, CmdTree newTree) throws CliGPBException {
        ModeNode modeNode = newTree.getModeNode();
        if (modeNode == null) {
            oldTree.replaceNodes(newTree);
        } else {
            oldTree.replaceNodesWithModeNode(newTree);
        }
    }

    int numCmdTrees() {
        return this._cmdTrees.size();
    }

    public Enumeration elements() {
        return this._cmdTrees.elements();
    }

    CmdTree elementAt(int index) {
        return (CmdTree)this._cmdTrees.elementAt(index);
    }

    public KeywordParamNode getParamNode(String cmd, String key, boolean isSearchCaseSensitive) {
        return this.getParamNode(cmd, key, true, isSearchCaseSensitive);
    }

    KeywordParamNode getParamNode(String cmd, String key, boolean checkCmd, boolean isSearchCaseSensitive) {
        KeywordParamNode result = null;
        int i = 0;
        while (i < this.numCmdTrees()) {
            result = this.elementAt(i).getKeywordParamNode(cmd, key, checkCmd, isSearchCaseSensitive);
            if (result != null) break;
            ++i;
        }
        return result;
    }

    public void print(int nestedLevel) {
        Debug.log(this, "inside cmdset.print()", 1);
        int i = 0;
        while (i < this._cmdTrees.size()) {
            Debug.log(this, "--- printing cmdtree", 1);
            CmdTree cmdTree = (CmdTree)this._cmdTrees.elementAt(i);
            StringBuffer strBuf = new StringBuffer();
            int j = 0;
            while (j < nestedLevel) {
                strBuf.append(String.valueOf(' '));
                ++j;
            }
            Debug.log(this, String.valueOf(strBuf) + cmdTree.toString(), 2);
            ModeNode modeNode = cmdTree.getModeNode();
            if (modeNode != null) {
                modeNode.print(++nestedLevel);
                --nestedLevel;
            }
            ++i;
        }
    }
}

