/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.Debug;
import com.cisco.nm.xms.cliparser.KeyValues;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;

public class CmdValues
implements Serializable {
    public static final int ACTION_ADD = 1;
    public static final int ACTION_DELETE = 2;
    public static final int ACTION_CHANGE = 3;
    public static final char REPEAT_VALUE_SEP = '?';
    public static final String extraCmd = "extraCmd";
    public static final String comment = "comment";
    public static final String extraCmdValue = "extraCmdValue";
    public static final String commentValue = "commentValue";
    static final long serialVersionUID = 1000L;
    private String _cmdName;
    private KeyValues _values = new KeyValues();
    private ConfigValues _configValues;
    private KeyValues _oldValues;
    private int _action = 1;
    private KeyValues _saveChangedValues;
    private boolean _bNoCmd = false;
    private boolean _bDefaultCmd = false;
    private CmdValues _parent;
    private int _lineNumber;
    static boolean _printLineNumber;
    static boolean _printParentCmd;

    public CmdValues(String cmd) {
        this._cmdName = cmd;
    }

    public void setAction(int action) {
        this._action = action;
    }

    public int getAction() {
        return this._action;
    }

    public void setNoCmd(boolean noCmd) {
        this._action = noCmd ? 2 : 1;
    }

    public void setDefaultCmd(boolean defaultCmd) {
        this._bDefaultCmd = defaultCmd;
    }

    public boolean isNoCmd() {
        return this._action == 2;
    }

    public boolean isDefaultCmd() {
        return this._bDefaultCmd;
    }

    public String getCmdName() {
        return this._cmdName;
    }

    public void addValue(String key, String value) {
        String valueStr = "";
        if (this.containsKey(key)) {
            valueStr = String.valueOf(this._values.get(key)) + String.valueOf('?');
        }
        this._values.put(key, String.valueOf(valueStr) + value);
    }

    public void setValue(String key, String value) {
        this._values.put(key, value);
    }

    public boolean containsKey(String key) {
        return this._values.containsKey(key);
    }

    public boolean containsOldKey(String key) {
        return this._oldValues.containsKey(key);
    }

    public Enumeration keys() {
        return this._values.keys();
    }

    public Enumeration oldKeys() {
        return this._oldValues.keys();
    }

    public String getValue(String key) {
        return (String)this._values.get(key);
    }

    public Object getValueAsObject(String key) {
        return this._values.get(key);
    }

    public String getOldValue(String key) {
        return (String)this._oldValues.get(key);
    }

    public void addOldValue(String key, String value) {
        if (this._oldValues == null) {
            this._oldValues = new KeyValues();
        }
        String valueStr = "";
        if (this.containsOldKey(key)) {
            valueStr = String.valueOf(this.getOldValue(key)) + String.valueOf('?');
        }
        this._oldValues.put(key, String.valueOf(valueStr) + value);
    }

    public void setOldValue(String key, String value) {
        if (this._oldValues == null) {
            this._oldValues = new KeyValues();
        }
        this._oldValues.put(key, value);
    }

    public void setModeCmdsValues(ConfigValues modeCmds) {
        this._configValues = modeCmds;
        int j = 0;
        while (j < modeCmds.numCmds()) {
            CmdValues nextCmd = modeCmds.getCmdValues(j);
            nextCmd.setParent(this);
            ++j;
        }
    }

    public ConfigValues getModeCmdsValues() {
        return this._configValues;
    }

    void fixUpForChangeActionDelete() {
        Debug.log(this, "inside fixUpForChangeActionDelete", 1);
        this._action = 2;
        this._saveChangedValues = this._values;
        this._values = this._oldValues;
    }

    void revertBackForChangeActionDelete() {
        Debug.log(this, "inside revertBackForChangeActionDelete", 1);
        this._action = 3;
    }

    void fixUpForChangeActionAdd() {
        Debug.log(this, "inside fixUpForChangeActionAdd", 1);
        this._action = 1;
        this._values = this._saveChangedValues;
    }

    public KeyValues getOldValues() {
        return this._oldValues;
    }

    void addIndent(StringBuffer strBuf, int level) {
        int i = 0;
        while (i < level) {
            strBuf.append(' ');
            ++i;
        }
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean noSubCmds) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps, 0, noSubCmds);
        return baos.toString();
    }

    void print() {
        this.print(0);
    }

    void print(PrintStream out) {
        this.print(out, 0);
    }

    void print(int nestedLevel) {
        this.print(System.out, nestedLevel);
    }

    void print(PrintStream out, int nestedLevel) {
        this.print(out, nestedLevel, false);
    }

    void print(PrintStream out, int nestedLevel, boolean noSubCmds) {
        StringBuffer strBuf = new StringBuffer();
        this.addIndent(strBuf, nestedLevel);
        strBuf.append(String.valueOf(this._cmdName) + " (Action=" + this._action + ")");
        if (_printLineNumber) {
            strBuf.append("(LineNo=" + this._lineNumber + ")");
        }
        if (_printParentCmd) {
            if (this._parent == null) {
                strBuf.append("(Parent=" + "null" + ")");
            } else {
                strBuf.append("(Parent=" + this._parent.getCmdName() + ")");
            }
        }
        out.println(strBuf.toString());
        strBuf = new StringBuffer();
        this.addIndent(strBuf, nestedLevel);
        strBuf.append("Old Values");
        if (this._oldValues != null) {
            out.println(strBuf.toString());
            this._oldValues.print(out, nestedLevel);
            out.println("");
            strBuf = new StringBuffer();
            this.addIndent(strBuf, nestedLevel);
            strBuf.append("New Values");
            out.println(strBuf.toString());
        }
        this._values.print(out, nestedLevel);
        out.println("");
        if (!noSubCmds && this._configValues != null) {
            strBuf = new StringBuffer();
            this.addIndent(strBuf, nestedLevel);
            strBuf.append("Sub command values:");
            out.println(strBuf.toString());
            this._configValues.print(out, ++nestedLevel);
            --nestedLevel;
        }
    }

    public int numOfTokens() {
        return this._values.size();
    }

    public CmdValues getParent() {
        return this._parent;
    }

    void setParent(CmdValues parent) {
        this._parent = parent;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    void setLineNumber(int lineno) {
        this._lineNumber = lineno;
    }

    public void setSeq(int seq) {
        this.setValue("__SEQ", Integer.toString(seq));
    }

    public int getSeq() {
        String seq = this.getValue("__SEQ");
        if (seq != null) {
            return Integer.parseInt(seq);
        }
        return -1;
    }

    public void setOldSeq(int seq) {
        this.setOldValue("__SEQ", Integer.toString(seq));
    }

    public int getOldSeq() {
        String seq = this.getOldValue("__SEQ");
        if (seq != null) {
            return Integer.parseInt(seq);
        }
        return -1;
    }
}

