/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.BaseNode;
import com.cisco.nm.xms.cliparser.ChoiceNode;
import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdSet;
import com.cisco.nm.xms.cliparser.CmdTree;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.Debug;
import com.cisco.nm.xms.cliparser.FilterIf;
import com.cisco.nm.xms.cliparser.GrammarLocator;
import com.cisco.nm.xms.cliparser.KeywordNode;
import com.cisco.nm.xms.cliparser.KeywordParamNode;
import com.cisco.nm.xms.cliparser.ModeNode;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigParser {
    String _configFile;
    Vector _configCmds;
    String _iosVersion;
    String _deviceType;
    String _goPath;
    CmdSet _cmdSet;
    ConfigValues _configValues = new ConfigValues();
    String _line;
    int _curIndex = -1;
    int _curCmd;
    String _token;
    BufferedReader _fileReader;
    CmdSet _modeCmdSet;
    boolean _bUseSameLine = false;
    FilterIf _listener;
    int _linenumber;
    boolean _bHandlingRepeat = false;
    static final int MATCH_YES = 1;
    static final int MATCH_NO = 2;
    static final int MATCH_NO_BUT_OPTIONAL = 3;
    static final int MATCH_ERROR = 4;
    static final int MATCH_NOCMD = 5;

    public ConfigParser(String iosVersion, String deviceType, String goPath) throws CliGPBException {
        this._iosVersion = iosVersion;
        this._deviceType = deviceType;
        this._goPath = goPath;
        this._cmdSet = GrammarLocator.getCmdSet(this._iosVersion, this._deviceType, this._goPath);
    }

    public ConfigParser(CmdSet cmdSet) {
        this._cmdSet = cmdSet;
    }

    public CmdSet getCmdSet() {
        return this._cmdSet;
    }

    public void setListener(FilterIf listener) {
        this._listener = listener;
    }

    private void debug(String message) {
        Debug.debug(message);
    }

    private void syntaxError(String message) {
        StringBuffer msgBuffer = new StringBuffer(80);
        int i = 0;
        while (i < this._curIndex) {
            msgBuffer.append(' ');
            ++i;
        }
        msgBuffer.append('^');
        msgBuffer.append(message);
        Debug.error(this._line);
        Debug.error(msgBuffer.toString());
    }

    public ConfigValues getConfigValues(String configFile) throws CliGPBException {
        this._linenumber = 0;
        this._configFile = configFile;
        this._configValues = new ConfigValues();
        try {
            this._fileReader = new BufferedReader(new FileReader(this._configFile));
        }
        catch (IOException e) {
            throw new CliGPBException("IOException reading file: " + this._configFile, e);
        }
        return this.parseTheConfig(false);
    }

    public ConfigValues getConfigValues(Vector configCmds) throws CliGPBException {
        this._configCmds = configCmds;
        this._configValues = new ConfigValues();
        String str = (String)this._configCmds.elementAt(0);
        StringTokenizer st = new StringTokenizer(str, "\n\r");
        this.debug("---- LF and CR tokens = " + st.countTokens());
        if (st.countTokens() > 1) {
            Vector<String> v = new Vector<String>();
            while (st.hasMoreTokens()) {
                v.addElement(st.nextToken());
            }
            this._configCmds = v;
            this.debug("---- num commands = " + this._configCmds.size());
        }
        return this.parseTheConfig(false);
    }

    public ConfigValues getConfigValues(InputStream configStream) throws CliGPBException {
        return this.getConfigValues(configStream, false);
    }

    public ConfigValues getConfigValues(InputStream configStream, boolean getComments) throws CliGPBException {
        this._fileReader = new BufferedReader(new InputStreamReader(configStream));
        this._configValues = new ConfigValues();
        return this.parseTheConfig(getComments);
    }

    ConfigValues parseTheConfig(boolean getComments) throws CliGPBException {
        if (this._cmdSet == null) {
            this._cmdSet = GrammarLocator.getCmdSet(this._iosVersion, this._deviceType, this._goPath);
        }
        boolean ret = this.parseCmdSet(this._cmdSet, this._configValues, false, 0, 0, getComments);
        this.debug("");
        if (!ret) {
            throw new CliGPBException("Cannot parse one or more commands.");
        }
        return this._configValues;
    }

    boolean getNextLine() throws CliGPBException {
        if (this._fileReader != null) {
            try {
                this._line = this._fileReader.readLine();
                this._curIndex = 0;
                if (this._line == null || this._line.trim().equals("end")) {
                    this.debug("---- DONE -----");
                    return false;
                }
                ++this._linenumber;
            }
            catch (IOException e) {
                this.debug("Error in reading file: ");
                throw new CliGPBException("Error in reading file: " + this._configFile, e);
            }
        } else {
            if (this._curCmd >= this._configCmds.size()) {
                this.debug("----- DONE -----");
                this._curCmd = 0;
                return false;
            }
            this._curIndex = 0;
            this._line = (String)this._configCmds.elementAt(this._curCmd++);
        }
        return true;
    }

    private boolean readNextLine() throws CliGPBException {
        while (true) {
            boolean bRet;
            if (!(bRet = this.getNextLine())) {
                return false;
            }
            int length = this._line.length();
            int i = 0;
            while (i < length && this._line.charAt(i) == ' ') {
                ++i;
            }
            if (i < length) break;
            this.debug("--- blank line.");
        }
        this.debug(" --- line = " + this._line);
        return true;
    }

    private boolean parseCmdSet(CmdSet cmdSet, ConfigValues configValues, boolean bInsideModeSection, int nestedLevel, int previousLevel, boolean getComments) throws CliGPBException {
        this.debug("entering parseCmdSet() level " + nestedLevel);
        this._modeCmdSet = null;
        while (this._bUseSameLine || this.readNextLine()) {
            CmdValues cmdValues;
            this._bUseSameLine = false;
            this.debug(this._line);
            int i = 0;
            while (this._line.charAt(i) == ' ') {
                ++i;
            }
            if (this._line.charAt(i) == '!' && getComments) {
                cmdValues = new CmdValues("comment");
                cmdValues.addValue("commentValue", this._line);
                configValues.addCmdValues(cmdValues);
            }
            if (bInsideModeSection) {
                if (this._line.charAt(i) == '!') {
                    this._bUseSameLine = false;
                    continue;
                }
                if (i <= previousLevel) {
                    this.debug("-- returning from parseCmdSet() level " + nestedLevel);
                    this._bUseSameLine = true;
                    return true;
                }
            }
            if ((cmdValues = this.parseOneCmd(cmdSet, bInsideModeSection)) != null) {
                configValues.addCmdValues(cmdValues);
                cmdValues.setLineNumber(this._linenumber);
            }
            if (this._modeCmdSet != null) {
                ConfigValues configModeCmds = new ConfigValues();
                this.parseCmdSet(this._modeCmdSet, configModeCmds, true, ++nestedLevel, i, getComments);
                --nestedLevel;
                cmdValues.setModeCmdsValues(configModeCmds);
                int j = 0;
                while (j < configModeCmds.numCmds()) {
                    CmdValues nextCmd = configModeCmds.getCmdValues(j);
                    nextCmd.setParent(cmdValues);
                    ++j;
                }
            }
            if (nestedLevel != 0 || this._listener == null || cmdValues == null) continue;
            this._listener.accept(cmdValues);
        }
        this.debug("--- returning from parseCmdSet() level " + nestedLevel);
        return true;
    }

    private String getNextToken() {
        char ch;
        this.debug("inside getNextToken()");
        int length = this._line.length();
        while (this._curIndex < length && this._line.charAt(this._curIndex) == ' ') {
            ++this._curIndex;
        }
        if (this._curIndex >= length) {
            this.debug("--- end of line.");
            this._token = null;
            return this._token;
        }
        StringBuffer tokenBuffer = new StringBuffer();
        while (this._curIndex < length && (ch = this._line.charAt(this._curIndex)) != ' ') {
            tokenBuffer.append(ch);
            ++this._curIndex;
        }
        this.debug("--- token = " + tokenBuffer);
        this._token = tokenBuffer.toString();
        return this._token;
    }

    private CmdValues parseOneCmd(CmdSet cmdSet, boolean bInsideModeSection) throws CliGPBException {
        CmdValues cmdValues;
        Vector cmdTrees;
        this.debug("inside parseOneCmd()");
        String token = this.getNextToken();
        if (token == null) {
            return null;
        }
        boolean bNoCmd = false;
        if (token.equals("no")) {
            bNoCmd = true;
            token = this.getNextToken();
            if (token == null) {
                return null;
            }
        }
        boolean bDefaultCmd = false;
        if (token.equals("default")) {
            bDefaultCmd = true;
            token = this.getNextToken();
            if (token == null) {
                return null;
            }
        }
        int seq = -1;
        boolean bSeqFound = false;
        if (token.charAt(0) >= '0' && token.charAt(0) <= '9') {
            try {
                seq = Integer.parseInt(token);
                bSeqFound = true;
            }
            catch (Exception exception) {}
            if (bSeqFound) {
                token = this.getNextToken();
            }
            if (token == null) {
                return null;
            }
        }
        if ((cmdTrees = cmdSet.findCmdTrees(token)).size() == 0) {
            if (bInsideModeSection) {
                CmdValues cmdValues2 = new CmdValues("extraCmd");
                cmdValues2.addValue("extraCmdValue", this._line);
                return cmdValues2;
            }
            this.debug("Unrecognized command.");
            return null;
        }
        int saveIndex = this._curIndex;
        int i = 0;
        while (i < cmdTrees.size()) {
            boolean success;
            this._curIndex = saveIndex;
            cmdValues = new CmdValues(token);
            cmdValues.setNoCmd(bNoCmd);
            cmdValues.setDefaultCmd(bDefaultCmd);
            if (seq != -1) {
                cmdValues.setSeq(seq);
            }
            if (success = this.matchNodes((CmdTree)cmdTrees.elementAt(i), false, cmdValues)) {
                return cmdValues;
            }
            ++i;
        }
        cmdValues = new CmdValues("extraCmd");
        cmdValues.addValue("extraCmdValue", this._line);
        this.debug("Found extra command");
        return cmdValues;
    }

    private int remainingReqNodes(CmdTree cmdTree, int index) {
        this.debug("inside remainingReqNodes");
        int reqNodes = 0;
        int totalNodes = cmdTree.numNodes();
        while (index < totalNodes) {
            BaseNode node = cmdTree.getNode(index);
            if (!node.isOptional()) {
                this.debug(" --- req node=" + node);
                ++reqNodes;
            }
            ++index;
        }
        this.debug(" --- req nodes = " + reqNodes);
        return reqNodes;
    }

    private boolean matchNodes(CmdTree cmdTree, boolean bInsideChoiceNode, CmdValues cmdValues) throws CliGPBException {
        this.debug("inside matchNodes()");
        int nodeIndex = 0;
        this._bHandlingRepeat = false;
        if (!bInsideChoiceNode) {
            this._token = this.getNextToken();
            if (this._token == null) {
                if (cmdValues.isNoCmd() || cmdValues.isDefaultCmd()) {
                    return true;
                }
                if (this.remainingReqNodes(cmdTree, nodeIndex) == 0) {
                    BaseNode node = cmdTree.getNode(nodeIndex);
                    if (node != null && node instanceof ModeNode) {
                        this._token = "dummy";
                    } else if (node == null) {
                        this.debug(" ---- returning from matchNodes()");
                        return true;
                    }
                } else {
                    this.syntaxError("Incomplete command.");
                    this.debug(" ---- returning from matchNodes()");
                    return false;
                }
            }
        }
        boolean bDone = false;
        while (!bDone) {
            BaseNode node = cmdTree.getNode(nodeIndex);
            int ret = this.matchToken(node, cmdValues);
            switch (ret) {
                case 4: {
                    if (cmdValues.isNoCmd() || cmdValues.isDefaultCmd()) {
                        return true;
                    }
                    if (!bInsideChoiceNode) {
                        this.syntaxError("Parsing error.");
                    }
                    return false;
                }
                case 2: {
                    if (!bInsideChoiceNode) {
                        this.debug("Syntax error.");
                    }
                    if (this._bHandlingRepeat) {
                        ++nodeIndex;
                        this._bHandlingRepeat = false;
                        break;
                    }
                    return false;
                }
                case 1: {
                    BaseNode nextNode;
                    if (bInsideChoiceNode && nodeIndex == cmdTree.numNodes() - 1 && !node.isRepeat()) {
                        return true;
                    }
                    this._token = this.getNextToken();
                    if (this._token == null) {
                        if (cmdValues.isNoCmd() || cmdValues.isDefaultCmd()) {
                            return true;
                        }
                        if (this.remainingReqNodes(cmdTree, nodeIndex + 1) == 0) {
                            nextNode = cmdTree.getNode(nodeIndex + 1);
                            if (nextNode != null && nextNode instanceof ModeNode) {
                                this._token = "dummy";
                                ++nodeIndex;
                                break;
                            }
                            if (nextNode == null) {
                                return true;
                            }
                        } else {
                            this.syntaxError("Incomplete command.");
                            return false;
                        }
                    }
                    if (!node.isRepeat()) {
                        ++nodeIndex;
                        this._bHandlingRepeat = false;
                        break;
                    }
                    this._bHandlingRepeat = true;
                    break;
                }
                case 3: {
                    BaseNode nextNode;
                    if (bInsideChoiceNode && nodeIndex == cmdTree.numNodes() - 1 && !node.isRepeat()) {
                        if (this._token != null) {
                            this._curIndex -= this._token.length();
                        }
                        return true;
                    }
                    if (this._token == null) {
                        nextNode = cmdTree.getNode(nodeIndex + 1);
                        if (nextNode != null && nextNode instanceof ModeNode) {
                            this._token = "dummy";
                        } else if (nextNode == null) {
                            return true;
                        }
                    }
                    ++nodeIndex;
                    break;
                }
            }
        }
        return true;
    }

    private int matchToken(BaseNode node, CmdValues cmdValues) throws CliGPBException {
        this.debug("inside matchToken:");
        if (node == null) {
            return 4;
        }
        if (node instanceof KeywordNode) {
            return ((KeywordNode)node).matchToken(this._token, cmdValues);
        }
        if (node instanceof KeywordParamNode) {
            KeywordParamNode keywordParamNode = (KeywordParamNode)node;
            if (keywordParamNode.hasKeyword()) {
                int ret = keywordParamNode.matchKeyword(this._token);
                if (ret == 1) {
                    this._token = this.getNextToken();
                    if (this._token == null) {
                        return 4;
                    }
                    if (keywordParamNode.getParamType() == 6 || keywordParamNode.getParamType() == 8) {
                        this.readTilEndOfLine();
                    }
                    if (keywordParamNode.getParamType() == 7) {
                        this.getMultilineToken();
                    }
                    if (keywordParamNode.getParamType() == 10) {
                        this.getMultiline2Token("quit");
                    }
                    if (keywordParamNode.getParamType() == 11) {
                        this.readTillNextQuote();
                    }
                    return keywordParamNode.matchParam(this._token, cmdValues);
                }
                return ret;
            }
            if (keywordParamNode.getParamType() == 6 || keywordParamNode.getParamType() == 8) {
                this.readTilEndOfLine();
            }
            if (keywordParamNode.getParamType() == 7) {
                this.getMultilineToken();
            }
            if (keywordParamNode.getParamType() == 10) {
                this.getMultiline2Token("quit");
            }
            if (keywordParamNode.getParamType() == 11) {
                this.readTillNextQuote();
            }
            return keywordParamNode.matchParam(this._token, cmdValues);
        }
        if (node instanceof ChoiceNode) {
            ChoiceNode choiceNode = (ChoiceNode)node;
            int numCmdTrees = choiceNode.numCmdTrees();
            int i = 0;
            while (i < numCmdTrees) {
                CmdTree subCmdTree = choiceNode.getCmdTree(i);
                if (this.matchNodes(subCmdTree, true, cmdValues)) {
                    return 1;
                }
                ++i;
            }
            this.debug(" --- done with choice node.");
            if (choiceNode.isOptional()) {
                return 3;
            }
            return 2;
        }
        if (node instanceof ModeNode) {
            ModeNode modeNode = (ModeNode)node;
            cmdValues.addValue(modeNode.getParamKey(), this._token);
            this._modeCmdSet = modeNode.getFullCmdSet(this._token);
            if (this._modeCmdSet == null) {
                return 2;
            }
        }
        return 1;
    }

    void getMultilineToken() throws CliGPBException {
        this.debug("inside getMultilineToken()");
        this._curIndex = this._line.indexOf(this._token);
        this._token = "";
        this._curIndex += 2;
        while (this._line != null) {
            int length = this._line.length();
            if (this._line.endsWith("^C") && this._curIndex != length) {
                this._token = String.valueOf(this._token) + this._line.substring(this._curIndex, length - 2) + "\n";
                this._curIndex = length;
                return;
            }
            this._token = String.valueOf(this._token) + this._line.substring(this._curIndex, length) + "\n";
            this._curIndex = 0;
            this.getNextLine();
        }
    }

    void getMultiline2Token(String terminator) throws CliGPBException {
        this.debug("inside getMultiline2Token()");
        this._curIndex = this._line.indexOf(this._token);
        this._token = "";
        while (this._line != null) {
            int length = this._line.length();
            if (this._line.endsWith(terminator) && this._curIndex != length) {
                this._token = String.valueOf(this._token) + this._line.substring(this._curIndex, length - 2) + "\n";
                this._curIndex = length;
                return;
            }
            this._token = String.valueOf(this._token) + this._line.substring(this._curIndex, length) + "\n";
            this._curIndex = 0;
            this.getNextLine();
        }
    }

    void readTillNextQuote() {
        if (this._token.endsWith("\"")) {
            return;
        }
        StringBuffer tokenBuffer = new StringBuffer();
        int length = this._line.length();
        while (this._curIndex < length && this._line.charAt(this._curIndex) != '\"') {
            tokenBuffer.append(this._line.charAt(this._curIndex));
            ++this._curIndex;
        }
        if (this._line.charAt(this._curIndex) == '\"') {
            tokenBuffer.append(this._line.charAt(this._curIndex));
            ++this._curIndex;
        }
        this._token = String.valueOf(this._token) + tokenBuffer;
    }

    void readTilEndOfLine() {
        StringBuffer tokenBuffer = new StringBuffer();
        int length = this._line.length();
        while (this._curIndex < length) {
            tokenBuffer.append(this._line.charAt(this._curIndex));
            ++this._curIndex;
        }
        this._token = String.valueOf(this._token) + tokenBuffer;
    }
}

