/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.FilterIf;
import gnu.regexp.RE;
import gnu.regexp.REException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class ConfigValues
implements Serializable {
    Vector _cmds = new Vector();
    static final long serialVersionUID = 1000L;

    public ConfigValues getCmds(String cmd, String key, String value, boolean isSearchCaseSensitive) throws CliGPBException {
        RE valuepattern;
        RE keypattern;
        RE cmdpattern;
        ConfigValues result = new ConfigValues();
        try {
            if (isSearchCaseSensitive) {
                cmdpattern = new RE(cmd);
                keypattern = new RE(key);
                valuepattern = new RE(value);
            } else {
                cmdpattern = new RE(cmd, 2);
                keypattern = new RE(key, 2);
                valuepattern = new RE(value, 2);
            }
        }
        catch (REException e) {
            throw new CliGPBException(e.toString());
        }
        int i = 0;
        while (i < this.numCmds()) {
            CmdValues mycmd = this.getCmdValues(i);
            if (cmdpattern.isMatch(mycmd.getCmdName())) {
                Enumeration e = mycmd.keys();
                while (e.hasMoreElements()) {
                    String mykey = (String)e.nextElement();
                    if (!keypattern.isMatch(mykey)) continue;
                    if (!valuepattern.isMatch(mycmd.getValue(mykey))) break;
                    result.addCmdValues(mycmd);
                    break;
                }
            }
            ++i;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public ConfigValues getCmds(String cmd, String subCmd, boolean isSearchCaseSensitive) throws CliGPBException {
        RE subcmdpattern;
        RE cmdpattern;
        ConfigValues result = new ConfigValues();
        try {
            if (isSearchCaseSensitive) {
                cmdpattern = new RE(cmd);
                subcmdpattern = new RE(subCmd);
            } else {
                cmdpattern = new RE(cmd, 2);
                subcmdpattern = new RE(subCmd, 2);
            }
        }
        catch (REException e) {
            throw new CliGPBException(e.toString());
        }
        int i = 0;
        while (i < this.numCmds()) {
            CmdValues mycmd = this.getCmdValues(i);
            if (cmdpattern.isMatch(mycmd.getCmdName())) {
                ConfigValues subcmds = mycmd.getModeCmdsValues();
                int j = 0;
                while (j < subcmds.numCmds()) {
                    CmdValues mysubcmd = subcmds.getCmdValues(j);
                    if (subcmdpattern.isMatch(mysubcmd.getCmdName())) {
                        result.addCmdValues(mycmd);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public ConfigValues getCmds(FilterIf filter) {
        ConfigValues result = new ConfigValues();
        int i = 0;
        while (i < this.numCmds()) {
            CmdValues mycmd = this.getCmdValues(i);
            if (filter.accept(mycmd)) {
                result.addCmdValues(mycmd);
            }
            ++i;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public void addCmdValues(CmdValues cmdValues) {
        this._cmds.addElement(cmdValues);
    }

    public void insertCmdValues(CmdValues cmdValues, int index) {
        this._cmds.insertElementAt(cmdValues, index);
    }

    public void clearCmdValues() {
        int i = 0;
        while (i < this._cmds.size()) {
            CmdValues cmd = (CmdValues)this._cmds.elementAt(i);
            cmd.setParent(null);
            ++i;
        }
        this._cmds.removeAllElements();
    }

    public void clearCmdValuesAt(int index) {
        CmdValues cmd = (CmdValues)this._cmds.elementAt(index);
        cmd.setParent(null);
        this._cmds.removeElementAt(index);
    }

    public void print() {
        this.print(0);
    }

    public void print(PrintStream out) {
        this.print(out, 0);
    }

    public void print(int nestedLevel) {
        this.print(System.out, nestedLevel);
    }

    public void print(PrintStream out, int nestedLevel) {
        int i = 0;
        while (i < this._cmds.size()) {
            ((CmdValues)this._cmds.elementAt(i)).print(out, nestedLevel);
            ++i;
        }
    }

    public int numCmds() {
        return this._cmds.size();
    }

    public boolean isEmpty() {
        return this._cmds.size() == 0;
    }

    public CmdValues getCmdValues(int index) {
        return (CmdValues)this._cmds.elementAt(index);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps, 0);
        return baos.toString();
    }
}

