/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.BaseNode;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.MyStringTokenizer;

public class KeywordNode
extends BaseNode {
    static final long serialVersionUID = 1000L;
    String _keyword;
    String _key;
    boolean _setByDefault = false;

    public KeywordNode(String key, String value) {
        this._key = key;
        this._keyword = value;
    }

    public void setKey(String key) {
        this._key = key;
    }

    public String getKey() {
        return this._key;
    }

    public String getKeyword() {
        return this._keyword;
    }

    public void setKeyword(String value) {
        this._keyword = value;
    }

    public void setByDefault(boolean bSet) {
        this._setByDefault = bSet;
    }

    public boolean matchNode(BaseNode node) {
        if (!(node instanceof KeywordNode)) {
            return false;
        }
        KeywordNode keywordNode = (KeywordNode)node;
        return this._keyword.equals(keywordNode.getKeyword()) && this._key.equals(keywordNode.getKey()) && super.matchNode(node);
    }

    public boolean isSetByDefault() {
        return this._setByDefault;
    }

    public StringBuffer generateClis(CmdValues cmdValues, int index) {
        boolean bKeyPresent = cmdValues.containsKey(this.getKey());
        if (index == 0 && !bKeyPresent) {
            if (this.isOptional()) {
                return new StringBuffer();
            }
            if (cmdValues.getAction() == 1) {
                return null;
            }
            if (cmdValues.getAction() == 2) {
                if (this.isPartOfNoCmd()) {
                    return null;
                }
                return new StringBuffer();
            }
        }
        StringBuffer cmdStr = new StringBuffer();
        if (bKeyPresent && (cmdValues.getAction() == 1 || this.isPartOfNoCmd())) {
            String value = cmdValues.getValue(this.getKey());
            MyStringTokenizer st = new MyStringTokenizer(value, String.valueOf('?'));
            int numTokens = st.readTokens();
            if (index < st.countTokens()) {
                cmdStr.append(String.valueOf(String.valueOf(' ')) + this.getKeyword());
            }
        }
        return cmdStr;
    }

    public String toString() {
        String outStr = "";
        if (this.isOptional()) {
            outStr = String.valueOf(outStr) + String.valueOf('[');
        }
        outStr = String.valueOf(outStr) + String.valueOf('(') + this._keyword + String.valueOf(')');
        if (this.isOptional()) {
            outStr = String.valueOf(outStr) + String.valueOf(']');
        }
        return outStr;
    }

    public int matchToken(String token, CmdValues cmdValues) {
        if (token == null) {
            return this.isOptional() ? 3 : 2;
        }
        if (token.equals(this._keyword)) {
            cmdValues.addValue(this._key, this._keyword);
            return 1;
        }
        if (this.isOptional()) {
            return 3;
        }
        return 2;
    }
}

