/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.BaseNode;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.Debug;
import com.cisco.nm.xms.cliparser.MyDummyTokenizer;
import com.cisco.nm.xms.cliparser.MyStringTokenizer;
import com.cisco.nm.xms.cliparser.ParamNode;
import com.cisco.nm.xms.cliparser.util.StringUtils;
import java.util.Vector;

public class KeywordParamNode
extends ParamNode {
    static final long serialVersionUID = 1000L;
    String _keyword;
    String _defaultValue;
    Vector _possibleValues = new Vector();
    long _minRange = -1L;
    long _maxRange = -1L;
    boolean _bKeywordPartOfNoCmd = false;

    KeywordParamNode(String keyword, int type, String label) {
        super(type, label);
        this._keyword = keyword;
    }

    KeywordParamNode(String keyword, int type, boolean isOptional, String def, Vector range, int min, int max) {
        super(type, "");
        this._keyword = keyword;
        this._possibleValues = range;
        this._defaultValue = def;
        this._minRange = min;
        this._maxRange = max;
    }

    void setDefaultValue(String value) {
        this._defaultValue = value;
    }

    void setKeyword(String value) {
        this._keyword = value;
    }

    void setMinRange(long min) {
        this._minRange = min;
    }

    void setMaxRange(long max) {
        this._maxRange = max;
    }

    public String getKeyword() {
        return this._keyword;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public long getMinRange() {
        return this._minRange;
    }

    public long getMaxRange() {
        return this._maxRange;
    }

    void setKeywordPartOfNoCmd(boolean value) {
        this._bKeywordPartOfNoCmd = value;
    }

    boolean isKeywordPartOfNoCmd() {
        return this._bKeywordPartOfNoCmd;
    }

    public boolean isPartOfNoCmd() {
        return this._bKeywordPartOfNoCmd || super.isPartOfNoCmd();
    }

    public String getKey() {
        return this.getParamKey();
    }

    void addValue(String value) {
        this._possibleValues.addElement(value);
    }

    public boolean matchNode(BaseNode node) {
        if (!(node instanceof KeywordParamNode)) {
            return false;
        }
        KeywordParamNode kpNode = (KeywordParamNode)node;
        String keyword = kpNode.getKeyword();
        return (keyword == null && this._keyword == null || keyword != null && this._keyword != null && this._keyword.equals(keyword)) && super.matchNode(node);
    }

    boolean isValidIntParam(String value) {
        try {
            long longValue = Long.parseLong(value);
            if (this._minRange != -1L && longValue < this._minRange) {
                return false;
            }
            if (this._maxRange != -1L && longValue > this._maxRange) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    boolean isValid(String value) {
        switch (this.getParamType()) {
            case 2: {
                return this._possibleValues.contains(value);
            }
            case 0: {
                return this.isValidIntParam(value);
            }
            case 1: 
            case 9: {
                if (this._maxRange != -1L) {
                    return (long)value.length() <= this._maxRange;
                }
                return true;
            }
            case 4: {
                if (StringUtils.getCharCount(value, '.') != 3) break;
                return true;
            }
            case 5: {
                if (!Character.isDigit(value.charAt(value.length() - 1))) break;
                return true;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean hasKeyword() {
        return this._keyword != null;
    }

    public Vector getPossibleValuesAsVector() {
        return this._possibleValues;
    }

    public String[] getPossibleValues() {
        int size = this._possibleValues.size();
        Object[] result = new String[size];
        this._possibleValues.copyInto(result);
        return result;
    }

    public String getPossibleValuesAsList() {
        String retStr = "";
        int i = 0;
        while (i < this._possibleValues.size()) {
            if (i > 0) {
                retStr = String.valueOf(retStr) + ",";
            }
            retStr = String.valueOf(retStr) + (String)this._possibleValues.elementAt(i);
            ++i;
        }
        return retStr;
    }

    int matchKeyword(String token) {
        if (token == null) {
            return this.isOptional() ? 3 : 2;
        }
        if (token.equals(this._keyword)) {
            return 1;
        }
        if (this.isOptional()) {
            return 3;
        }
        return 2;
    }

    int matchParam(String token, CmdValues cmdValues) {
        if (token == null) {
            return this.isOptional() ? 3 : 2;
        }
        if (this.isValid(token)) {
            String key = this.getParamKey();
            if (key == null) {
                Debug.log(this, "^  No config value added.  No keyword or param label.", 1);
            } else {
                cmdValues.addValue(key, token);
            }
            return 1;
        }
        return this.isOptional() ? 3 : 2;
    }

    StringBuffer generateClis(CmdValues cmdValues, int index, boolean encryptData) {
        boolean bKeyPresent = cmdValues.containsKey(this.getKey());
        if (index == 0 && !bKeyPresent) {
            if (this.isOptional()) {
                return new StringBuffer();
            }
            if (cmdValues.getAction() == 1) {
                return null;
            }
            if (cmdValues.getAction() == 2) {
                if (this.hasKeyword() && this.isKeywordPartOfNoCmd() || this.isPartOfNoCmd()) {
                    return null;
                }
                return new StringBuffer();
            }
        }
        StringBuffer cmdStr = new StringBuffer();
        if (bKeyPresent) {
            String value = cmdValues.getValue(this.getKey());
            MyStringTokenizer st = this.getParamType() == 11 || this.getParamType() == 6 ? new MyDummyTokenizer(value) : new MyStringTokenizer(value, String.valueOf('?'));
            int numTokens = st.readTokens();
            int valueIndex = 0;
            while (st.hasMoreTokens()) {
                String paramValue = st.nextToken();
                if (this.isRepeat() || valueIndex == index) {
                    if (this.hasKeyword() && (cmdValues.getAction() == 1 || this.isKeywordPartOfNoCmd())) {
                        cmdStr.append(String.valueOf(String.valueOf(' ')) + this.getKeyword());
                    }
                    if ((cmdValues.getAction() == 1 || this.isPartOfNoCmd()) && paramValue.length() > 0) {
                        if (this.isValid(paramValue)) {
                            if ((this.getParamType() == 8 || this.getParamType() == 9) && encryptData) {
                                char[] str = new char[paramValue.length()];
                                int i = 0;
                                while (i < str.length) {
                                    str[i] = 42;
                                    ++i;
                                }
                                paramValue = new String(str);
                            }
                            cmdStr.append(String.valueOf(String.valueOf(' ')) + paramValue);
                        } else {
                            return null;
                        }
                    }
                }
                ++valueIndex;
            }
        }
        return cmdStr;
    }

    public String toString() {
        String retStr = "";
        if (this.isOptional()) {
            retStr = String.valueOf(retStr) + String.valueOf('[');
        }
        retStr = String.valueOf(retStr) + String.valueOf('(');
        if (this._keyword != null) {
            retStr = String.valueOf(retStr) + this._keyword;
        }
        if (this.isKeywordPartOfNoCmd() && !this.isPartOfNoCmd()) {
            retStr = String.valueOf(retStr) + String.valueOf('@') + String.valueOf(' ');
        }
        retStr = String.valueOf(retStr) + super.toString();
        switch (this.getParamType()) {
            case 2: {
                int i = 0;
                while (i < this._possibleValues.size()) {
                    if (i > 0) {
                        retStr = String.valueOf(retStr) + String.valueOf('|') + String.valueOf(' ');
                    }
                    retStr = String.valueOf(retStr) + (String)this._possibleValues.elementAt(i);
                    ++i;
                }
                break;
            }
            case 0: 
            case 1: {
                if (this._minRange != -1L) {
                    retStr = String.valueOf(retStr) + Long.toString(this._minRange);
                }
                retStr = String.valueOf(retStr) + ",";
                if (this._maxRange == -1L) break;
                retStr = String.valueOf(retStr) + Long.toString(this._maxRange);
                break;
            }
        }
        retStr = String.valueOf(retStr) + ",";
        if (this._defaultValue != null) {
            retStr = String.valueOf(retStr) + this._defaultValue;
        }
        retStr = String.valueOf(retStr) + String.valueOf('>');
        retStr = String.valueOf(retStr) + String.valueOf(')');
        if (this.isRepeat()) {
            retStr = String.valueOf(retStr) + String.valueOf('*');
        }
        if (this.isOptional()) {
            retStr = String.valueOf(retStr) + String.valueOf(']');
        }
        return retStr;
    }
}

