/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.BaseNode;

public class ParamNode
extends BaseNode {
    static final long serialVersionUID = 1000L;
    public static final int TYPE_INT = 0;
    public static final int TYPE_STR = 1;
    public static final int TYPE_KEYWORD = 2;
    public static final int TYPE_MODE = 3;
    public static final int TYPE_IPADDR = 4;
    public static final int TYPE_PORTADDR = 5;
    public static final int TYPE_LONG_STR = 6;
    public static final int TYPE_MULTILINE_STR = 7;
    public static final int TYPE_LONG_PASSWORD = 8;
    public static final int TYPE_SHORT_PASSWORD = 9;
    public static final int TYPE_MULTILINE2_STR = 10;
    public static final int TYPE_QUOTED_STR = 11;
    public static String INT_TYPE = "int";
    public static String STR_TYPE = "str";
    public static String KEYWORD_TYPE = "keyword";
    public static String MODE_TYPE = "mode";
    public static String IPADDR_TYPE = "ipaddr";
    public static String PORTADDR_TYPE = "portaddr";
    public static String LONG_STR_TYPE = "longstr";
    public static String MULTILINE_STR_TYPE = "multiline";
    public static String MULTILINE_STR_TYPE2 = "multiline2";
    public static String QUOTED_STR_TYPE = "quotedstr";
    public static String LONG_PASSWORD_TYPE = "lpwd";
    public static String SHORT_PASSWORD_TYPE = "spwd";
    int _paramType = -1;
    String _paramKey = "";

    ParamNode(int type, String key) {
        this._paramType = type;
        this._paramKey = key;
    }

    boolean matchNode(BaseNode node) {
        if (!(node instanceof ParamNode)) {
            return false;
        }
        ParamNode paramNode = (ParamNode)node;
        return this._paramKey.equals(paramNode.getParamKey()) && this._paramType == paramNode.getParamType() && super.matchNode(node);
    }

    boolean setParamStrType(String type) {
        int paramType = ParamNode.convertStringToInt(type);
        if (paramType != -1) {
            this._paramType = paramType;
        }
        return paramType != -1;
    }

    static int convertStringToInt(String type) {
        int parmType = -1;
        if (type.equals(STR_TYPE)) {
            parmType = 1;
        } else if (type.equals(INT_TYPE)) {
            parmType = 0;
        } else if (type.equals(KEYWORD_TYPE)) {
            parmType = 2;
        } else if (type.equals(MODE_TYPE)) {
            parmType = 3;
        } else if (type.equals(IPADDR_TYPE)) {
            parmType = 4;
        } else if (type.equals(PORTADDR_TYPE)) {
            parmType = 5;
        } else if (type.equals(LONG_STR_TYPE)) {
            parmType = 6;
        } else if (type.equals(MULTILINE_STR_TYPE)) {
            parmType = 7;
        } else if (type.equals(MULTILINE_STR_TYPE2)) {
            parmType = 10;
        } else if (type.equals(LONG_PASSWORD_TYPE)) {
            parmType = 8;
        } else if (type.equals(SHORT_PASSWORD_TYPE)) {
            parmType = 9;
        } else if (type.equals(QUOTED_STR_TYPE)) {
            parmType = 11;
        }
        return parmType;
    }

    public static int getParamType(String type) {
        return ParamNode.convertStringToInt(type);
    }

    void setParamType(int value) {
        this._paramType = value;
    }

    public int getParamType() {
        return this._paramType;
    }

    void setParamKey(String value) {
        this._paramKey = value;
    }

    public String getParamKey() {
        return this._paramKey;
    }

    public String toString() {
        String retStr = "";
        retStr = String.valueOf(retStr) + String.valueOf('<') + Integer.toString(this.getParamType()) + ",";
        retStr = String.valueOf(retStr) + this.getParamKey();
        retStr = String.valueOf(retStr) + ",";
        return retStr;
    }
}

