/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser.util;

import com.cisco.nm.xms.cliparser.util.Comparable;

public final class Sort {
    private static final int CUTOFF = 3;
    private static final int NUM_ITEMS = 1000;
    private static int theSeed = 1;

    public static void insertionSort(Comparable[] a) {
        int p = 1;
        while (p < a.length) {
            Comparable tmp = a[p];
            int j = p;
            while (j > 0 && tmp.compareTo(a[j - 1]) < 0) {
                a[j] = a[j - 1];
                --j;
            }
            a[j] = tmp;
            ++p;
        }
    }

    public static void shellsort(Comparable[] a) {
        int gap = a.length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < a.length) {
                Comparable tmp = a[i];
                int j = i;
                while (j >= gap && tmp.compareTo(a[j - gap]) < 0) {
                    a[j] = a[j - gap];
                    j -= gap;
                }
                a[j] = tmp;
                ++i;
            }
            gap /= 2;
        }
    }

    public static void heapsort(Comparable[] a) {
        int i = a.length / 2;
        while (i >= 0) {
            Sort.percDown(a, i, a.length);
            --i;
        }
        int i2 = a.length - 1;
        while (i2 > 0) {
            Sort.swapReferences(a, 0, i2);
            Sort.percDown(a, 0, i2);
            --i2;
        }
    }

    private static int leftChild(int i) {
        return 2 * i + 1;
    }

    private static void percDown(Comparable[] a, int i, int n) {
        Comparable tmp = a[i];
        while (Sort.leftChild(i) < n) {
            int child = Sort.leftChild(i);
            if (child != n - 1 && a[child].compareTo(a[child + 1]) < 0) {
                ++child;
            }
            if (tmp.compareTo(a[child]) >= 0) break;
            a[i] = a[child];
            i = child;
        }
        a[i] = tmp;
    }

    public static void mergeSort(Comparable[] a) {
        Comparable[] tmpArray = new Comparable[a.length];
        Sort.mergeSort(a, tmpArray, 0, a.length - 1);
    }

    private static void mergeSort(Comparable[] a, Comparable[] tmpArray, int left, int right) {
        if (left < right) {
            int center = (left + right) / 2;
            Sort.mergeSort(a, tmpArray, left, center);
            Sort.mergeSort(a, tmpArray, center + 1, right);
            Sort.merge(a, tmpArray, left, center + 1, right);
        }
    }

    private static void merge(Comparable[] a, Comparable[] tmpArray, int leftPos, int rightPos, int rightEnd) {
        int leftEnd = rightPos - 1;
        int tmpPos = leftPos;
        int numElements = rightEnd - leftPos + 1;
        while (leftPos <= leftEnd && rightPos <= rightEnd) {
            tmpArray[tmpPos++] = a[leftPos].compareTo(a[rightPos]) <= 0 ? a[leftPos++] : a[rightPos++];
        }
        while (leftPos <= leftEnd) {
            tmpArray[tmpPos++] = a[leftPos++];
        }
        while (rightPos <= rightEnd) {
            tmpArray[tmpPos++] = a[rightPos++];
        }
        int i = 0;
        while (i < numElements) {
            a[rightEnd] = tmpArray[rightEnd];
            ++i;
            --rightEnd;
        }
    }

    public static void quicksort(Comparable[] a) {
        Sort.quicksort(a, 0, a.length - 1);
    }

    public static final void swapReferences(Object[] a, int index1, int index2) {
        Object tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    private static Comparable median3(Comparable[] a, int left, int right) {
        int center = (left + right) / 2;
        if (a[center].compareTo(a[left]) < 0) {
            Sort.swapReferences(a, left, center);
        }
        if (a[right].compareTo(a[left]) < 0) {
            Sort.swapReferences(a, left, right);
        }
        if (a[right].compareTo(a[center]) < 0) {
            Sort.swapReferences(a, center, right);
        }
        Sort.swapReferences(a, center, right - 1);
        return a[right - 1];
    }

    private static void quicksort(Comparable[] a, int left, int right) {
        if (left + 3 <= right) {
            Comparable pivot = Sort.median3(a, left, right);
            int i = left;
            int j = right - 1;
            while (true) {
                if (a[++i].compareTo(pivot) < 0) {
                    continue;
                }
                while (a[--j].compareTo(pivot) > 0) {
                }
                if (i >= j) break;
                Sort.swapReferences(a, i, j);
            }
            Sort.swapReferences(a, i, right - 1);
            Sort.quicksort(a, left, i - 1);
            Sort.quicksort(a, i + 1, right);
        } else {
            Sort.insertionSort(a, left, right);
        }
    }

    private static void insertionSort(Comparable[] a, int left, int right) {
        int p = left + 1;
        while (p <= right) {
            Comparable tmp = a[p];
            int j = p;
            while (j > left && tmp.compareTo(a[j - 1]) < 0) {
                a[j] = a[j - 1];
                --j;
            }
            a[j] = tmp;
            ++p;
        }
    }

    public static void quickSelect(Comparable[] a, int k) {
        Sort.quickSelect(a, 0, a.length - 1, k);
    }

    private static void quickSelect(Comparable[] a, int left, int right, int k) {
        if (left + 3 <= right) {
            Comparable pivot = Sort.median3(a, left, right);
            int i = left;
            int j = right - 1;
            while (true) {
                if (a[++i].compareTo(pivot) < 0) {
                    continue;
                }
                while (a[--j].compareTo(pivot) > 0) {
                }
                if (i >= j) break;
                Sort.swapReferences(a, i, j);
            }
            Sort.swapReferences(a, i, right - 1);
            if (k <= i) {
                Sort.quickSelect(a, left, i - 1, k);
            } else if (k > i + 1) {
                Sort.quickSelect(a, i + 1, right, k);
            }
        } else {
            Sort.insertionSort(a, left, right);
        }
    }

    public static void main(String[] args) {
    }
}

