/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char LF = '\n';
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final String XML_RESERVED_CHAR_STR = "< > & % ' \"";
    public static final char[] XML_RESERVED_CHARS = new char[]{'>', '<', '&', '\"', '\'', '%'};

    public static final boolean hasXMLReservedChar(String s) {
        int ii = 0;
        while (ii < XML_RESERVED_CHARS.length) {
            if (s.indexOf(XML_RESERVED_CHARS[ii]) >= 0) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public static final int indexOfWhitespace(String s) {
        return StringUtils.indexOfWhitespace(s, 0);
    }

    public static final int indexOfWhitespace(String s, int index) {
        int length = s.length();
        while (index < length) {
            char c = s.charAt(index);
            if (c == ' ' || c == '\t' || c == '\n') {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static final int indexOfNonWhitespace(String s) {
        return StringUtils.indexOfNonWhitespace(s, 0);
    }

    public static final int indexOfNonWhitespace(String s, int index) {
        int length = s.length();
        while (index < length) {
            char c = s.charAt(index);
            if (c != ' ' && c != '\t' && c != '\n') {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static String toUnsignedString(int i, int shift) {
        char[] buf = new char[32];
        int charPos = 32;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[--charPos] = digits[i & mask];
        } while ((i >>>= shift) != 0);
        return new String(buf, charPos, 32 - charPos);
    }

    public static String join(String delimiter, String[] strings) {
        StringBuffer sb = new StringBuffer();
        int ii = 0;
        while (ii < strings.length - 1) {
            sb.append(strings[ii]);
            sb.append(delimiter);
            ++ii;
        }
        sb.append(strings[strings.length - 1]);
        return sb.toString();
    }

    public static String bin(int c) {
        return Integer.toBinaryString(c);
    }

    public static String oct(int c) {
        return Integer.toOctalString(c);
    }

    public static String hex(int c) {
        return Integer.toHexString(c);
    }

    public static String replace(String target, String older, String newer) {
        return StringUtils.join(StringUtils.splitToVector(target, older), newer);
    }

    public static String substitute(String str, String older, String newer) {
        int from = 0;
        while (str.indexOf(older, from) >= 0) {
            int offset = str.indexOf(older, from);
            str = new String(String.valueOf(str.substring(0, offset)) + newer + str.substring(offset + older.length(), str.length()));
            from = offset + newer.length();
        }
        return str;
    }

    public static String convertNumToBPS(long n) {
        double num = n;
        String units = null;
        int factor = 1;
        if (n < 1000L) {
            units = " b/s";
        } else if (n < 1000000L) {
            factor = 1000;
            units = " Kb/s";
        } else if (n < 1000000000L) {
            factor = 1000000;
            units = " Mb/s";
        } else {
            factor = 1000000000;
            units = " Gb/s";
        }
        return new String(String.valueOf(num /= (double)factor) + units);
    }

    public String reverse(String s) {
        int length = s.length();
        StringBuffer reverse = new StringBuffer(length);
        int ii = length - 1;
        while (ii >= 0) {
            reverse.append(s.charAt(ii));
            --ii;
        }
        return reverse.toString();
    }

    public static int getCharCount(String s, char c) {
        int count = 0;
        int index = 0;
        while (index != -1) {
            if ((index = s.indexOf(c, index)) == -1) continue;
            ++count;
            ++index;
        }
        return count;
    }

    public static String getHexDigit(int c) {
        String s = null;
        switch (c & 0xF) {
            case 0: {
                s = "0";
                break;
            }
            case 1: {
                s = "1";
                break;
            }
            case 2: {
                s = "2";
                break;
            }
            case 3: {
                s = "3";
                break;
            }
            case 4: {
                s = "4";
                break;
            }
            case 5: {
                s = "5";
                break;
            }
            case 6: {
                s = "6";
                break;
            }
            case 7: {
                s = "7";
                break;
            }
            case 8: {
                s = "8";
                break;
            }
            case 9: {
                s = "9";
                break;
            }
            case 10: {
                s = "a";
                break;
            }
            case 11: {
                s = "b";
                break;
            }
            case 12: {
                s = "c";
                break;
            }
            case 13: {
                s = "d";
                break;
            }
            case 14: {
                s = "e";
                break;
            }
            case 15: {
                s = "f";
                break;
            }
        }
        return s;
    }

    public static String toHex(int c) {
        if (c < 0) {
            throw new IllegalArgumentException("Invalid character: " + c);
        }
        if (c < 10) {
            return "0" + c;
        }
        return String.valueOf(StringUtils.getHexDigit(c >> 4)) + StringUtils.getHexDigit(c & 0xF);
    }

    public static String toHex(String s) {
        return StringUtils.toHex(s.getBytes());
    }

    public static String toHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int ii = 0;
        while (ii < bytes.length) {
            sb.append(StringUtils.toHex(bytes[ii]));
            ++ii;
        }
        return sb.toString();
    }

    public static String toString(String[] array) {
        StringBuffer sb = new StringBuffer();
        try {
            int num = array.length;
            int ii = 0;
            while (ii < num) {
                sb.append(array[ii]);
                sb.append(" ");
                ++ii;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return sb.toString().trim();
    }

    public static String[] split(String s) {
        String[] array = null;
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s);
            array = new String[st.countTokens()];
            int ii = 0;
            while (st.hasMoreTokens()) {
                array[ii++] = st.nextToken();
            }
        }
        return array;
    }

    public static final String[] split(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        Vector<String> splits = new Vector<String>();
        int index = -1;
        while ((index = s.indexOf(delimiter)) >= 0) {
            splits.addElement(s.substring(0, index));
            s = s.substring(index + delimiter.length(), s.length());
        }
        if (s.length() > 0) {
            splits.addElement(s);
        }
        Object[] strings = new String[splits.size()];
        splits.copyInto(strings);
        return strings;
    }

    public static Vector splitToVector(String s, char delim) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(s, new Character(delim).toString());
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        return v;
    }

    public static int numOfWords(String s) {
        return StringUtils.splitToVector(s, ' ').size();
    }

    public static Vector splitToVector(String s, String delim) {
        int i = 0;
        int j = 0;
        Vector<String> v = new Vector<String>();
        while ((j = s.indexOf(delim, i)) >= 0) {
            if (j > i) {
                v.addElement(s.substring(i, j));
                i = j + delim.length();
            }
            if (j != i) continue;
            ++i;
        }
        if (i < s.length()) {
            v.addElement(s.substring(i));
        }
        return v;
    }

    public static String join(Vector v, char delim) {
        if (v.size() == 1) {
            return (String)v.elementAt(0);
        }
        return StringUtils.join(v, 0, v.size() - 1, delim);
    }

    public static String join(Vector v, String delim) {
        if (v.size() == 1) {
            return (String)v.elementAt(0);
        }
        return StringUtils.join(v, 0, v.size() - 1, delim);
    }

    public static String join(Vector v, int first, int last, char delim) {
        StringBuffer str = new StringBuffer();
        int i = first;
        while (i <= last) {
            str.append(v.elementAt(i));
            if (i < last) {
                str.append(delim);
            }
            ++i;
        }
        return str.toString();
    }

    public static String join(Vector v, int first, int last, String delim) {
        StringBuffer str = new StringBuffer();
        int i = first;
        while (i <= last) {
            str.append(v.elementAt(i));
            if (i < last) {
                str.append(delim);
            }
            ++i;
        }
        return str.toString();
    }

    public static String getPackageName(Object o) {
        String name = o.getClass().getName();
        return name.substring(0, name.lastIndexOf(46));
    }

    public static String arrayToString(int[] array) {
        if (array.length == 0) {
            return "";
        }
        String s = new String("{");
        int i = 0;
        while (i < array.length) {
            s = i == 0 ? String.valueOf(s) + array[i] : String.valueOf(s) + "," + array[i];
            ++i;
        }
        return String.valueOf(s) + "}";
    }

    public static String intArrayToHexString(int[] ints) {
        if (ints.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(ints.length * 2);
        int i = 0;
        while (i < ints.length) {
            int j = ints[i] & 0xFF;
            sb.append(Character.forDigit(j / 16, 16));
            sb.append(Character.forDigit(j % 16, 16));
            ++i;
        }
        return sb.toString();
    }

    public static String intArrayToCharString(int[] ints) {
        if (ints.length == 0) {
            return "";
        }
        char[] str = new char[ints.length];
        int i = 0;
        while (i < ints.length) {
            str[i] = (char)ints[i];
            ++i;
        }
        return new String(str);
    }

    public static String asciiStringToOid(String str) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(len << 1);
        int i = 0;
        while (i < len) {
            sb.append("." + str.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public static boolean getBoolean(String s) {
        return StringUtils.getBoolean(s, false);
    }

    public static boolean getBoolean(String s, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            String str = s.toLowerCase();
            value = str.equals("true");
        }
        catch (Exception exception) {}
        return value;
    }

    public static double getDouble(String s) {
        return StringUtils.getDouble(s, 0.0);
    }

    public static double getDouble(String s, double defaultValue) {
        double value = defaultValue;
        try {
            value = new Double(s);
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public static int getInt(String s) {
        return StringUtils.getInt(s, 0);
    }

    public static int getInt(String s, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public static long getLong(String s) {
        return StringUtils.getLong(s, 0L);
    }

    public static long getLong(String s, long defaultValue) {
        long value = defaultValue;
        try {
            value = Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public static String[] getKeysWithString(Hashtable hash, String s) {
        Vector<String> keys = new Vector<String>();
        Enumeration enumeration = hash.keys();
        while (enumeration != null && enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (key.indexOf(s) < 0) continue;
            keys.addElement(key);
        }
        Object[] array = new String[keys.size()];
        keys.copyInto(array);
        return array;
    }
}

