/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.FileAppMap;
import com.cisco.updateengine.JMiscUtil;
import com.cisco.updateengine.JPackage;
import com.cisco.updateengine.JSDMUpdateAPIWrapper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AppSizeFinder {
    Hashtable _fileToAppMap = new Hashtable();

    public void addFilesToMap(JPackage pkg) {
        Vector files = pkg.getFiles();
        String name = pkg.get_name();
        int i = 0;
        while (i < files.size()) {
            String file = (String)files.elementAt(i);
            FileAppMap map = (FileAppMap)this._fileToAppMap.get(file);
            if (map == null) {
                map = new FileAppMap();
                map.set_app(name);
                map.set_file(file);
                this._fileToAppMap.put(file, map);
            } else {
                map.set_app(String.valueOf(map.get_app()) + "," + name);
            }
            ++i;
        }
    }

    public String discover() {
        Hashtable installedApps = JMiscUtil.getUpdateEngine().getAppsInstalledOnRouter();
        Enumeration enumeration = installedApps.elements();
        while (enumeration.hasMoreElements()) {
            this.addFilesToMap((JPackage)enumeration.nextElement());
        }
        this.groupFilesUnderApp();
        return this.getfileSizeInfo();
    }

    public long getTotalFileSize(String files, Hashtable filesizeHT) {
        if (filesizeHT == null) {
            return 0L;
        }
        long total = 0L;
        StringTokenizer tk = new StringTokenizer(files, ",");
        while (tk.hasMoreTokens()) {
            String size = (String)filesizeHT.get(tk.nextToken());
            if (size == null) continue;
            total += Long.parseLong(size);
        }
        return total;
    }

    public String getfileSizeInfo() {
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        Hashtable fileSizeMap = JSDMUpdateAPIWrapper.getFileSizePairFromRouter();
        StringBuffer header = new StringBuffer("[FileSizeInfo]\n");
        StringBuffer sb = new StringBuffer();
        Enumeration enumeration = this._fileToAppMap.elements();
        while (enumeration.hasMoreElements()) {
            FileAppMap map = (FileAppMap)enumeration.nextElement();
            System.out.println(map.get_app());
            long size = this.getTotalFileSize(map.get_file(), fileSizeMap);
            if (size <= 0L) continue;
            sb.append(map.get_app()).append(" = ").append(size).append("\n");
        }
        long nRecycled = JSDMUpdateAPIWrapper.getTotalSizeOfDeletedFiles();
        if (nRecycled > 0L) {
            sb.append("RecycleBin").append(" = ").append(nRecycled).append("\n");
        }
        if (sb.toString().trim().length() != 0) {
            header.append(sb.toString());
            return header.toString();
        }
        return "";
    }

    public void groupFilesUnderApp() {
        Hashtable<String, FileAppMap> table = new Hashtable<String, FileAppMap>();
        Enumeration enumeration = this._fileToAppMap.elements();
        while (enumeration.hasMoreElements()) {
            FileAppMap map = (FileAppMap)enumeration.nextElement();
            String file = map.get_file();
            String apps = map.get_app();
            FileAppMap temp = (FileAppMap)table.get(apps);
            if (temp == null) {
                temp = new FileAppMap();
                temp.set_app(apps);
                temp.set_file(file);
                table.put(apps, temp);
                continue;
            }
            temp.set_file(String.valueOf(temp.get_file()) + "," + file);
        }
        this._fileToAppMap = table;
    }
}

