/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.ConfigEngine;
import com.cisco.updateengine.DiscoverHTTPS;
import com.cisco.updateengine.JCmdCopyApplication;
import com.cisco.updateengine.JMiscUtil;
import com.cisco.updateengine.JSDMUpdateAPIWrapper;
import com.cisco.updateengine.JUpdate;
import com.cisco.updateengine.JUpdateCommandBase;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import java.util.StringTokenizer;
import java.util.Vector;

public class BackupCmd
extends JUpdateCommandBase {
    private Vector _apps;
    private String _backupDir;

    public BackupCmd() {
        this._apps = new Vector();
    }

    public BackupCmd(IOSCmdService p0) {
        super(p0);
    }

    public boolean doBackUp() {
        boolean bHTTPEnabled_AdHoc = false;
        if (!DiscoverHTTPS.isHTTPEnabled()) {
            ConfigEngine.enableHTTP(true);
            bHTTPEnabled_AdHoc = true;
        }
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        JUpdate engine = JMiscUtil.getUpdateEngine();
        JCmdCopyApplication copyCmd = new JCmdCopyApplication();
        copyCmd.set_apps(this._apps);
        boolean bStatus = JSDMUpdateAPIWrapper.backupSDMFilesFromRouter(engine.getCmdsvc(), this._backupDir, copyCmd.getFilesForAppsOnRouter(), engine.get_username(), engine.get_password());
        if (bHTTPEnabled_AdHoc) {
            ConfigEngine.enableHTTP(false);
        }
        return bStatus;
    }

    public boolean executeCommand() {
        boolean bStatus = true;
        if (this._backupDir != null && this._backupDir.length() != 0) {
            bStatus = this.doBackUp();
        }
        this.writeStatus(bStatus);
        return bStatus;
    }

    public void populate(Vector param) {
        int i = 0;
        while (i < param.size()) {
            String item = ((String)param.elementAt(i)).trim();
            if (!item.startsWith("[") || !item.endsWith("]")) {
                String prefix = item.substring(0, item.indexOf("=")).trim();
                String suffix = item.substring(item.indexOf("=") + 1, item.length()).trim();
                if (prefix.equalsIgnoreCase("BackupPath")) {
                    this._backupDir = suffix;
                } else if (prefix.equalsIgnoreCase("Applications")) {
                    StringTokenizer tk = new StringTokenizer(suffix, ":");
                    while (tk.hasMoreTokens()) {
                        this._apps.addElement(tk.nextToken());
                    }
                }
            }
            ++i;
        }
    }

    public void writeStatus(boolean bSuccess) {
        StringBuffer sb = new StringBuffer("[Command]\n");
        sb.append("Command=").append(this.getcommandID()).append("\n");
        sb.append("Status=").append(bSuccess ? "0" : "1");
        JMiscUtil.printToFile(JMiscUtil.getUpdateEngine().get_resultFile(), sb.toString());
    }
}

