/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.AppSizeFinder;
import com.cisco.updateengine.ConfigEngine;
import com.cisco.updateengine.DiscoverHTTPS;
import com.cisco.updateengine.JDiscoverFlash;
import com.cisco.updateengine.JDiscoverIDS;
import com.cisco.updateengine.JDiscoverMisc;
import com.cisco.updateengine.JDiscoverWireless;
import com.cisco.updateengine.JLog;
import com.cisco.updateengine.JMiscUtil;
import com.cisco.updateengine.JUpdateCommandBase;
import com.cisco.xdm.io.Base64;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class CCmdDiscover
extends JUpdateCommandBase {
    public CCmdDiscover() {
    }

    public CCmdDiscover(IOSCmdService cmdsvc) {
        this._cmdSvc = cmdsvc;
    }

    public void checkHTTPAccess(boolean bHTTP_Enabled_AdHoc) {
        boolean bConnectionRefused = false;
        URL url = null;
        URLConnection urlC = null;
        try {
            String urlString = "http://" + this._cmdSvc.getIPAddress();
            if (DiscoverHTTPS.getHTTPPort() != 80) {
                urlString = String.valueOf(urlString) + ":" + Integer.toString(DiscoverHTTPS.getHTTPPort());
            }
            url = new URL(urlString);
            urlC = url.openConnection();
            urlC.setDoOutput(true);
            urlC.setDoInput(true);
            urlC.setUseCaches(false);
            urlC.setRequestProperty("Authorization", "Basic " + Base64.encode(String.valueOf(JMiscUtil.getUpdateEngine().get_username()) + ":" + JMiscUtil.getUpdateEngine().get_password()));
            InputStream is = urlC.getInputStream();
            if (is == null) {
                bConnectionRefused = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JLog.printStackTrace(e);
            bConnectionRefused = true;
        }
        if (bConnectionRefused) {
            if (bHTTP_Enabled_AdHoc) {
                ConfigEngine.enableHTTP(false);
            }
            JMiscUtil.getUpdateEngine().httpConnection_ToRouter_Refused();
        }
    }

    private void discoverFlash() {
        this._output.append(JDiscoverFlash.discover(this._cmdSvc));
        this.writeNextLine();
    }

    public void discoverHTTPAccess() {
        boolean bHTTPEnabled_AdHoc = false;
        if (!DiscoverHTTPS.isHTTPEnabled()) {
            ConfigEngine.enableHTTP(true);
            bHTTPEnabled_AdHoc = true;
        }
        this.checkHTTPAccess(bHTTPEnabled_AdHoc);
        if (bHTTPEnabled_AdHoc) {
            ConfigEngine.enableHTTP(false);
        }
    }

    public void discoverInstalledAppSize() {
        this._output.append(new AppSizeFinder().discover());
    }

    private void discoverIsWebVPNImage() {
        this._output.append(JDiscoverMisc.discoverWebVPNImage(this._cmdSvc));
        this.writeNextLine();
    }

    private void discoverModel() {
        this._output.append(JDiscoverMisc.discover(this._cmdSvc));
        this.writeNextLine();
    }

    public void discoverProtocols() {
        DiscoverHTTPS cmd = new DiscoverHTTPS(this._cmdSvc);
        cmd.executeCommand();
        this._output.append("\n").append(cmd.getOutput());
    }

    private void discoverSubSystems() {
        this._output.append(JDiscoverIDS.discover(this._cmdSvc));
        this.writeNextLine();
        this._output.append(JDiscoverWireless.discover(this._cmdSvc));
        this.writeNextLine();
    }

    public boolean executeCommand() {
        this.discoverProtocols();
        this._output.append("\n[Discovery]");
        this._output.append(System.getProperty("line.separator"));
        this.discoverHTTPAccess();
        this.discoverSubSystems();
        this.discoverModel();
        JMiscUtil.getUpdateEngine().readPackageFromXML();
        JMiscUtil.getUpdateEngine().readLegacyVersionsFromXML();
        this.discoverFlash();
        this.discoverInstalledAppSize();
        this._output.append("\n[DiscoverWebVPN]");
        this._output.append(System.getProperty("line.separator"));
        this.discoverIsWebVPNImage();
        this.serialize();
        return true;
    }

    public void piggyBackMessage(String message) {
        this._output.append(message);
    }

    public void populate(Vector param) {
    }
}

