/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.ConfigEngine;
import com.cisco.updateengine.DiscoverHTTPS;
import com.cisco.updateengine.JDiscoverFlash;
import com.cisco.updateengine.JLog;
import com.cisco.updateengine.JMiscUtil;
import com.cisco.updateengine.JPackage;
import com.cisco.updateengine.JSDMUpdateAPIWrapper;
import com.cisco.updateengine.JUpdate;
import com.cisco.updateengine.JUpdateCommandBase;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class JCmdCopyApplication
extends JUpdateCommandBase {
    private Hashtable _copiedFiles;
    private String _disk;
    private Vector _apps = new Vector();
    private String _backupDir = null;
    private String _LocalDir = null;
    private static String appLocation = "";
    private boolean _enableHTTP = false;
    private boolean _enableHTTPS = false;
    private int _status = 0;
    private int _memoryReq = 0;
    private static int STAT_SUCCESS = 0;
    private static int STAT_NOMEM = 1;
    private static int STAT_UNKNOWN = 2;
    public static int STAT_RCPBLOCKED = 3;
    private static int STAT_FILESZEXEEDED = 4;
    private static int STAT_BKUPFAILED = 5;
    private static int STAT_DELETEFAILED = 6;
    private static int STAT_SQUEEZEFAILED = 7;
    private static int STAT_COPYFAILED = 8;
    private static int STAT_ENABLE_HTTP_FAILED = 9;
    private static int STAT_ENABLE_HTTPS_FAILED = 10;
    private static int MSG_BEGIN_RCPENABLE = 1001;
    private static int MSG_END_RCPENABLE = 1002;
    private static int MSG_BEGIN_MEMCHECK = 1010;
    private static int MSG_END_MEMCHECK = 1011;
    private static int MSG_BEGIN_BACKUP = 1020;
    private static int MSG_END_BACKUP = 1021;
    private static int MSG_BEGIN_DELETE = 1030;
    private static int MSG_END_DELETE = 1031;
    private static int MSG_BEGIN_SQUEEZ = 1040;
    private static int MSG_END_SQUEEZ = 1041;
    private static int MSG_BEGIN_COPY = 1050;
    private static int MSG_END_COPY = 1051;
    private static boolean _bgRCP_Enabled = false;

    public JCmdCopyApplication() {
        this._copiedFiles = new Hashtable();
    }

    public boolean configureCLI() {
        JLog.debug("Inside configureCLI");
        JLog.debug(DiscoverHTTPS.isHTTPSSupported() ? "HTTPS is supported" : "HTTPS is not supported");
        JLog.debug(DiscoverHTTPS.is_https_blocked() ? "HTTPS is blocked" : "HTTPS is not blocked");
        JLog.debug(DiscoverHTTPS.isHTTPSEnabled() ? "HTTPS is enabled" : "HTTPS is not enabled");
        if (DiscoverHTTPS.isHTTPSSupported() && !DiscoverHTTPS.is_https_blocked()) {
            if (!DiscoverHTTPS.isHTTPSEnabled()) {
                JLog.debug("Enabling HTTPS");
                if (!ConfigEngine.enableHTTPS(true)) {
                    this._status = STAT_ENABLE_HTTPS_FAILED;
                    JLog.debug("Enable HTTPS Failed");
                }
            }
        } else if (!DiscoverHTTPS.isHTTPEnabled() && !ConfigEngine.enableHTTP(true)) {
            this._status = STAT_ENABLE_HTTP_FAILED;
        }
        return this._status == STAT_SUCCESS;
    }

    public boolean copyPackages() {
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        Hashtable appLocations = this.getLocationofAppsonRouter(this._apps);
        this._copiedFiles.clear();
        Hashtable apps = JMiscUtil.getUpdateEngine().getAppsOnCD();
        int i = 0;
        while (i < this._apps.size()) {
            String app = (String)this._apps.elementAt(i);
            JPackage japp = (JPackage)apps.get(app);
            if (japp != null) {
                JMiscUtil.writeStatus(String.valueOf(Integer.toString(MSG_BEGIN_COPY)) + "," + app);
                Vector files = japp.getFiles(this._LocalDir);
                files = this.getUniqueFiles(files);
                boolean bStatus = api.copyFiles((String)appLocations.get(app), files);
                if (!bStatus) {
                    this._status = STAT_COPYFAILED;
                    return false;
                }
                JMiscUtil.writeStatus(String.valueOf(Integer.toString(MSG_END_COPY)) + "," + app);
            }
            ++i;
        }
        return true;
    }

    public boolean deleteCSDSVCFilesFromFlash(String packageName) {
        boolean result = false;
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        JUpdate engine = JMiscUtil.getUpdateEngine();
        Hashtable CSDSVCTable = new Hashtable();
        boolean bStatus = false;
        if (packageName == "CSD") {
            CSDSVCTable = JDiscoverFlash.getFileNameSizeFromRouter("securedesktop");
        }
        if (packageName == "SVC") {
            CSDSVCTable = JDiscoverFlash.getFileNameSizeFromRouter("sslclient");
        }
        if (CSDSVCTable.size() > 0) {
            Enumeration keys = CSDSVCTable.keys();
            String fileName = null;
            while (keys.hasMoreElements()) {
                fileName = (String)keys.nextElement();
                result = bStatus = JSDMUpdateAPIWrapper.deleteFileFromRouter(engine.getCmdsvc(), this.getLocation(), fileName);
            }
        }
        return result;
    }

    public boolean deleteFilesFromRouter() {
        Hashtable installedApps = JMiscUtil.getUpdateEngine().getAppsInstalledOnRouter();
        if (installedApps == null || installedApps.size() == 0) {
            return true;
        }
        JMiscUtil.writeStatus(Integer.toString(MSG_BEGIN_DELETE));
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        JUpdate engine = JMiscUtil.getUpdateEngine();
        int i = 0;
        while (i < this._apps.size()) {
            String app = (String)this._apps.elementAt(i);
            if (app.equals("CSD")) {
                boolean bStatus = this.deleteCSDSVCFilesFromFlash("CSD");
            } else if (app.equals("SVC")) {
                boolean bStatus = this.deleteCSDSVCFilesFromFlash("SVC");
            } else {
                JPackage pkg = (JPackage)installedApps.get(app);
                if (pkg != null) {
                    Vector files = pkg.getFiles();
                    int j = 0;
                    while (j < files.size()) {
                        String file = (String)files.elementAt(j);
                        boolean bStatus = JSDMUpdateAPIWrapper.deleteFileFromRouter(engine.getCmdsvc(), JSDMUpdateAPIWrapper.getAppLocationOnRouter(engine.getCmdsvc(), pkg.get_masterFile()), file);
                        if (!bStatus) {
                            this._status = STAT_DELETEFAILED;
                            return false;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        JMiscUtil.writeStatus(Integer.toString(MSG_END_DELETE));
        return true;
    }

    public boolean doBackUp() {
        JMiscUtil.writeStatus(Integer.toString(MSG_BEGIN_BACKUP));
        boolean bHTTPEnabled_AdHoc = false;
        if (!DiscoverHTTPS.isHTTPEnabled()) {
            ConfigEngine.enableHTTP(true);
            bHTTPEnabled_AdHoc = true;
        }
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        JUpdate engine = JMiscUtil.getUpdateEngine();
        boolean bStatus = JSDMUpdateAPIWrapper.backupSDMFilesFromRouter(engine.getCmdsvc(), this._backupDir, this.getFilesForAppsOnRouter(), engine.get_username(), engine.get_password());
        if (!bStatus) {
            this._status = STAT_BKUPFAILED;
        }
        if (bHTTPEnabled_AdHoc) {
            ConfigEngine.enableHTTP(false);
        }
        JMiscUtil.writeStatus(Integer.toString(MSG_END_BACKUP));
        return bStatus;
    }

    public boolean doCopy() {
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        api.enableRCP(JMiscUtil.getUpdateEngine().getCmdsvc());
        boolean bCopy = this.copyPackages();
        api.disableRCP();
        return bCopy;
    }

    public boolean doSqueeze() {
        Enumeration enumeration;
        if (JMiscUtil.get_model().startsWith("87") || JMiscUtil.get_model().startsWith("85")) {
            return true;
        }
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        JUpdate engine = JMiscUtil.getUpdateEngine();
        String sdmLoc = "";
        String masterFile = null;
        Hashtable installedApps = JMiscUtil.getUpdateEngine().getAppsInstalledOnRouter();
        if (installedApps != null && installedApps.size() > 0 && (enumeration = installedApps.elements()).hasMoreElements()) {
            JPackage pkg = (JPackage)enumeration.nextElement();
            masterFile = pkg.get_masterFile();
        }
        sdmLoc = JSDMUpdateAPIWrapper.getAppLocationOnRouter(engine.getCmdsvc(), masterFile);
        if (api.isSqueezeNeeded() && JSDMUpdateAPIWrapper.getFileSystemType(engine.getCmdsvc(), sdmLoc).equals("LEFS")) {
            JMiscUtil.writeStatus(Integer.toString(MSG_BEGIN_SQUEEZ));
            boolean bStatus = JSDMUpdateAPIWrapper.squeezeRouter(engine.getCmdsvc(), sdmLoc);
            if (!bStatus) {
                this._status = STAT_SQUEEZEFAILED;
                return false;
            }
            JMiscUtil.writeStatus(Integer.toString(MSG_END_SQUEEZ));
        }
        return true;
    }

    public boolean enoughMemory() {
        JMiscUtil.writeStatus(Integer.toString(MSG_BEGIN_MEMCHECK));
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        Vector filesOnRouter = JMiscUtil.removeDuplicateItemsFromVector(this.getFilesForAppsOnRouter());
        Vector filesOnCD = JMiscUtil.removeDuplicateItemsFromVector(this.getFilesTobeInstalled());
        try {
            boolean bEnufMemory = api.isMemorySufficientForUpdates(filesOnRouter, filesOnCD, this._memoryReq, JMiscUtil.getUpdateEngine().getCmdsvc());
            if (!bEnufMemory) {
                this._status = STAT_NOMEM;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JLog.printStackTrace(e);
            this._status = STAT_UNKNOWN;
        }
        JMiscUtil.writeStatus(Integer.toString(MSG_END_MEMCHECK));
        return this._status == STAT_SUCCESS;
    }

    public void execute() {
        this.setDisk();
        if (!this.isRCPEnabled()) {
            return;
        }
        if (!this.enoughMemory()) {
            this.isFileLimitExeeded();
            return;
        }
        if (this._backupDir != null && this._backupDir.length() != 0 && !this.doBackUp()) {
            return;
        }
        if (!this.deleteFilesFromRouter()) {
            return;
        }
        if (!this.doSqueeze()) {
            return;
        }
        if (!this.doCopy()) {
            return;
        }
        JLog.debug("Configuring CLI");
        this.configureCLI();
    }

    public boolean executeCommand() {
        this.execute();
        this.writeStatus();
        return true;
    }

    public Vector getFilesForApps(Hashtable appsInContext) {
        Vector vect = new Vector();
        int i = 0;
        while (i < this._apps.size()) {
            String app = (String)this._apps.elementAt(i);
            JPackage pkg = (JPackage)appsInContext.get(app);
            if (pkg != null) {
                JMiscUtil.copyVector(vect, pkg.getFiles());
            }
            ++i;
        }
        return vect;
    }

    public Vector getFilesForAppsOnRouter() {
        Hashtable installedApps = JMiscUtil.getUpdateEngine().getAppsInstalledOnRouter();
        return this.getFilesForApps(installedApps);
    }

    public Vector getFilesTobeInstalled() {
        Hashtable appsOnCD = JMiscUtil.getUpdateEngine().getAppsOnCD();
        return this.getFilesForApps(appsOnCD);
    }

    public String getLocation() {
        Enumeration enumeration;
        String sdmLoc = "";
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        JUpdate engine = JMiscUtil.getUpdateEngine();
        String masterFile = null;
        Hashtable installedApps = JMiscUtil.getUpdateEngine().getAppsInstalledOnRouter();
        if (installedApps != null && installedApps.size() > 0 && (enumeration = installedApps.elements()).hasMoreElements()) {
            JPackage pkg = (JPackage)enumeration.nextElement();
            masterFile = pkg.get_masterFile();
        }
        sdmLoc = JSDMUpdateAPIWrapper.getAppLocationOnRouter(engine.getCmdsvc(), masterFile);
        return sdmLoc;
    }

    public Hashtable getLocationofAppsonRouter(Vector packages) {
        Hashtable<String, String> appLocations = new Hashtable<String, String>();
        Hashtable apps = JMiscUtil.getUpdateEngine().getAppsOnCD();
        int i = 0;
        while (i < packages.size()) {
            String app = (String)packages.elementAt(i);
            JPackage japp = (JPackage)apps.get(app);
            if (japp != null) {
                String loc = JSDMUpdateAPIWrapper.getAppLocationOnRouter(JMiscUtil.getUpdateEngine().getCmdsvc(), japp.get_masterFile());
                appLocations.put(app, loc);
            }
            ++i;
        }
        return appLocations;
    }

    public Vector getUniqueFiles(Vector files) {
        Vector<File> vect = new Vector<File>();
        int i = 0;
        while (i < files.size()) {
            File file = (File)files.elementAt(i);
            String name = file.getName();
            if (this._copiedFiles.get(name) == null) {
                this._copiedFiles.put(name, name);
                vect.addElement(file);
            }
            ++i;
        }
        return vect;
    }

    public void isFileLimitExeeded() {
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        if (api.isFilesLimitExceeded()) {
            this._status = STAT_FILESZEXEEDED;
        }
    }

    public boolean isRCPEnabled() {
        if (_bgRCP_Enabled) {
            return true;
        }
        JMiscUtil.writeStatus(Integer.toString(MSG_BEGIN_RCPENABLE));
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        boolean rcpEnabled = api.checkRCPEnabled(JMiscUtil.getUpdateEngine().getCmdsvc());
        this._status = rcpEnabled ? this._status : STAT_RCPBLOCKED;
        JMiscUtil.writeStatus(Integer.toString(MSG_END_RCPENABLE));
        _bgRCP_Enabled = rcpEnabled;
        return rcpEnabled;
    }

    public void populate(Vector param) {
        int i = 0;
        while (i < param.size()) {
            String item = ((String)param.elementAt(i)).trim();
            if (!item.startsWith("[") || !item.endsWith("]")) {
                String prefix = item.substring(0, item.indexOf("=")).trim();
                String suffix = item.substring(item.indexOf("=") + 1, item.length()).trim();
                if (prefix.equalsIgnoreCase("BackupPath")) {
                    this._backupDir = suffix;
                } else if (prefix.equalsIgnoreCase("Applications")) {
                    StringTokenizer tk = new StringTokenizer(suffix, ":");
                    while (tk.hasMoreTokens()) {
                        this._apps.addElement(tk.nextToken());
                    }
                } else if (prefix.equalsIgnoreCase("File")) {
                    this._LocalDir = suffix;
                } else if (prefix.equalsIgnoreCase("Size")) {
                    this._memoryReq = Integer.parseInt(suffix);
                } else if (prefix.equalsIgnoreCase("EnableHTTP")) {
                    this._enableHTTP = true;
                } else if (prefix.equalsIgnoreCase("EnableHTTPS")) {
                    this._enableHTTPS = true;
                } else if (prefix.equalsIgnoreCase("Disk")) {
                    this._disk = suffix;
                }
            }
            ++i;
        }
    }

    public void setBackupPath(String path) {
        this._backupDir = path;
    }

    public void setDisk() {
        if (this._disk != null && this._disk.trim().length() != 0) {
            JMiscUtil.getUpdateEngine().getAPIWrapper();
            JSDMUpdateAPIWrapper.setAppLocationOnRouter(this._disk.trim());
        }
    }

    public void set_apps(Vector apps) {
        this._apps = apps;
    }

    public void writeStatus() {
        StringBuffer sb = new StringBuffer("[Command]\n");
        sb.append("Command=").append(this.getcommandID()).append("\n");
        sb.append("Status=").append(this._status).append("\n");
        JMiscUtil.printToFile(JMiscUtil.getUpdateEngine().get_resultFile(), sb.toString());
    }
}

