/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.JLog;
import com.cisco.xdm.net.cmdsvc.CredentialRepository;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceFactory;

public class JCommunicationEngine {
    private String _result;
    private int _nReason;

    public IOSCmdService connect(int protocol, String userid, String password, String ip, String strOutFile) {
        JLog.debug("Inside connect...");
        Object cmdsvc = null;
        CredentialRepository cr = new CredentialRepository(userid, password);
        JLog.debug("Credential Repository created...");
        return this.connectToRouter(ip, cr, protocol);
    }

    private IOSCmdService connectToRouter(String ip, CredentialRepository cr, int protocol) {
        IOSCmdService comm = this.tryToConnect(ip, cr, protocol);
        if (comm == null && protocol == 1 && (this._nReason == 4 || this._nReason == 3)) {
            comm = this.tryToConnect(ip, cr, ++protocol);
        }
        return comm;
    }

    private void formatResult(int nProtocol, int nStatus, int nReason) {
        StringBuffer sb = new StringBuffer("");
        if (nReason == 5) {
            sb.append("\n[Priviledge] \nPriviledge=0 \n");
        } else {
            sb.append("[Connection]");
            sb.append(System.getProperty("line.separator"));
            sb.append("Protocol=").append(Integer.toString(nProtocol));
            sb.append(System.getProperty("line.separator"));
            sb.append("Status=").append(Integer.toString(nStatus));
            sb.append(System.getProperty("line.separator"));
            if (nStatus != 0) {
                sb.append("Reason=").append(Integer.toString(nReason));
                sb.append(System.getProperty("line.separator"));
            }
        }
        this._result = sb.toString();
    }

    public int getStatus(IOSCmdServiceException e, int protocol) {
        int nReason = 3;
        String exMsg = e.getMessage() != null ? e.getMessage() : (e._exception.getMessage() != null ? e._exception.getMessage() : "");
        JLog.debug("Connection Error " + exMsg);
        if (exMsg != null) {
            if (exMsg.trim().length() == 0 && protocol == 1 && e._exception instanceof IOSCmdServiceException) {
                IOSCmdServiceException e2 = (IOSCmdServiceException)e._exception;
                exMsg = e2._exception.getMessage();
            }
            if (exMsg.equals("credentials") || exMsg.indexOf("HTTP response code") != -1 && exMsg.indexOf("401") != -1) {
                nReason = 1;
            } else if (exMsg.equals("login sequence")) {
                nReason = 1;
            } else if (exMsg.indexOf("Connection refused") != -1) {
                nReason = 4;
            } else if (exMsg.equals("canceled")) {
                nReason = 3;
            } else if (exMsg.indexOf("Connection timed out") != -1 || exMsg.indexOf("Bad IP address") != -1) {
                nReason = 2;
            } else if (exMsg.indexOf("PAI communication protocol error - PAI not supported") != -1) {
                nReason = 0;
            } else if (exMsg.indexOf("Insufficient privilege") != -1) {
                nReason = 5;
            }
        } else {
            nReason = e.getExceptionCode();
        }
        return nReason;
    }

    public String get_result() {
        return this._result;
    }

    public IOSCmdService tryToConnect(String ip, CredentialRepository cr, int protocol) {
        JLog.debug("Using JVM version:" + System.getProperty("java.version"));
        String strProtocol = "";
        switch (protocol) {
            case 0: {
                strProtocol = "http";
                break;
            }
            case 1: {
                strProtocol = "ssh";
                break;
            }
            case 2: {
                strProtocol = "telnet";
                break;
            }
        }
        JLog.debug("Trying to connect to " + ip + " using " + strProtocol);
        int nStatus = 0;
        IOSCmdService cmdsvc = null;
        try {
            cmdsvc = IOSCmdServiceFactory.create(strProtocol, ip, -1, cr);
        }
        catch (IOSCmdServiceException e) {
            JLog.error(e);
            JLog.printStackTrace(e);
            nStatus = 1;
            this._nReason = this.getStatus(e, protocol);
            JLog.debug("Connection Exception\n");
        }
        this.formatResult(protocol, nStatus, this._nReason);
        return cmdsvc;
    }
}

