/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.JMiscUtil;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class JPackage {
    private String _name;
    private String _language;
    private String _version;
    private Vector _files;
    private String _masterFile;
    private Vector _mappingfiles;
    private Vector _homefiles;
    private Vector _sdffiles;
    private int _masterFileSize = 0;

    public JPackage() {
        this._files = new Vector();
        this._mappingfiles = new Vector();
        this._homefiles = new Vector();
        this._sdffiles = new Vector();
    }

    public JPackage(JPackage pkg) {
        this._name = pkg.get_name();
        this._language = pkg.get_language();
        this._version = pkg.get_version();
        this._masterFile = pkg.get_masterFile();
        this._masterFileSize = pkg.get_masterFileSize();
        if (pkg.get_files() != null) {
            this._files = new Vector();
            JMiscUtil.copyVector(this._files, pkg.get_files());
        }
        if (pkg.get_mappingfiles() != null) {
            this._mappingfiles = new Vector();
            JMiscUtil.copyVector(this._mappingfiles, pkg.get_mappingfiles());
        }
        if (pkg.get_homefiles() != null) {
            this._homefiles = new Vector();
            JMiscUtil.copyVector(this._homefiles, pkg.get_homefiles());
        }
    }

    public void addFile(String file) {
        this._files.addElement(file);
    }

    public void addHomeFile(String file) {
        this.parseAndAddHomeFiles(file);
    }

    public void addMappingFile(String file) {
        if (file == null) {
            return;
        }
        if (file.indexOf("#") == -1) {
            this._mappingfiles.addElement(file);
        } else {
            this.parseAndAddModelSpecificFiles(file);
        }
    }

    public void addSDFFile(String files) {
        String model_no = JMiscUtil.get_model().trim();
        StringTokenizer st = new StringTokenizer(files.trim(), "#");
        while (st.hasMoreTokens()) {
            String str = ((String)st.nextElement()).trim();
            String models = str.substring(0, str.indexOf("=")).trim();
            String sdf_file = str.substring(str.indexOf("=") + 1, str.length()).trim();
            StringTokenizer mdTkn = new StringTokenizer(models.trim(), ",");
            while (mdTkn.hasMoreTokens()) {
                String this_router = ((String)mdTkn.nextElement()).trim();
                if (!this_router.equalsIgnoreCase(model_no)) continue;
                this._sdffiles.addElement(sdf_file);
                return;
            }
        }
    }

    public String generateXML() {
        StringBuffer sb = new StringBuffer();
        String seperator = System.getProperty("line.separator");
        sb.append("<PACKAGE>");
        sb.append(seperator);
        sb.append("<NAME>").append(this._name).append("</NAME>");
        sb.append(seperator);
        sb.append("<VERSION>").append(this._version).append("</VERSION>");
        sb.append(seperator);
        sb.append("<LANGUAGE>").append(this._language).append("</LANGUAGE>");
        sb.append(seperator);
        sb.append("<MASTERFILE>").append(this._masterFile).append("</MASTERFILE>");
        sb.append(seperator);
        if (!(this._files.isEmpty() && this._mappingfiles.isEmpty() && this._homefiles.isEmpty())) {
            int i;
            sb.append("<FILE_LIST>");
            sb.append(seperator);
            int i2 = 0;
            while (i2 < this._files.size()) {
                sb.append("<Name>").append((String)this._files.elementAt(i2)).append("</Name>");
                sb.append(seperator);
                ++i2;
            }
            if (!this._mappingfiles.isEmpty()) {
                sb.append("<Router_Files_Mapping>");
                sb.append(seperator);
                i = 0;
                while (i < this._mappingfiles.size()) {
                    sb.append((String)this._mappingfiles.elementAt(i));
                    sb.append(seperator);
                    ++i;
                }
                sb.append("</Router_Files_Mapping>");
                sb.append(seperator);
            }
            if (!this._homefiles.isEmpty()) {
                sb.append("<Home_Files>");
                sb.append(seperator);
                i = 0;
                while (i < this._homefiles.size()) {
                    sb.append((String)this._homefiles.elementAt(i));
                    sb.append(seperator);
                    ++i;
                }
                sb.append("</Home_Files>");
                sb.append(seperator);
            }
            sb.append("</FILE_LIST>");
            sb.append(seperator);
        }
        sb.append("</PACKAGE>");
        sb.append(seperator);
        return sb.toString();
    }

    public String getFileForThisRouter(String files) {
        StringTokenizer st = new StringTokenizer(files.trim(), "#");
        while (st.hasMoreTokens()) {
            String str = ((String)st.nextElement()).trim();
            String model = str.substring(0, str.indexOf("=")).trim();
            if (!model.equalsIgnoreCase(JMiscUtil.get_model())) continue;
            return str.substring(str.indexOf("=") + 1);
        }
        return null;
    }

    public Vector getFileObjects(String localDir, Vector files) {
        Vector<File> fileObjs = new Vector<File>();
        int i = 0;
        while (i < files.size()) {
            String file = String.valueOf(localDir) + "\\" + (String)files.elementAt(i);
            File obj = new File(file);
            fileObjs.addElement(obj);
            ++i;
        }
        return fileObjs;
    }

    public Vector getFiles() {
        Vector files = new Vector();
        files = JMiscUtil.copyVector(files, this._files);
        files = JMiscUtil.copyVector(files, this._homefiles);
        files = JMiscUtil.copyVector(files, this._mappingfiles);
        files = JMiscUtil.copyVector(files, this._sdffiles);
        return files;
    }

    public Vector getFiles(String dir) {
        Vector files = new Vector();
        files = JMiscUtil.copyVector(files, this.getFileObjects(dir, this._files));
        files = JMiscUtil.copyVector(files, this.getFileObjects(dir, this._homefiles));
        files = JMiscUtil.copyVector(files, this.getFileObjects(dir, this._mappingfiles));
        files = JMiscUtil.copyVector(files, this.getFileObjects(dir, this._sdffiles));
        return files;
    }

    public Vector getSDFFiles() {
        return this._sdffiles;
    }

    public Vector get_files() {
        return this._files;
    }

    public Vector get_homefiles() {
        return this._homefiles;
    }

    public String get_language() {
        return this._language;
    }

    public Vector get_mappingfiles() {
        return this._mappingfiles;
    }

    public String get_masterFile() {
        return this._masterFile;
    }

    public int get_masterFileSize() {
        return this._masterFileSize;
    }

    public String get_name() {
        return this._name;
    }

    public String get_version() {
        return this._version;
    }

    public void parseAndAddHomeFiles(String files) {
        if (files == null || files.trim().length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(files.trim(), ":");
        while (st.hasMoreTokens()) {
            String file = st.nextToken();
            this._homefiles.addElement(file);
        }
    }

    public void parseAndAddMappedFiles(String files) {
        StringTokenizer st = new StringTokenizer(files.trim(), ":");
        while (st.hasMoreTokens()) {
            String file = st.nextToken();
            this._mappingfiles.addElement(file);
        }
    }

    public void parseAndAddModelSpecificFiles(String files) {
        if (files == null || files.trim().length() == 0) {
            return;
        }
        String fileForThisRouter = this.getFileForThisRouter(files);
        if (fileForThisRouter != null) {
            this.parseAndAddMappedFiles(fileForThisRouter);
        }
    }

    public void set_language(String language) {
        this._language = language;
    }

    public void set_masterFile(String masterFile) {
        this._masterFile = masterFile;
    }

    public void set_masterFileSize(int masterFileSize) {
        this._masterFileSize = masterFileSize;
    }

    public void set_name(String name) {
        this._name = name;
    }

    public void set_version(String version) {
        this._version = version;
    }
}

