/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.CCmdDiscover;
import com.cisco.updateengine.CommunicationExceptionAdapter;
import com.cisco.updateengine.DiscoverPriviledge;
import com.cisco.updateengine.JCommunicationEngine;
import com.cisco.updateengine.JDiscoverUtil;
import com.cisco.updateengine.JFileChangeScanner;
import com.cisco.updateengine.JLog;
import com.cisco.updateengine.JMiscUtil;
import com.cisco.updateengine.JSDMUpdateAPIWrapper;
import com.cisco.updateengine.JUpdateCommandBase;
import com.cisco.updateengine.LegacyAppCollection;
import com.cisco.updateengine.LegacyVersionXMLHandler;
import com.cisco.updateengine.LineAdjustor;
import com.cisco.updateengine.UpdateXMLHandler;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class JUpdate {
    private JFileChangeScanner _commandScanner = null;
    private IOSCmdService _cmdsvc = null;
    private String _cmdFile;
    private String _resultFile;
    private String _ipAddress;
    private JSDMUpdateAPIWrapper _APIWrapper;
    private Hashtable _installedApps;
    private Hashtable _appsOnCD;
    private LegacyAppCollection _legacyPackages;
    private String _username;
    private String _password;

    public JUpdate(String[] args) {
        JMiscUtil.setUpdateEngine(this);
        this._ipAddress = args[0];
        this._username = args[2];
        this._password = args[3];
        this._cmdFile = args[4];
        this._resultFile = args[5];
        this._APIWrapper = JSDMUpdateAPIWrapper.getInstance();
        JCommunicationEngine eng = new JCommunicationEngine();
        JLog.debug("Initial Connect");
        this._cmdsvc = eng.connect(Integer.parseInt(args[1]), args[2], args[3], args[0], this._resultFile);
        if (this._cmdsvc != null) {
            try {
                JLog.debug("Setting Large Time out");
                LineAdjustor.setLargeTimeout();
                boolean isTempUserConfigured = this.configureUsername();
                JLog.debug("Closing");
                this._cmdsvc.close();
                JLog.debug("Secondary Connect");
                this._cmdsvc = eng.connect(Integer.parseInt(args[1]), args[2], args[3], args[0], this._resultFile);
                if (this._cmdsvc != null) {
                    JLog.debug("Restoring timeout");
                }
                LineAdjustor.restoreTimeouts();
                if (isTempUserConfigured) {
                    this.restoreOneTimeUsername();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JLog.printStackTrace(e);
            }
        }
        JLog.debug("Communication is done");
        StringBuffer sb = new StringBuffer(eng.get_result());
        JLog.debug("Result is: " + sb.toString());
        if (this._cmdsvc == null) {
            JLog.debug("Going to print to file");
            JMiscUtil.printToFile(this._resultFile, sb.toString());
            System.exit(0);
            return;
        }
        try {
            this._cmdsvc.setTimeout(960000);
            this._cmdsvc.addIOSCmdServiceExpListener(new CommunicationExceptionAdapter());
        }
        catch (Exception e) {
            e.printStackTrace();
            JLog.printStackTrace(e);
        }
        DiscoverPriviledge disCmd = new DiscoverPriviledge();
        if (!disCmd.executeCommand()) {
            JLog.debug("The user does not have enough priviledge");
            sb.append(disCmd.getResult());
            JMiscUtil.printToFile(this._resultFile, sb.toString());
            System.exit(0);
            return;
        }
        CCmdDiscover cmdDis = new CCmdDiscover(this._cmdsvc);
        cmdDis.piggyBackMessage(sb.toString());
        cmdDis.executeCommand();
        this._commandScanner = new JFileChangeScanner();
        JUpdateCommandBase cmd = this._commandScanner.getNextCommand();
        while (cmd.getcommandID() != JUpdateCommandBase.CMD_EXIT) {
            this.executeCommand(cmd);
            cmd = this._commandScanner.getNextCommand();
        }
        System.exit(0);
    }

    private boolean configureUsername() {
        if (this._username.equals("cisco") && this._password.equals("cisco")) {
            String[] showCmd = new String[]{"show running-config | include username cisco"};
            boolean ciscoUserPresent = false;
            try {
                IOSCmdResponse[] replies = this._cmdsvc.exec(showCmd);
                if (JDiscoverUtil.isOKResponse(replies[0])) {
                    ciscoUserPresent = this.isUserNameCiscoPresent(replies[0].getOutput());
                }
            }
            catch (IOSCmdServiceException e) {
                e.printStackTrace();
            }
            if (!ciscoUserPresent) {
                String[] cmd = new String[]{"username cisco privilege 15 secret 0 cisco"};
                try {
                    this._cmdsvc.config(cmd);
                    return true;
                }
                catch (IOSCmdServiceException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public void executeCommand(JUpdateCommandBase cmd) {
        cmd.executeCommand();
    }

    public JSDMUpdateAPIWrapper getAPIWrapper() {
        return this._APIWrapper;
    }

    public Hashtable getAppsInstalledOnRouter() {
        return this._installedApps;
    }

    public Hashtable getAppsOnCD() {
        return this._appsOnCD;
    }

    public IOSCmdService getCmdsvc() {
        return this._cmdsvc;
    }

    public LegacyAppCollection getLegacyAppCollection() {
        return this._legacyPackages;
    }

    public String get_cmdFile() {
        return this._cmdFile;
    }

    public String get_password() {
        return this._password;
    }

    public String get_resultFile() {
        return this._resultFile;
    }

    public String get_username() {
        return this._username;
    }

    public void httpConnection_ToRouter_Refused() {
        JMiscUtil.printToFile(this._resultFile, "[Errors]\nErrorID = 102");
        System.exit(0);
    }

    private boolean isUserNameCiscoPresent(String response) {
        StringTokenizer st = new StringTokenizer(response, System.getProperty("line.separator"));
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            if (!line.startsWith("username cisco")) continue;
            return true;
        }
        return false;
    }

    public void lostConnectionWithRouter() {
        JMiscUtil.printToFile(this._resultFile, "[Errors]\nErrorID = 101");
        System.exit(0);
    }

    public static void main(String[] args) {
        JUpdate JUpdate1 = new JUpdate(args);
    }

    public void readLegacyVersionsFromXML() {
        try {
            InputStream stream = this.getClass().getResourceAsStream("LegacyVersions.xml");
            LegacyVersionXMLHandler handler = new LegacyVersionXMLHandler();
            handler.doParse(stream);
            this._legacyPackages = handler.getLegacyPackages();
        }
        catch (Exception e) {
            JLog.printStackTrace(e);
        }
    }

    public void readPackageFromXML() {
        try {
            InputStream stream = this.getClass().getResourceAsStream("SDM-Flash-Info.xml");
            UpdateXMLHandler handler = new UpdateXMLHandler();
            handler.doParse(stream);
            this._appsOnCD = handler.getPackages();
        }
        catch (Exception e) {
            JLog.printStackTrace(e);
        }
    }

    private void restoreOneTimeUsername() {
        String[] cmd = new String[]{"username cisco privilege 15 one-time secret 0 cisco"};
        try {
            this._cmdsvc.config(cmd);
        }
        catch (IOSCmdServiceException e) {
            e.printStackTrace();
        }
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void set_installedApps(Hashtable installedApps) {
        this._installedApps = installedApps;
    }

    public void set_username(String username) {
        this._username = username;
    }

    public void unsupportedRouter() {
        JMiscUtil.printToFile(this._resultFile, "[Errors]\nErrorID = 100");
        System.exit(0);
    }
}

