/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.FileCopyListener;
import com.cisco.updateengine.JLog;
import com.cisco.xdm.commonutils.StringUtils;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.util.Env;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;

public class RcpUtility {
    IOSCmdService m_comm;
    private String[] m_strArrDisableCmds;
    private String m_strLocalUser;
    private String m_strRouterUser;
    private int m_timeOut = 30000;
    private String m_strLocalAddr;
    public static final int MIN_SRC_PORT = 515;
    public static final int MAX_SRC_PORT = 1023;

    private static void checkResponse(BufferedReader inp) throws Exception {
        int code = inp.read();
        if (code == 0) {
            return;
        }
        String msg = inp.readLine();
        throw new Exception(String.valueOf(msg) + " (" + code + ")");
    }

    public boolean copyFileToRouter(File fileObj, FileCopyListener fcListener, String sdmLocation) {
        Object[] fileArray = new File[]{fileObj};
        return this.copyFileToRouter(fileArray, fcListener, sdmLocation);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean copyFileToRouter(String fileName, InputStream fileIS, FileCopyListener fcListener, String sdmLocation) {
        block20: {
            block19: {
                fileCopied = false;
                fos = null;
                cis = null;
                cos = null;
                bis = null;
                try {
                    try {
                        f = new File(fileName);
                        fos = new FileOutputStream(f);
                        inChecksum = new CRC32();
                        outChecksum = new CRC32();
                        bis = new BufferedInputStream(fileIS);
                        cis = new CheckedInputStream(bis, inChecksum);
                        cos = new CheckedOutputStream(fos, outChecksum);
                        c = 0;
                        byteBuff = new byte[8192];
                        while (true) {
                            if ((c = cis.read(byteBuff, 0, byteBuff.length)) == -1) {
                                if (inChecksum.getValue() == outChecksum.getValue()) break;
                                var10_17 = false;
                                var12_18 = null;
                                break block19;
                            }
                            cos.write(byteBuff, 0, c);
                        }
                        fileArray = new File[]{f};
                        fileCopied = this.copyFileToRouter(fileArray, fcListener, sdmLocation);
                    }
                    catch (Exception e) {
                        JLog.printStackTrace(e);
                        JLog.debug("Exception occurred at RcpUtility.copyFileToRouter(..FileInputStream...) : " + e);
                        e.printStackTrace();
                        fileCopied = false;
                    }
                    break block20;
                }
                catch (Throwable var11_22) {
                    var12_20 = null;
                    try {
                        if (cis != null) {
                            cis.close();
                        }
                        if (cos != null) {
                            cos.close();
                        }
                        if (bis != null) {
                            bis.close();
                        }
                        if (fos == null) throw var11_22;
                        fos.close();
                        throw var11_22;
                    }
                    catch (IOException ie) {
                        JLog.printStackTrace(ie);
                        ie.printStackTrace();
                    }
                    throw var11_22;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 233->276)] { 
lbl55:
            // 1 sources

            if (cis != null) {
                cis.close();
            }
            if (cos != null) {
                cos.close();
            }
            if (bis != null) {
                bis.close();
            }
            if (fos == null) return var10_17;
            fos.close();
            return var10_17;
lbl64:
            // 1 sources

            catch (IOException ie) {
                JLog.printStackTrace(ie);
                ie.printStackTrace();
            }
            return var10_17;
        }
        var12_19 = null;
        try {}
        catch (IOException ie) {
            JLog.printStackTrace(ie);
            ie.printStackTrace();
            return fileCopied;
        }
        if (cis != null) {
            cis.close();
        }
        if (cos != null) {
            cos.close();
        }
        if (bis != null) {
            bis.close();
        }
        if (fos == null) return fileCopied;
        fos.close();
        return fileCopied;
    }

    public boolean copyFileToRouter(File[] fileArray, FileCopyListener fcListener, String sdmLocation) {
        JLog.debug("fileArray.length = " + fileArray.length);
        return this.copyFileToRouter((Object[])fileArray, fcListener, sdmLocation);
    }

    public boolean copyFileToRouter(Object[] arrFilesToUpload, FileCopyListener fcListener, String sdmLocation) {
        String fileName = null;
        String strStatusMessage = null;
        String strFileSizeDenom = null;
        long iFileSize = 0L;
        boolean bChangeDir = false;
        Object respCD = null;
        String strTemp = "";
        File fTemp = null;
        try {
            if (arrFilesToUpload.length < 1) {
                throw new Exception("RcpUtility: Files to upload list error");
            }
            int i = 0;
            while (i < arrFilesToUpload.length) {
                int j = i;
                while (j < arrFilesToUpload.length) {
                    if (arrFilesToUpload[i] instanceof File && arrFilesToUpload[j] instanceof File) {
                        FileInputStream tempFIS_A = new FileInputStream((File)arrFilesToUpload[i]);
                        FileInputStream tempFIS_B = new FileInputStream((File)arrFilesToUpload[j]);
                        if (tempFIS_A.available() > tempFIS_B.available()) {
                            fTemp = (File)arrFilesToUpload[i];
                            arrFilesToUpload[i] = arrFilesToUpload[j];
                            arrFilesToUpload[j] = fTemp;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            JLog.debug("File names after sorting in ascending order of size :");
            int i2 = 0;
            while (i2 < arrFilesToUpload.length) {
                if (arrFilesToUpload[i2] instanceof File) {
                    JLog.debug(((File)arrFilesToUpload[i2]).getName());
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < arrFilesToUpload.length) {
                if (arrFilesToUpload[i3] instanceof File) {
                    fileName = ((File)arrFilesToUpload[i3]).getName();
                    FileInputStream tempFIS = new FileInputStream((File)arrFilesToUpload[i3]);
                    iFileSize = tempFIS.available();
                }
                strStatusMessage = "";
                strFileSizeDenom = "";
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(2);
                if (iFileSize <= 0L) {
                    strFileSizeDenom = "";
                } else if (iFileSize > 0L && iFileSize < 1024L) {
                    strFileSizeDenom = String.valueOf(iFileSize) + " byte(s)";
                } else if (iFileSize >= 1024L && iFileSize < 0x100000L) {
                    strFileSizeDenom = String.valueOf(nf.format((double)iFileSize / 1024.0)) + " KB";
                } else if (iFileSize >= 0x100000L && iFileSize < 0x40000000L) {
                    strFileSizeDenom = String.valueOf(nf.format((double)iFileSize / 1048576.0)) + " MB";
                }
                Socket sock = null;
                OutputStream out = null;
                BufferedReader inp = null;
                String strResp = "";
                int iBackOff = 0;
                while (iBackOff <= this.m_timeOut) {
                    sock = RcpUtility.createSocket(this.m_comm.getIPAddress(), 514, this.m_strLocalAddr);
                    out = sock.getOutputStream();
                    inp = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                    try {
                        RcpUtility.send(out, "\u0000");
                        RcpUtility.send(out, String.valueOf(this.m_strLocalUser) + "\u0000");
                        RcpUtility.send(out, String.valueOf(this.m_strRouterUser) + "\u0000");
                        JLog.debug("local user = " + this.m_strLocalUser);
                        JLog.debug("router user = " + this.m_strRouterUser);
                        RcpUtility.send(out, "rcp -t " + sdmLocation + ":/" + fileName + "\u0000");
                        RcpUtility.checkResponse(inp);
                        JLog.debug("File transfer going to take place");
                        RcpUtility.send(out, "C0666 " + iFileSize + " " + fileName + "\n");
                        JLog.debug("C0666 " + iFileSize + " " + fileName + "\n");
                        RcpUtility.checkResponse(inp);
                        break;
                    }
                    catch (Exception e) {
                        JLog.printStackTrace(e);
                        JLog.debug("RcpUtility; Exception occured after sending file information : " + e);
                        inp.close();
                        out.flush();
                        out.close();
                        sock.close();
                        iBackOff += 5000;
                        try {
                            Thread.sleep(iBackOff);
                        }
                        catch (InterruptedException ie) {
                            JLog.printStackTrace(ie);
                            JLog.debug("Normal Thread Interruption in RcpUtility.copyFileToRouter");
                        }
                    }
                }
                if (iBackOff == this.m_timeOut + 5000) {
                    inp.close();
                    out.close();
                    sock.close();
                    throw new Exception("RcpUtility: RCP socket failure");
                }
                JLog.debug("RcpUtility: copyFileToRouter about to send file bytes");
                BufferedInputStream bis = null;
                InputStream zipEntryIS = null;
                FileInputStream fileIS = null;
                if (arrFilesToUpload[i3] instanceof File) {
                    JLog.debug("RcpUtility.copyFileToRouter(): About to create FileInputStream for file");
                    fileIS = new FileInputStream((File)arrFilesToUpload[i3]);
                    JLog.debug("RcpUtility.copyFileToRouter(): Created FileInputStream for file");
                    bis = new BufferedInputStream(fileIS);
                }
                int c = 0;
                int count = 0;
                int percent = 0;
                byte[] byteBuff = new byte[8192];
                while ((c = bis.read(byteBuff, 0, byteBuff.length)) != -1) {
                    this.send(out, byteBuff, 0, c);
                    if (fcListener == null) continue;
                    percent = (int)((long)(100 * (count += c)) / iFileSize);
                    strStatusMessage = String.valueOf(percent) + Env.getString((int)40646) + strFileSizeDenom;
                    if (count % 81920 != 0 && percent != 100) continue;
                    fcListener.activateProgressBar(percent, fileName, strStatusMessage);
                }
                RcpUtility.send(out, "\u0000");
                RcpUtility.checkResponse(inp);
                if (zipEntryIS != null) {
                    zipEntryIS.close();
                }
                if (fileIS != null) {
                    ((InputStream)fileIS).close();
                }
                bis.close();
                inp.close();
                out.flush();
                out.close();
                sock.close();
                ++i3;
            }
        }
        catch (Exception ex) {
            JLog.printStackTrace(ex);
            try {
                this.disableRcp();
            }
            catch (Exception e) {
                JLog.printStackTrace(e);
                JLog.debug("RcpUtility.copyFileToRouter(): nested Exception occured while trying to disable RCP");
            }
            JLog.error("RcpUtility.copyFileToRouter(): Error during file upload through RCP : " + ex);
            return false;
        }
        return true;
    }

    public static Socket createSocket(String host, int port, String localHost) throws IOException {
        Socket soc = null;
        int localPort = 1023;
        while (localPort >= 515) {
            try {
                soc = new Socket(InetAddress.getByName(host), port, InetAddress.getByName(localHost), localPort);
                break;
            }
            catch (SocketException e) {
                JLog.printStackTrace(e);
                --localPort;
            }
        }
        return soc;
    }

    public void disableRcp() throws Exception {
        if (this.m_strArrDisableCmds != null && this.m_strArrDisableCmds.length > 0) {
            this.m_comm.config(this.m_strArrDisableCmds);
            this.m_strArrDisableCmds = null;
        }
    }

    public void enableRcp(IOSCmdService comm, String strLocalAddr) throws Exception {
        boolean rcpAlreadyEnabled = false;
        boolean rcpDomainLookupDisabled = false;
        Random r = null;
        String strRouterUser = null;
        String strLocalUser = null;
        this.m_comm = comm;
        r = new Random(System.currentTimeMillis());
        this.m_strRouterUser = strRouterUser = "sdmR" + Integer.toHexString(r.nextInt());
        this.m_strLocalAddr = strLocalAddr;
        r = new Random(System.currentTimeMillis());
        this.m_strLocalUser = strLocalUser = "L" + Integer.toHexString(r.nextInt());
        JLog.debug("RcpUtility.enableRcp()Checking for RCP enabled commands");
        IOSCmdResponse[] rsps = comm.exec(new String[]{"sh run | include ip rcmd"});
        JLog.debug("RcpUtility.enableRcp() IOSCmdResponse[] obtained and rsps[0] = " + rsps[0].getOutput());
        Vector<String> orgCmdVec = new Vector<String>();
        if (rsps != null && rsps[0] != null) {
            StringTokenizer st = new StringTokenizer(rsps[0].getOutput(), "\n");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.startsWith("ip rcmd")) {
                    if (s.indexOf("rcp-enable") > -1) {
                        rcpAlreadyEnabled = true;
                    }
                    orgCmdVec.addElement(s);
                    continue;
                }
                if (!s.equals("no ip rcmd domain-lookup")) continue;
                rcpDomainLookupDisabled = true;
                orgCmdVec.addElement(s);
            }
        }
        Vector<String> enableCmdVec = new Vector<String>();
        if (!rcpAlreadyEnabled) {
            enableCmdVec.addElement("ip rcmd rcp-enable");
        }
        enableCmdVec.addElement("ip rcmd remote-host " + strRouterUser + " " + strLocalAddr + " " + strLocalUser + " enable");
        enableCmdVec.addElement("ip rcmd remote-username " + strRouterUser);
        if (!rcpDomainLookupDisabled) {
            enableCmdVec.addElement("no ip rcmd domain-lookup");
        }
        Vector<String> disableCmdVec = new Vector<String>();
        Enumeration e = enableCmdVec.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (s.startsWith("no ")) {
                disableCmdVec.addElement(s.substring(3));
                continue;
            }
            disableCmdVec.addElement("no " + s);
        }
        Enumeration e2 = orgCmdVec.elements();
        while (e2.hasMoreElements()) {
            disableCmdVec.addElement((String)e2.nextElement());
        }
        this.m_strArrDisableCmds = this.getStrs(disableCmdVec);
        comm.config(this.getStrs(enableCmdVec));
    }

    public int getMaxTimeOut() {
        return this.m_timeOut;
    }

    private String[] getStrs(Vector vec) {
        Object[] res = new String[vec.size()];
        vec.copyInto(res);
        return res;
    }

    private static void send(OutputStream out, String data) throws IOException {
        JLog.debug("RcpUtility.send " + StringUtils.quoted(data));
        out.write(data.getBytes());
        out.flush();
    }

    private void send(OutputStream out, byte[] buff, int offset, int length) throws IOException {
        out.write(buff, offset, length);
        out.flush();
    }

    public void setTimeOut(int timeOut) {
        this.m_timeOut = timeOut;
    }
}

