/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.commonutils;

import com.cisco.xdm.commonutils.LogEvent;
import com.cisco.xdm.commonutils.LogListener;
import java.util.Enumeration;
import java.util.Vector;

public class Log {
    public static final String SEV_EMERGENCY_STR = "EMERGENCY";
    public static final String SEV_ALERT_STR = "ALERT";
    public static final String SEV_CRITICAL_STR = "CRITICAL";
    public static final String SEV_ERROR_STR = "ERROR";
    public static final String SEV_WARNING_STR = "WARNING";
    public static final String SEV_NOTICE_STR = "NOTICE";
    public static final String SEV_INFO_STR = "INFO";
    public static final String SEV_DEBUG_STR = "DEBUG";
    public static final int SEV_EMERGENCY = 0;
    public static final int SEV_ALERT = 1;
    public static final int SEV_CRITICAL = 2;
    public static final int SEV_ERROR = 3;
    public static final int SEV_WARNING = 4;
    public static final int SEV_NOTICE = 5;
    public static final int SEV_INFO = 6;
    public static final int SEV_DEBUG = 7;
    static final int DEFAULT_EVENTS_MAX = 1000;
    static final int DEFAULT_EVENTS_MIN = 10;
    static final String DEFAULT_LOG = "default";
    protected static Log _instance;
    static boolean _is_console_write_enabled;
    String _name = null;
    Vector _listeners = null;
    Vector _events = new Vector();
    int _max_events = 1000;

    static {
        _is_console_write_enabled = true;
    }

    public Log() {
        this("Log");
    }

    public Log(String name) {
        this._name = name;
    }

    public LogEvent addEvent(int severity, String message, Throwable t) {
        LogEvent e = new LogEvent(severity, message, t);
        if (_is_console_write_enabled) {
            System.out.print(e.toString());
        }
        this._events.addElement(e);
        this.trimLog();
        this.fireLogUpdated(this, e);
        return e;
    }

    public void addLogListener(LogListener l) {
        if (this._listeners == null) {
            this._listeners = new Vector();
        }
        this._listeners.addElement(l);
    }

    public void clear() {
        this._events.removeAllElements();
    }

    public Vector copyEvents() {
        return (Vector)this._events.clone();
    }

    public LogEvent debug(String message) {
        return this.addEvent(7, message, null);
    }

    public LogEvent debug(String message, Throwable t) {
        return this.addEvent(7, message, t);
    }

    public LogEvent error(String message) {
        return this.addEvent(3, message, null);
    }

    public LogEvent error(String message, Throwable t) {
        return this.addEvent(3, message, t);
    }

    public void fireLogUpdated(Log log, LogEvent le) {
        if (this._listeners == null || this._listeners.size() <= 0) {
            return;
        }
        Enumeration e = this._listeners.elements();
        while (e.hasMoreElements()) {
            LogListener l = (LogListener)e.nextElement();
            try {
                l.logUpdated(log, le);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public Enumeration getEvents() {
        return this._events.elements();
    }

    public static Log getInstance() {
        if (_instance == null) {
            _instance = new Log();
        }
        return _instance;
    }

    public static Log getLog() {
        return Log.getInstance();
    }

    public String getName() {
        return this._name;
    }

    public static String getSeverity(int severity) {
        String sev = null;
        switch (severity) {
            case 0: {
                sev = SEV_EMERGENCY_STR;
                break;
            }
            case 1: {
                sev = SEV_ALERT_STR;
                break;
            }
            case 2: {
                sev = SEV_CRITICAL_STR;
                break;
            }
            case 3: {
                sev = SEV_ERROR_STR;
                break;
            }
            case 4: {
                sev = SEV_WARNING_STR;
                break;
            }
            case 5: {
                sev = SEV_NOTICE_STR;
                break;
            }
            case 6: {
                sev = SEV_INFO_STR;
                break;
            }
            case 7: {
                sev = SEV_DEBUG_STR;
                break;
            }
            default: {
                sev = SEV_DEBUG_STR;
            }
        }
        return sev;
    }

    public static int getSeverity(String s) {
        int sev = 0;
        String x = s.trim().toUpperCase();
        if (x.equals(SEV_EMERGENCY_STR)) {
            sev = 0;
        } else if (x.equals(SEV_ALERT_STR)) {
            sev = 1;
        } else if (x.equals(SEV_CRITICAL_STR)) {
            sev = 2;
        } else if (x.equals(SEV_ERROR_STR)) {
            sev = 3;
        } else if (x.equals(SEV_WARNING_STR)) {
            sev = 4;
        } else if (x.equals(SEV_NOTICE_STR)) {
            sev = 5;
        } else if (x.equals(SEV_INFO_STR)) {
            sev = 6;
        } else if (x.equals(SEV_DEBUG_STR)) {
            sev = 7;
        }
        return sev;
    }

    public LogEvent info(String message) {
        return this.addEvent(6, message, null);
    }

    public LogEvent info(String message, Throwable t) {
        return this.addEvent(6, message, t);
    }

    public static boolean isConsoleWriteEnabled() {
        return _is_console_write_enabled;
    }

    public void removeLogListener(LogListener l) {
        if (this._listeners != null && this._listeners.size() > 0) {
            this._listeners.removeElement(l);
        }
    }

    public static void setConsoleWriteEnabled(boolean enable) {
        _is_console_write_enabled = enable;
    }

    public void setMaxEvents(int count) {
        if (count < 10) {
            throw new IllegalArgumentException("Count must be >= 10");
        }
        this._max_events = count;
        this.trimLog();
    }

    public void trimLog() {
        int trim_count;
        if (this._events.size() <= this._max_events) {
            return;
        }
        int ii = trim_count = this._events.size() - (int)((double)this._max_events * 0.9);
        while (ii > 0) {
            this._events.removeElementAt(0);
            --ii;
        }
        this.info("Log: trimmed " + trim_count + " events");
    }

    public LogEvent warn(String message) {
        return this.addEvent(4, message, null);
    }

    public LogEvent warn(String message, Throwable t) {
        return this.addEvent(4, message, t);
    }
}

