/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.commonutils;

import com.cisco.xdm.commonutils.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogEvent {
    static final String DATE_FORMAT = "yyyy.MM.dd-hh:mm:ss-z";
    static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy.MM.dd-hh:mm:ss-z");
    int _severity = 0;
    long _timestamp = System.currentTimeMillis();
    String _message = null;
    String _stack = null;
    Throwable _throwable = null;

    public LogEvent(int severity, String message) {
        this(severity, message, null);
    }

    public LogEvent(int severity, String message, Throwable t) {
        this._severity = severity;
        this._message = message;
        this._throwable = t;
        if (t != null) {
            this._stack = LogEvent.stackTrace(t);
        }
    }

    public String getMessage() {
        return this._message;
    }

    public int getSeverity() {
        return this._severity;
    }

    public String getStack() {
        return this._stack;
    }

    public Throwable getThrowable() {
        return this._throwable;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public boolean isRepeat(LogEvent e) {
        return this._severity == e._severity && (this._message == e._message || this._message.equals(e._message));
    }

    protected static String stackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(SDF.format(new Date(this._timestamp)));
        s.append(" ");
        s.append(Log.getSeverity(this._severity));
        if (this._message != null) {
            s.append(" ");
            s.append(this._message);
        }
        if (this._throwable != null) {
            s.append(": ");
            s.append(this._throwable.toString());
        }
        if (this._stack != null) {
            s.append(this._stack);
        }
        s.append("\n");
        return s.toString();
    }
}

