/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.commonutils;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.FilterIf;
import com.cisco.xdm.commonutils.FilterFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ParserUtils {
    private static final int FIRSTVAL = 0;

    public static CmdValues createCLICommand(String cmdName, String[] keywords, int cmdType, Hashtable newValues, Hashtable oldValues) {
        int count;
        if (cmdName == null || keywords == null) {
            return null;
        }
        CmdValues cmdVal = new CmdValues(cmdName);
        if (keywords != null) {
            count = 0;
            while (count < keywords.length) {
                cmdVal.addValue(keywords[count], keywords[count]);
                ++count;
            }
        }
        cmdVal.setAction(cmdType);
        if (newValues != null) {
            ParserUtils.populateValues(cmdVal, newValues, true);
        }
        if (oldValues != null) {
            count = 0;
            while (count < keywords.length) {
                cmdVal.addOldValue(keywords[count], keywords[count]);
                ++count;
            }
            ParserUtils.populateValues(cmdVal, oldValues, false);
        }
        return cmdVal;
    }

    public static void generateSubModeCli(String command, String alias, String value, ConfigValues subcfg) {
        CmdValues cmdVal = new CmdValues(command);
        cmdVal.addValue(alias, value);
        cmdVal.setAction(1);
        subcfg.addCmdValues(cmdVal);
    }

    public static void generateSubModeCli(String command, Hashtable valuesTable, ConfigValues subcfg, int action) {
        CmdValues cmdVal = new CmdValues(command);
        Enumeration keys = valuesTable.keys();
        String key = null;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            cmdVal.addValue(key, (String)valuesTable.get(key));
        }
        cmdVal.setAction(action);
        subcfg.addCmdValues(cmdVal);
    }

    public static String getCommandValue(ConfigValues cfgVal, String subcommandName, String keywordAlias) {
        FilterIf subcommandFilter = FilterFactory.getCommandFilter(subcommandName);
        ConfigValues configValue = cfgVal.getCmds(subcommandFilter);
        if (configValue != null) {
            return ParserUtils.getKeyWordValue(configValue, keywordAlias);
        }
        return null;
    }

    public static String[] getCommandValue(ConfigValues cfgVal, String subcommandName, String[] keywordList, String keywordAlias) {
        Vector<String> subCommandVals = new Vector<String>();
        FilterIf subcommandFilter = FilterFactory.getKeywordFilter(subcommandName, keywordList);
        CmdValues subCommandEntry = null;
        ConfigValues configValue = cfgVal.getCmds(subcommandFilter);
        if (configValue == null) {
            return null;
        }
        int count = 0;
        while (count < configValue.numCmds()) {
            subCommandEntry = configValue.getCmdValues(count);
            if (subCommandEntry != null) {
                subCommandVals.addElement(subCommandEntry.getValue(keywordAlias));
            }
            ++count;
        }
        if (subCommandVals.size() != 0) {
            Object[] retVal = new String[subCommandVals.size()];
            subCommandVals.copyInto(retVal);
            subCommandVals = null;
            return retVal;
        }
        return null;
    }

    public static String getKeyWordValue(ConfigValues configValues, String keywordName) {
        if (configValues == null || keywordName == null) {
            return null;
        }
        CmdValues cmdval = configValues.getCmdValues(0);
        return cmdval.getValue(keywordName);
    }

    public static String getSubCommandValue(CmdValues cmdVal, String subcommandName, String keywordAlias) {
        if (cmdVal.getModeCmdsValues() != null) {
            ConfigValues subcommands = cmdVal.getModeCmdsValues();
            return ParserUtils.getCommandValue(subcommands, subcommandName, keywordAlias);
        }
        return null;
    }

    public static String[] getSubCommandValue(CmdValues cmdVal, String subcommandName, String[] keywordList, String keywordAlias) {
        if (cmdVal == null || subcommandName == null) {
            return null;
        }
        if (cmdVal.getModeCmdsValues() != null) {
            ConfigValues subcommands = cmdVal.getModeCmdsValues();
            return ParserUtils.getCommandValue(subcommands, subcommandName, keywordList, keywordAlias);
        }
        return null;
    }

    private static void populateValues(CmdValues cmdVal, Hashtable valuesTable, boolean areValuesNew) {
        Enumeration keys = valuesTable.keys();
        String key = null;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            if (areValuesNew) {
                cmdVal.addValue(key, (String)valuesTable.get(key));
                continue;
            }
            cmdVal.addOldValue(key, (String)valuesTable.get(key));
        }
    }
}

