/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.common.PortMap;
import com.cisco.xdm.data.common.PortMapEntry;

final class ACEPort
implements Cloneable {
    private int _port = -1;
    private int _upperPort = -1;
    private String _operator = "";
    private int _portType = 0;
    public static final int UDP_PORT = 0;
    public static final int TCP_PORT = 1;

    ACEPort() {
    }

    public void clear() {
        this._port = -1;
        this._upperPort = -1;
        this._operator = "";
    }

    public Object clone() {
        ACEPort newObj = null;
        try {
            newObj = (ACEPort)super.clone();
        }
        catch (Exception e) {
            Log.getLog().error("Exception in ACEPort.clone", e);
            return null;
        }
        return newObj;
    }

    public int compare(ACEPort acePort) {
        if (!this.isRange() && !acePort.isRange()) {
            if (this.equals(acePort)) {
                return 0;
            }
            return 2;
        }
        if (this.isRange()) {
            if (acePort.isRange()) {
                if (this._port <= acePort._port && this._upperPort >= acePort._upperPort) {
                    return 0;
                }
                if (this._port > acePort._upperPort || this._upperPort < acePort._port) {
                    return 2;
                }
                return 3;
            }
            if (this._port <= acePort._port && this._upperPort >= acePort._port) {
                return 0;
            }
            return 2;
        }
        if (acePort._port <= this._port && acePort._upperPort >= this._port) {
            return 3;
        }
        return 2;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ACEPort acePort = (ACEPort)obj;
            return this._port == acePort._port && this._operator.equals(acePort._operator) && this._upperPort == acePort._upperPort;
        }
        return false;
    }

    public String getPort() {
        if (this.isEmpty()) {
            return "";
        }
        String port = PortMap.findKeyByValue(this._port, this.getPortMap());
        if (port != null && (this._portType != 0 ? PortMap.isTcpPortSupported(port) : PortMap.isUdpPortSupported(port))) {
            return port;
        }
        return String.valueOf(this._port);
    }

    private PortMapEntry[] getPortMap() {
        if (this._portType == 0) {
            return PortMap.udpPortTable;
        }
        return PortMap.tcpPortTable;
    }

    public String getPortOperator() {
        return this._operator;
    }

    public String getUpperPort() {
        if (this.isEmpty()) {
            return "";
        }
        String port = PortMap.findKeyByValue(this._upperPort, this.getPortMap());
        if (port != null && (this._portType != 0 ? PortMap.isTcpPortSupported(port) : PortMap.isUdpPortSupported(port))) {
            return port;
        }
        return String.valueOf(this._upperPort);
    }

    public boolean isEmpty() {
        return this._port == -1;
    }

    public boolean isRange() {
        return this._operator.equals("range");
    }

    public boolean setPort(String port, String operator) {
        int portNum = -1;
        try {
            portNum = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            Log.getLog().debug("Not a port number checking for udp port name");
            portNum = PortMap.findValueByKey(port, this.getPortMap());
        }
        if (portNum == -1) {
            Log.getLog().debug("Port name is not a valid port");
            return false;
        }
        if (portNum < 0 && portNum > 65535) {
            Log.getLog().debug("Port number is out of range");
            return false;
        }
        this._port = portNum;
        this._operator = operator;
        return true;
    }

    public void setPortType(int type) {
        this._portType = type;
    }

    public boolean setRange(String lower, String upper) {
        int lowerPortNum = -1;
        try {
            lowerPortNum = Integer.parseInt(lower);
        }
        catch (NumberFormatException numberFormatException) {
            Log.getLog().debug("Not a port number checking for udp port name");
            lowerPortNum = PortMap.findValueByKey(lower, this.getPortMap());
        }
        if (lowerPortNum == -1) {
            Log.getLog().debug("Port name is not a standard port name");
            return false;
        }
        if (lowerPortNum < 0 && lowerPortNum > 65535) {
            Log.getLog().debug("Port number is out of range");
            return false;
        }
        int upperPortNum = -1;
        try {
            upperPortNum = Integer.parseInt(upper);
        }
        catch (NumberFormatException numberFormatException) {
            Log.getLog().debug("Not a port number checking for udp port name");
            upperPortNum = PortMap.findValueByKey(upper, this.getPortMap());
        }
        if (upperPortNum == -1) {
            Log.getLog().debug("Port name is not a standard port name ");
            return false;
        }
        if (upperPortNum < 0 && upperPortNum > 65535) {
            Log.getLog().debug("Port number is out of range");
            return false;
        }
        this._port = lowerPortNum;
        this._upperPort = upperPortNum;
        this._operator = this._upperPort == this._port ? "eq" : "range";
        return true;
    }

    public boolean setUpperPort(String port) {
        int portNum = -1;
        try {
            portNum = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            Log.getLog().debug("Not a port number checking for udp port name");
            portNum = PortMap.findValueByKey(port, this.getPortMap());
        }
        if (portNum == -1) {
            Log.getLog().debug("Port name is not a valid port");
            return false;
        }
        if (portNum < 0 && portNum > 65535) {
            Log.getLog().debug("Port number is out of range");
            return false;
        }
        this._upperPort = portNum;
        this._operator = this._upperPort == this._port ? "eq" : "range";
        return true;
    }

    public String toCLI() {
        if (this._port == -1) {
            return "";
        }
        StringBuffer tempString = new StringBuffer(this._operator);
        tempString.append(" ").append(this.getPort());
        if (this._operator.equals("range")) {
            tempString.append(" ").append(this.getUpperPort());
        }
        return tempString.toString();
    }

    public String toFormatedString() {
        if (this._port == -1) {
            return "";
        }
        StringBuffer tempString = new StringBuffer();
        if (!this._operator.equals("eq") && !this._operator.equals("range")) {
            tempString.append(this._operator).append(" ");
        }
        if (this._operator.equals("range")) {
            tempString.append(" (").append(this.getPort()).append("-").append(this.getUpperPort()).append(")");
        } else {
            tempString.append(this.getPort());
        }
        return tempString.toString();
    }
}

