/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACEProtocols;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.DynamicACE;
import com.cisco.xdm.data.acl.EvaluateACE;
import com.cisco.xdm.data.acl.ExtIcmpACE;
import com.cisco.xdm.data.acl.ExtIgmpACE;
import com.cisco.xdm.data.acl.ExtTcpACE;
import com.cisco.xdm.data.acl.ExtUdpACE;
import com.cisco.xdm.data.acl.ExtendedACE;
import com.cisco.xdm.data.acl.StandardACE;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import java.util.Enumeration;
import java.util.Vector;

public class ACL
extends ACLBase
implements Cloneable {
    public ACL(int aclType) {
        super(aclType, false);
    }

    public boolean addACE(ACEInterface ace) {
        if (this.getACLType() == 0 && ace.getACEType() != 0 || this.getACLType() == 1 && ace.getACEType() == 0) {
            Log.getLog().error("ACE passed iS of different type");
            return false;
        }
        this._aces.addElement((XDMObject)((Object)ace));
        ((XDMObject)((Object)ace)).setParent(this);
        this.setModified();
        return true;
    }

    public boolean addACE(ACEInterface ace, int index) {
        if (this.getACLType() == 0 && ace.getACEType() != 0 || this.getACLType() == 1 && ace.getACEType() == 0) {
            Log.getLog().error("ACE passed iS of different type");
            return false;
        }
        this._aces.insertElementAt((XDMObject)((Object)ace), index);
        ((XDMObject)((Object)ace)).setParent(this);
        this.setModified();
        return true;
    }

    public int basicVerify() {
        boolean permit = false;
        int i = 0;
        while (i < this._aces.size() - 1) {
            StandardACE ace = (StandardACE)this._aces.elementAt(i);
            if (ace.isSourceAny()) {
                if (this._iACLType == 1) {
                    if (((ExtendedACE)ace).isDestAny() && ((ExtendedACE)ace).getProtocol().equals("ip")) {
                        return 105;
                    }
                } else {
                    return 105;
                }
            }
            if (((StandardACE)this._aces.elementAt(i)).getGrant()) {
                permit = true;
            }
            ++i;
        }
        if (((StandardACE)this._aces.elementAt(this._aces.size() - 1)).getGrant()) {
            permit = true;
        }
        if (!permit) {
            return 106;
        }
        return 107;
    }

    protected ACEInterface buildACE(CmdValues cmd) {
        if (this._iACLType == 0) {
            return new StandardACE();
        }
        if (cmd.getCmdName().equals("evaluate")) {
            Log.getLog().debug("Reflexive ACL");
            return new EvaluateACE();
        }
        if (cmd.getCmdName().equals("dynamic")) {
            Log.getLog().debug("Dynamic ACL");
            return new DynamicACE();
        }
        if (cmd.getValue("dynamic") != null) {
            Log.getLog().debug("Dynamic ACL");
            return new DynamicACE();
        }
        String protocol = cmd.getValue("ACLProtocol");
        if (protocol == null) {
            protocol = cmd.getValue("ACLProtocolNum");
            Log.getLog().debug("Protocol : " + protocol);
            if (protocol == null) {
                Log.getLog().error("CMD Value does not have a Protocol field");
                return null;
            }
            return new ExtendedACE();
        }
        Log.getLog().debug("Protocol : " + protocol);
        if (ACEProtocols.isIpProtocolName(protocol)) {
            return new ExtendedACE();
        }
        if (protocol.equals("udp")) {
            return new ExtUdpACE();
        }
        if (protocol.equals("tcp")) {
            return new ExtTcpACE();
        }
        if (protocol.equals("icmp")) {
            return new ExtIcmpACE();
        }
        if (protocol.equals("igmp")) {
            return new ExtIgmpACE();
        }
        return null;
    }

    public boolean canInsertAt(ACEInterface ace, int loc) {
        Enumeration conflictingACEs = this.getConflictingACEs(ace, loc);
        return conflictingACEs.hasMoreElements() ^ true;
    }

    public Object clone() {
        ACL newObj = (ACL)super.clone();
        return newObj;
    }

    public boolean compare(ACLBase oACL) {
        if (this._iACLType != oACL._iACLType) {
            return false;
        }
        Enumeration comparedACEs = oACL.getACEs();
        while (comparedACEs.hasMoreElements()) {
            ACEInterface comparedACE = (ACEInterface)comparedACEs.nextElement();
            Enumeration aces = this._aces.elements();
            boolean foundEquivelent = false;
            while (aces.hasMoreElements()) {
                int compResults = ((ACEInterface)aces.nextElement()).compare(comparedACE);
                if (compResults == 0) {
                    foundEquivelent = true;
                    break;
                }
                if (compResults == 1 || compResults == 6) {
                    return false;
                }
                if (compResults != 2 && compResults != 3) continue;
            }
            if (foundEquivelent) continue;
            return false;
        }
        return true;
    }

    protected void generateAddNameACL(ConfigValues values) throws XDMException {
        CmdValues remark;
        CmdValues acl = new CmdValues("ip");
        acl.addValue("ACLName", this.getNameOrNumber());
        if (this._iACLType == 0) {
            acl.addValue("standard", "standard");
        } else {
            acl.addValue("extended", "extended");
        }
        acl.addValue("access-list", "access-list");
        ConfigValues subValues = new ConfigValues();
        acl.setModeCmdsValues(subValues);
        if (this._strRemark != null && this._strRemark.length() != 0) {
            remark = new CmdValues("remark");
            remark.addValue("Remark", this._strRemark);
            subValues.addCmdValues(remark);
        }
        remark = new CmdValues("remark");
        remark.addValue("Remark", "SDM_ACL Category=" + String.valueOf(this._categories));
        subValues.addCmdValues(remark);
        Enumeration aces = this.getACEs();
        int aceCount = 0;
        while (aces.hasMoreElements()) {
            ((StandardACE)aces.nextElement()).generateDelta(null, subValues);
            if (++aceCount != 65 || !aces.hasMoreElements()) continue;
            values.addCmdValues(acl);
            acl = new CmdValues("ip");
            acl.addValue("ACLName", this.getNameOrNumber());
            if (this._iACLType == 0) {
                acl.addValue("standard", "standard");
            } else {
                acl.addValue("extended", "extended");
            }
            acl.addValue("access-list", "access-list");
            subValues = new ConfigValues();
            acl.setModeCmdsValues(subValues);
            aceCount = 0;
        }
        values.addCmdValues(acl);
    }

    protected void generateAddNumACL(ConfigValues values) throws XDMException {
        CmdValues remark;
        if (this._strRemark != null && this._strRemark.length() != 0) {
            remark = new CmdValues("access-list");
            remark.addValue("ACLNumber", this.getNameOrNumber());
            remark.addValue("remark", "remark");
            remark.addValue("Remark", this._strRemark);
            values.addCmdValues(remark);
        }
        remark = new CmdValues("access-list");
        remark.addValue("ACLNumber", this.getNameOrNumber());
        remark.addValue("remark", "remark");
        remark.addValue("Remark", "SDM_ACL Category=" + String.valueOf(this._categories));
        values.addCmdValues(remark);
        Enumeration aces = this.getACEs();
        while (aces.hasMoreElements()) {
            ((StandardACE)aces.nextElement()).generateDelta(null, values);
        }
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        if (backup != null && !(backup instanceof ACL)) {
            Log.getLog().error("ACL.generateDelta Passed backup object is not a ACL object");
            throw new XDMException(102);
        }
        if (!this._bNameOrNumber) {
            this.generateDeltaforNumberedACL(backup, values);
        } else {
            this.generateDeltaforNamedACL(backup, values);
        }
    }

    protected void generateDeltaforNamedACL(XDMObject backup, ConfigValues values) throws XDMException {
        if (backup == null && this.isBackup()) {
            CmdValues deleteCmd = new CmdValues("ip");
            deleteCmd.addValue("ACLName", this.getNameOrNumber());
            if (this._iACLType == 0) {
                deleteCmd.addValue("standard", "standard");
            } else {
                deleteCmd.addValue("extended", "extended");
            }
            deleteCmd.addValue("access-list", "access-list");
            deleteCmd.setAction(2);
            values.addCmdValues(deleteCmd);
            return;
        }
        if (backup == null && !this.isBackup()) {
            this.generateAddNameACL(values);
            return;
        }
        boolean bChanged = false;
        ACL backupACL = (ACL)backup;
        if (!this._strRemark.equals(backupACL._strRemark)) {
            bChanged = true;
        } else if (this._categories != backupACL._categories) {
            bChanged = true;
        } else if (this.getNumberofACEs() >= backupACL.getNumberofACEs()) {
            Enumeration aces = this.getACEs();
            Enumeration backupAces = backupACL.getACEs();
            while (backupAces.hasMoreElements()) {
                if (aces.nextElement().equals(backupAces.nextElement())) continue;
                bChanged = true;
                break;
            }
            if (!bChanged && aces.hasMoreElements()) {
                CmdValues acl = new CmdValues("ip");
                acl.addValue("ACLName", this.getNameOrNumber());
                acl.addValue("access-list", "access-list");
                if (this._iACLType == 0) {
                    acl.addValue("standard", "standard");
                } else {
                    acl.addValue("extended", "extended");
                }
                ConfigValues subValues = new ConfigValues();
                acl.setModeCmdsValues(subValues);
                int aceCount = 0;
                while (aces.hasMoreElements()) {
                    ((StandardACE)aces.nextElement()).generateDelta(null, subValues);
                    if (++aceCount != 65 || !aces.hasMoreElements()) continue;
                    values.addCmdValues(acl);
                    acl = new CmdValues("ip");
                    acl.addValue("ACLName", this.getNameOrNumber());
                    if (this._iACLType == 0) {
                        acl.addValue("standard", "standard");
                    } else {
                        acl.addValue("extended", "extended");
                    }
                    acl.addValue("access-list", "access-list");
                    subValues = new ConfigValues();
                    acl.setModeCmdsValues(subValues);
                    aceCount = 0;
                }
                values.addCmdValues(acl);
            } else if (!bChanged) {
                return;
            }
        } else {
            bChanged = true;
        }
        if (bChanged) {
            CmdValues deleteCmd = new CmdValues("ip");
            deleteCmd.addValue("ACLName", this.getNameOrNumber());
            if (backupACL._iACLType == 0) {
                deleteCmd.addValue("standard", "standard");
            } else {
                deleteCmd.addValue("extended", "extended");
            }
            deleteCmd.addValue("access-list", "access-list");
            deleteCmd.setAction(2);
            values.addCmdValues(deleteCmd);
            this.generateAddNameACL(values);
        }
    }

    protected void generateDeltaforNumberedACL(XDMObject backup, ConfigValues values) throws XDMException {
        if (backup == null && this.isBackup()) {
            CmdValues deleteCMD = new CmdValues("access-list");
            deleteCMD.addValue("ACLNumber", this.getNameOrNumber());
            deleteCMD.setAction(2);
            values.addCmdValues(deleteCMD);
            return;
        }
        if (backup == null && !this.isBackup()) {
            this.generateAddNumACL(values);
            return;
        }
        boolean bChanged = false;
        ACL backupACL = (ACL)backup;
        if (!this._strRemark.equals(backupACL._strRemark)) {
            bChanged = true;
        } else if (this._categories != backupACL._categories) {
            bChanged = true;
        } else if (this.getNumberofACEs() >= backupACL.getNumberofACEs()) {
            Enumeration aces = this.getACEs();
            Enumeration backupAces = backupACL.getACEs();
            while (backupAces.hasMoreElements()) {
                if (aces.nextElement().equals(backupAces.nextElement())) continue;
                bChanged = true;
                break;
            }
            if (!bChanged && aces.hasMoreElements()) {
                while (aces.hasMoreElements()) {
                    ((StandardACE)aces.nextElement()).generateDelta(null, values);
                }
            } else if (!bChanged) {
                return;
            }
        } else {
            bChanged = true;
        }
        if (bChanged) {
            CmdValues deleteCMD = new CmdValues("access-list");
            deleteCMD.addValue("ACLNumber", this.getNameOrNumber());
            deleteCMD.setAction(2);
            values.addCmdValues(deleteCMD);
            this.generateAddNumACL(values);
        }
    }

    public Enumeration getConflictingACEs(ACEInterface ace, int loc) {
        Vector conflictingACEs = new Vector();
        int i = 0;
        while (i < loc) {
            int compResult = ((ACEInterface)this._aces.elementAt(i)).compare(ace);
            if (compResult == 0 || compResult == 1) {
                conflictingACEs.addElement(this._aces.elementAt(i));
            }
            ++i;
        }
        int i2 = loc;
        while (i2 < this.getNumberofACEs()) {
            int compResult = ace.compare((ACEInterface)this._aces.elementAt(i2));
            if (compResult == 0 || compResult == 1) {
                conflictingACEs.addElement(this._aces.elementAt(i2));
            }
            ++i2;
        }
        return conflictingACEs.elements();
    }

    public ACL getMirrorACL() {
        if (this.getACLType() == 0) {
            return null;
        }
        ACL mirrorACL = (ACL)this.clone();
        Enumeration aces = mirrorACL.getACEs();
        while (aces.hasMoreElements()) {
            ExtendedACE ace = (ExtendedACE)aces.nextElement();
            ace.mirrorACE();
        }
        return mirrorACL;
    }

    CmdValues getNewCmd() {
        if (this.isNamedACL()) {
            Log.getLog().error("Error named ACL");
            return null;
        }
        CmdValues newCMD = new CmdValues("access-list");
        newCMD.addValue("ACLNumber", this.getNameOrNumber());
        return newCMD;
    }

    public void insertAcl(ACLBase acl, boolean top) {
        if (this._iACLType != acl._iACLType) {
            return;
        }
        if (acl.getNumberofACEs() == 0) {
            return;
        }
        if (top) {
            int i = 0;
            while (i < acl._aces.size()) {
                ACEInterface ace = (ACEInterface)((StandardACE)acl.getACE(i)).clone();
                if (!this.isDuplicateACE(ace)) {
                    this.addACE(ace, i);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < acl._aces.size()) {
                ACEInterface aceInterface = (ACEInterface)((StandardACE)acl.getACE(i)).clone();
                if (!this.isDuplicateACE(aceInterface)) {
                    this.addACE(aceInterface);
                }
                ++i;
            }
        }
    }

    public boolean isDuplicateACE(ACEInterface ace) {
        int i = 0;
        while (i < this._aces.size()) {
            if (ace.isDuplicateACE(this.getACE(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isNumberInRange(int number) {
        if (this._iACLType == 0) {
            return ACLBase.isStandardNumber(number);
        }
        if (this._iACLType == 1) {
            return ACLBase.isExtendedNumber(number);
        }
        return false;
    }

    public int moveACE(int currentLoc, int newLoc) {
        Object tempACE = null;
        try {
            tempACE = this._aces.elementAt(currentLoc);
            this._aces.removeElementAt(currentLoc);
            this._aces.insertElementAt(tempACE, newLoc);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (tempACE != null && this._aces.indexOf(tempACE) == -1) {
                this._aces.insertElementAt(tempACE, currentLoc);
            }
            Log.getLog().error("Error while moving ACE Error message" + e.getMessage());
            return -1;
        }
        this.setModified();
        return newLoc;
    }

    public int moveACEDown(int index) {
        if (index < 0 || index >= this._aces.size() - 1) {
            Log.getLog().error("Cannot move ACE down Index= " + String.valueOf(index) + " number of ACEs = " + String.valueOf(this._aces.size()));
            return -1;
        }
        return this.moveACE(index, index + 1);
    }

    public int moveACEUp(int index) {
        if (index <= 0 || index >= this._aces.size()) {
            Log.getLog().error("Cannot move ACE up Index= " + String.valueOf(index) + " number of ACEs = " + String.valueOf(this._aces.size()));
            return -1;
        }
        return this.moveACE(index, index - 1);
    }

    private boolean parseRemark(String remark, int remarkNumber) {
        if (remark.startsWith("SDM_ACL") || remark.startsWith("XDM_ACL")) {
            if (remark.indexOf("Category") != -1) {
                String temp = remark.substring(remark.indexOf("Category") + 9);
                try {
                    int number;
                    this._categories = number = Integer.parseInt(temp);
                }
                catch (NumberFormatException e) {
                    Log.getLog().error(e.getMessage());
                }
            }
            if (remark.indexOf("Remark") != -1) {
                this.setRemark(remark.substring(remark.indexOf("Remark") + 7));
            }
        } else {
            if (remarkNumber == 0) {
                this.setRemark(remark);
                return true;
            }
            return false;
        }
        return true;
    }

    public void populate(ConfigValues configValues, CmdValues cmdVal) throws XDMException {
        CmdValues cmd;
        ConfigValues config;
        if (cmdVal != null) {
            config = cmdVal.getModeCmdsValues();
            this.setNameOrNumber(cmdVal.getValue("ACLName"));
        } else {
            config = configValues;
            cmd = config.getCmdValues(0);
            this.setNameOrNumber(cmd.getValue("ACLNumber"));
        }
        this.addToCategory(5);
        String tempRemark = "";
        int i = 0;
        while (i < config.numCmds()) {
            cmd = config.getCmdValues(i);
            String tempRemark1 = cmd.getValue("Remark");
            if (tempRemark1 == null) {
                StandardACE tempACE = (StandardACE)this.buildACE(cmd);
                if (tempACE != null) {
                    tempACE.setParent(this);
                    tempACE.populate(null, cmd);
                    tempACE.setRemark(tempRemark);
                    this.addACE(tempACE);
                    tempRemark = "";
                }
            } else if (!this.parseRemark(tempRemark1, i)) {
                tempRemark = tempRemark1;
            }
            ++i;
        }
    }

    public boolean removeACE(int index) {
        try {
            this._aces.removeElementAt(index);
        }
        catch (Exception e) {
            Log.getLog().error("Array Index out of bound exception : " + e.getMessage());
            return false;
        }
        this.setModified();
        return true;
    }

    public boolean setACEAt(ACEInterface newAce, int index) {
        if (this.getACLType() == 0 && newAce.getACEType() != 0 || this.getACLType() == 1 && newAce.getACEType() == 0) {
            Log.getLog().error("ACE passed iS of different type");
            return false;
        }
        try {
            this._aces.setElementAt((XDMObject)((Object)newAce), index);
        }
        catch (Exception e) {
            Log.getLog().error("Array Index out of bound exception : " + e.getMessage());
            return false;
        }
        ((XDMObject)((Object)newAce)).setParent(this);
        this.setModified();
        return true;
    }

    public void setACLType(int aclType) throws XDMException {
        if (this.getNumberofACEs() != 0) {
            Log.getLog().debug("Cannot set ACL Type ACL not Empty.");
            throw new XDMException(103);
        }
        if (aclType > 1) {
            Log.getLog().error("ACL type not supported");
            Log.getLog().error("Passed ACL type : " + String.valueOf(aclType));
            throw new XDMException(104);
        }
        this._iACLType = aclType;
        this.setModified();
    }

    public void setDestAddress(String destAddress, String wildCardMask) {
        if (this._iACLType == 0) {
            return;
        }
        Enumeration aces = this._aces.elements();
        while (aces.hasMoreElements()) {
            ((ExtendedACE)aces.nextElement()).setDestAddress(destAddress, wildCardMask);
        }
    }

    protected int setName(String name) {
        if (!ACLBase.isValidName(name)) {
            Log.getLog().debug("Invalid name : Name should start with an alphabetic character.");
            return -1;
        }
        this._strNameOrNumber = name;
        this._bNameOrNumber = true;
        this.setModified();
        return 1;
    }

    public int setNameOrNumber(String name) {
        try {
            int number = Integer.parseInt(name);
            return this.setNumber(number);
        }
        catch (NumberFormatException numberFormatException) {
            return this.setName(name);
        }
    }

    protected int setNumber(int number) {
        if (!this.isNumberInRange(number)) {
            Log.getLog().error("Invalid number");
            return -1;
        }
        this._strNameOrNumber = String.valueOf(number);
        this._bNameOrNumber = false;
        this.setModified();
        return 1;
    }

    public void setRemark(String remark) {
        this._strRemark = remark;
        this.setModified();
    }

    public void setSourceAddress(String sourceAddress, String wildCardMask) {
        Enumeration aces = this._aces.elements();
        while (aces.hasMoreElements()) {
            ((StandardACE)aces.nextElement()).setSource(sourceAddress, wildCardMask);
        }
    }

    public String stringType() {
        if (this._iACLType == 0) {
            return "Standard ACL";
        }
        if (this._iACLType == 1) {
            return "Extended ACL";
        }
        return "Unknown ACL";
    }

    public Enumeration verify() {
        Vector conflictingACEs = new Vector();
        int j = 0;
        while (j < this._aces.size()) {
            int i = 0;
            while (i < j) {
                int compResult = ((ACEInterface)this._aces.elementAt(i)).compare((ACEInterface)this._aces.elementAt(j));
                Log.getLog().debug("In Verify Comp Results of i:" + String.valueOf(i) + " j:" + String.valueOf(j) + " Results: " + String.valueOf(compResult));
                if ((compResult == 0 || compResult == 1) && conflictingACEs.indexOf(this._aces.elementAt(i)) == -1) {
                    conflictingACEs.addElement(this._aces.elementAt(i));
                }
                ++i;
            }
            ++j;
        }
        return conflictingACEs.elements();
    }
}

