/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.acl.ACEFilter;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACLCategories;
import com.cisco.xdm.data.acl.StandardACE;
import com.cisco.xdm.data.base.XDMObject;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ACLBase
extends XDMObject
implements Cloneable {
    private static final String[] RESERVED_KEYWORDS = new String[]{"in", "out"};
    protected int _iACLType;
    protected Vector _aces = new Vector();
    protected String _strNameOrNumber;
    protected String _strRemark = "";
    protected boolean _bNameOrNumber;
    int _categories = 0;
    public static final int STANDARD_ACL = 0;
    public static final int EXTENDED_ACL = 1;

    public ACLBase(int iACLType, boolean isReadOnly) {
        Log.getLog().debug("In ACLBase constructor ACL Type: " + String.valueOf(iACLType));
        this._iACLType = iACLType;
        this.setReadOnly(isReadOnly);
    }

    public void addToCategory(int category) {
        if (category == 4) {
            this._categories = 0;
        }
        if (category >= 1 && category <= 7) {
            this._categories |= ACLCategories.getBinaryCategory(category);
            this.setModified();
        }
    }

    protected abstract ACEInterface buildACE(CmdValues var1);

    public Object clone() {
        ACLBase newObj = (ACLBase)super.clone();
        newObj._aces = new Vector();
        int i = 0;
        while (i < this._aces.size()) {
            StandardACE newAce = (StandardACE)((StandardACE)this._aces.elementAt(i)).clone();
            newAce.setParent(newObj);
            newObj._aces.addElement(newAce);
            ++i;
        }
        if (newObj.isBelongTo(6)) {
            newObj.deleteFromCategory(6);
        }
        return newObj;
    }

    public abstract boolean compare(ACLBase var1);

    public boolean deleteFromCategory(int category) {
        int cat = this._categories & ~ACLCategories.getBinaryCategory(category);
        if (cat == 0 && category != 6) {
            return false;
        }
        this._categories = cat;
        this.setModified();
        return true;
    }

    public ACEInterface getACE(int index) throws ArrayIndexOutOfBoundsException {
        return (ACEInterface)this._aces.elementAt(index);
    }

    public Enumeration getACEs() {
        return this._aces.elements();
    }

    public Enumeration getACEsforRule(ACEInterface rule) {
        Log.getLog().debug("In getACEsforRule");
        Log.getLog().debug("ACE Rule passed " + rule.toString());
        Vector machedACEs = new Vector();
        if (this.getACLType() == 0 && rule.getACEType() != 0 || this.getACLType() == 1 && rule.getACEType() == 0) {
            Log.getLog().debug("Missmached ACE and ACL Type.");
            return machedACEs.elements();
        }
        int i = 0;
        while (i < this._aces.size()) {
            int compResult = ((ACEInterface)this._aces.elementAt(i)).compare(rule);
            if (compResult == 3) {
                machedACEs.addElement(this._aces.elementAt(i));
            } else {
                if (compResult == 0) {
                    machedACEs.addElement(this._aces.elementAt(i));
                    break;
                }
                if (compResult == 1) break;
            }
            ++i;
        }
        Log.getLog().debug("Number of ACEs found : " + String.valueOf(machedACEs.size()));
        return machedACEs.elements();
    }

    public int getACLType() {
        return this._iACLType;
    }

    public Enumeration getFilteredACEs(ACEFilter aceFilter) {
        Log.getLog().debug("In getFilteredACEs");
        Log.getLog().debug("Filter ACE passed \n " + aceFilter.toString());
        Vector filteredACEs = new Vector();
        int i = 0;
        while (i < this._aces.size()) {
            if (aceFilter.accept((ACEInterface)this._aces.elementAt(i))) {
                filteredACEs.addElement(this._aces.elementAt(i));
            }
            ++i;
        }
        Log.getLog().debug("Number of ACEs returned " + String.valueOf(filteredACEs.size()));
        return filteredACEs.elements();
    }

    public int getIndexOfACE(ACEInterface ace) {
        return this._aces.indexOf((XDMObject)((Object)ace));
    }

    public String getNameOrNumber() {
        return this._strNameOrNumber;
    }

    public int getNumberofACEs() {
        return this._aces.size();
    }

    public String getRemark() {
        return this._strRemark;
    }

    public boolean isBelongTo(int category) {
        return (this._categories & ACLCategories.getBinaryCategory(category)) != 0;
    }

    public boolean isEqual(ACLBase acl) {
        if (acl._iACLType != this._iACLType) {
            return false;
        }
        if (this._aces.size() != acl._aces.size()) {
            return false;
        }
        int i = 0;
        while (i < this._aces.size()) {
            if (!this.getACE(i).isDuplicateACE(acl.getACE(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isExtendedNumber(int num) {
        return num >= 100 && num < 200 || num >= 2000 && num < 2700;
    }

    public boolean isNameChangeAllowed() {
        return true;
    }

    public boolean isNamedACL() {
        return this._bNameOrNumber;
    }

    protected abstract boolean isNumberInRange(int var1);

    public static boolean isStandardNumber(int num) {
        return num > 0 && num < 100 || num >= 1300 && num < 2000;
    }

    public static boolean isValidName(String name) {
        return Character.isJavaIdentifierStart(name.charAt(0)) && name.charAt(0) != '$' && name.charAt(0) != '_' && !ACLBase.matchesReserved(name) && name.indexOf(32) == -1 && name.indexOf(63) == -1 && name.indexOf(9) == -1;
    }

    public static boolean isValidRemark(String remark) {
        return remark.indexOf(63) == -1 && remark.indexOf(9) == -1;
    }

    private static boolean matchesReserved(String name) {
        int count = 0;
        while (count < RESERVED_KEYWORDS.length) {
            if (name.trim().equals(RESERVED_KEYWORDS[count])) {
                return true;
            }
            ++count;
        }
        return false;
    }

    final void setUnSupported() {
        this.addToCategory(4);
        this.setReadOnly(true);
    }

    public String stringType() {
        return "ACLBase";
    }

    public String toString() {
        StringBuffer tempString = new StringBuffer();
        tempString.append(this.stringType()).append("\n");
        tempString.append("Name or Number: ").append(this._strNameOrNumber).append("\n");
        tempString.append("Description: ").append(this._strRemark).append("\n");
        tempString.append(ACLCategories.convertToString(this._categories));
        tempString.append("Number of ACEs :").append(String.valueOf(this.getNumberofACEs())).append("\n");
        Enumeration aces = this.getACEs();
        while (aces.hasMoreElements()) {
            tempString.append(aces.nextElement().toString());
        }
        return tempString.toString();
    }

    public abstract Enumeration verify();
}

