/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.xdm.data.acl.ACL;
import com.cisco.xdm.data.acl.ACLBase;

public class ACLBuilder {
    static ACLBase buildACL(CmdValues cmd) {
        if (cmd.getCmdName().equals("access-list")) {
            int number = Integer.parseInt(cmd.getValue("ACLNumber"));
            if (ACLBase.isStandardNumber(number)) {
                return new ACL(0);
            }
            if (ACLBase.isExtendedNumber(number)) {
                return new ACL(1);
            }
            return null;
        }
        if (cmd.getCmdName().equals("ip")) {
            String aclType = cmd.getValue("standard");
            if (aclType != null && aclType.equals("standard")) {
                return new ACL(0);
            }
            aclType = cmd.getValue("extended");
            if (aclType != null && aclType.equals("extended")) {
                return new ACL(1);
            }
        }
        return null;
    }
}

