/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.acl.ACL;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.ACLBuilder;
import com.cisco.xdm.data.acl.ACLFilter;
import com.cisco.xdm.data.acl.SortedACLVector;
import com.cisco.xdm.data.base.CmdPositionHandler;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import java.util.Enumeration;
import java.util.Vector;

public class ACLCollection
extends XDMHashCollection
implements CmdPositionHandler {
    public ACLCollection() {
    }

    public ACLCollection(XDMObject parent) {
        super(parent);
    }

    public boolean addACL(ACLBase aclNew) {
        if (this.containsKey(aclNew.getNameOrNumber())) {
            Log.getLog().debug("ACL with same name or number already in ACLCollection, Name/Number: " + aclNew.getNameOrNumber());
            return false;
        }
        this.put(aclNew.getNameOrNumber(), aclNew);
        return true;
    }

    public String addDefaultACL(ACLBase acl) {
        acl.deleteFromCategory(6);
        if (!this.isNameOrNumberUsed(acl.getNameOrNumber())) {
            if (this.addACL(acl)) {
                return acl.getNameOrNumber();
            }
            return null;
        }
        if (acl.isNamedACL()) {
            int i = 0;
            while (true) {
                String tempName = acl.getNameOrNumber();
                if (!this.isNameOrNumberUsed(tempName = String.valueOf(tempName) + "_" + String.valueOf(i))) {
                    ((ACL)acl).setNameOrNumber(tempName);
                    if (this.addACL(acl)) {
                        return tempName;
                    }
                }
                ++i;
            }
        }
        if (acl.getACLType() == 0) {
            if (this.getNextAvailableACLNumber() != -1) {
                String tempName = String.valueOf(this.getNextAvailableACLNumber());
                ((ACL)acl).setNameOrNumber(tempName);
                if (this.addACL(acl)) {
                    return tempName;
                }
                return null;
            }
            return null;
        }
        if (this.getNextAvalableExtendedACLNumber() != -1) {
            String tempName = String.valueOf(this.getNextAvalableExtendedACLNumber());
            ((ACL)acl).setNameOrNumber(tempName);
            if (this.addACL(acl)) {
                return tempName;
            }
            return null;
        }
        return null;
    }

    public boolean deleteACL(String nameOrNumber) {
        if (this.remove(nameOrNumber) == null) {
            Log.getLog().error("Error deleting ACL, Name : " + nameOrNumber);
            return false;
        }
        return true;
    }

    public ACLBase getACL(String nameOrNumber) {
        return (ACLBase)this.get(nameOrNumber);
    }

    public Enumeration getACLsByCategory(int category) {
        return this.getACLsByCategory(category, 2);
    }

    public Enumeration getACLsByCategory(int category, int aclType) {
        SortedACLVector filteredACLs = new SortedACLVector();
        Enumeration acls = this.elements();
        while (acls.hasMoreElements()) {
            ACLBase tempACL = (ACLBase)acls.nextElement();
            if (!tempACL.isBelongTo(category) || aclType != 2 && aclType != tempACL.getACLType()) continue;
            filteredACLs.addElement(tempACL);
        }
        filteredACLs.sort();
        return filteredACLs.elements();
    }

    public int getACLsInCategory(int category) {
        int aclCount = 0;
        Enumeration acls = this.elements();
        while (acls.hasMoreElements()) {
            ACLBase tempACL = (ACLBase)acls.nextElement();
            if (!tempACL.isBelongTo(category)) continue;
            ++aclCount;
        }
        return aclCount;
    }

    public ACLBase getEquivalentACL(ACLBase acl) {
        Enumeration acls = this.elements();
        while (acls.hasMoreElements()) {
            ACLBase tempACL = (ACLBase)acls.nextElement();
            if (!tempACL.compare(acl)) continue;
            return tempACL;
        }
        return null;
    }

    public Enumeration getFilteredACLs(ACLFilter aclFilter) {
        Vector<ACLBase> filteredACLs = new Vector<ACLBase>();
        Enumeration acls = this.elements();
        while (acls.hasMoreElements()) {
            ACLBase tempACL = (ACLBase)acls.nextElement();
            if (!aclFilter.accept(tempACL)) continue;
            filteredACLs.addElement(tempACL);
        }
        return filteredACLs.elements();
    }

    public int getFirstCmdPosition(String module, ConfigValues config, boolean noCmd) {
        int i = 0;
        while (i < config.numCmds()) {
            CmdValues cmd = config.getCmdValues(i);
            String cmdName = cmd.getCmdName();
            if (cmdName.equals("access-list")) {
                if (noCmd && cmd.getAction() == 2) {
                    return i;
                }
                if (!noCmd && cmd.getAction() != 2) {
                    return i;
                }
            }
            if (cmdName.equals("ip") && cmd.containsKey("access-list")) {
                if (noCmd && cmd.getAction() == 2) {
                    return i;
                }
                if (!noCmd && cmd.getAction() != 2) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public int getNextAvailableACLNumber() {
        int i = 1;
        while (i < 100) {
            if (!this.containsKey(String.valueOf(i))) {
                return i;
            }
            ++i;
        }
        int i2 = 1300;
        while (i2 < 2000) {
            if (!this.containsKey(String.valueOf(i2))) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int getNextAvalableExtendedACLNumber() {
        int i = 100;
        while (i < 200) {
            if (!this.containsKey(String.valueOf(i))) {
                return i;
            }
            ++i;
        }
        int i2 = 2000;
        while (i2 < 2700) {
            if (!this.containsKey(String.valueOf(i2))) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public boolean isNameOrNumberUsed(String nameOrNumber) {
        return this.containsKey(nameOrNumber);
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException {
        try {
            ACLBase acl;
            CmdValues cmd;
            int i;
            ConfigValues cv1 = config.getCmds("access-list", "ACLNumber", ".*", false);
            if (cv1 != null) {
                i = 0;
                while (i < cv1.numCmds()) {
                    cmd = cv1.getCmdValues(i);
                    String number = cmd.getValue("ACLNumber");
                    if (!this.containsKey(number) && (acl = ACLBuilder.buildACL(cmd)) != null) {
                        acl.setParent(this);
                        acl.populate(cv1.getCmds("access-list", "ACLNumber", number, false), null);
                        this.addACL(acl);
                    }
                    ++i;
                }
            }
            if ((cv1 = config.getCmds("ip", "access-list", ".*", false)) != null) {
                cv1 = cv1.getCmds("ip", "ACLName", ".*", false);
            }
            if (cv1 != null) {
                i = 0;
                while (i < cv1.numCmds()) {
                    cmd = cv1.getCmdValues(i);
                    String name = cmd.getValue("ACLName");
                    if (!this.containsKey(name) && (acl = ACLBuilder.buildACL(cmd)) != null) {
                        acl.setParent(this);
                        acl.populate(null, cmd);
                        this.addACL(acl);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XDMException(100);
        }
    }

    public boolean replaceACL(ACLBase currACL, ACLBase newACL) {
        if (!this.deleteACL(currACL.getNameOrNumber())) {
            return false;
        }
        return this.addACL(newACL);
    }

    public String toString() {
        StringBuffer tempString = new StringBuffer();
        tempString.append("Number of ACLs in ACL Collection : ").append(String.valueOf(this.size())).append("\n\n");
        Enumeration acls = this.elements();
        while (acls.hasMoreElements()) {
            ACLBase tempACL = (ACLBase)acls.nextElement();
            tempString.append(tempACL.toString()).append("\n");
        }
        return tempString.toString();
    }
}

