/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.StandardACE;
import com.cisco.xdm.data.base.XDMException;

public class DynamicACE
extends StandardACE {
    private String _dynamicACLName;
    private int _timeout;
    private String _unparsedCmd;

    public DynamicACE() {
        this._aceType = 6;
        this.setReadOnly(true);
    }

    public Object clone() {
        DynamicACE newObj = (DynamicACE)super.clone();
        return newObj;
    }

    protected boolean compNonAddressMembers(DynamicACE ace) {
        if (this._timeout != ace._timeout) {
            return false;
        }
        if (this._dynamicACLName != null ? !this._dynamicACLName.equals(ace._dynamicACLName) : ace._dynamicACLName != null) {
            return false;
        }
        return !(this._unparsedCmd != null ? !this._unparsedCmd.equals(ace._unparsedCmd) : ace._unparsedCmd != null);
    }

    public int compare(ACEInterface rule) {
        if (((StandardACE)rule)._aceType != 6) {
            return 2;
        }
        if (this.compNonAddressMembers((DynamicACE)rule) && super.compare(rule) == 5) {
            return 5;
        }
        return 2;
    }

    protected boolean equals(DynamicACE ace) {
        return this.compNonAddressMembers(ace);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            DynamicACE ace = (DynamicACE)obj;
            return this.equals(ace);
        }
        return false;
    }

    public CmdValues generateAceCmd() {
        CmdValues cmdVal = super.generateAceCmd();
        return cmdVal;
    }

    public String getDestFormated() {
        return "--<dynamic>--";
    }

    public String getService() {
        return this.toCLI();
    }

    public String getSourceFormated() {
        return "--<dynamic>--";
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException {
        this._dynamicACLName = cmdVal.getValue("DYNAMIC-ACL-NAME");
        String tempString = cmdVal.getValue("TIME-OUT");
        if (tempString != null) {
            try {
                this._timeout = Integer.parseInt(tempString);
            }
            catch (NumberFormatException e) {
                Log.getLog().error(e.getMessage());
            }
        }
        this._unparsedCmd = cmdVal.getValue("UNPARSED-CLI");
        ((ACLBase)this.getParent()).setUnSupported();
    }

    public String toCLI() {
        StringBuffer tempString = new StringBuffer();
        tempString.append("dynamic").append(" ").append(this._dynamicACLName);
        if (this._timeout != 0) {
            tempString.append(" ").append("TIME-OUT").append(" ").append(String.valueOf(this._timeout));
        }
        tempString.append(" ").append(this._unparsedCmd);
        return tempString.toString();
    }

    public String toCLI1() {
        return this.toCLI();
    }

    public String toFormatedString() {
        return this.toCLI();
    }
}

