/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.StandardACE;
import com.cisco.xdm.data.base.XDMException;

public class EvaluateACE
extends StandardACE {
    private String _reflectACLName;

    public EvaluateACE() {
        this._aceType = 7;
        this.setReadOnly(true);
    }

    public Object clone() {
        EvaluateACE newObj = (EvaluateACE)super.clone();
        return newObj;
    }

    public int compare(ACEInterface rule) {
        if (((StandardACE)rule)._aceType != 7) {
            return 2;
        }
        if (this._reflectACLName != null) {
            if (this._reflectACLName.equals(((EvaluateACE)rule)._reflectACLName)) {
                return 5;
            }
            return 2;
        }
        if (((EvaluateACE)rule)._reflectACLName == null) {
            return 5;
        }
        return 2;
    }

    protected boolean equals(EvaluateACE ace) {
        if (this._reflectACLName != null) {
            return this._reflectACLName.equals(ace._reflectACLName);
        }
        return ace._reflectACLName == null;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            EvaluateACE ace = (EvaluateACE)obj;
            return this.equals(ace);
        }
        return false;
    }

    public CmdValues generateAceCmd() {
        CmdValues cmdVal = super.generateAceCmd();
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            cmdVal.addValue("reflect", "reflect");
            cmdVal.addValue("REFLECT-ACL-NAME", this._reflectACLName);
        }
        return cmdVal;
    }

    public String getDestFormated() {
        return "--<evaluate>--";
    }

    public String getService() {
        return this.toCLI();
    }

    public String getSourceFormated() {
        return "--<evaluate>--";
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException {
        this._reflectACLName = cmdVal.getValue("REFLECT-ACL-NAME");
        ((ACLBase)this.getParent()).setUnSupported();
    }

    public String toCLI() {
        StringBuffer tempString = new StringBuffer();
        tempString.append("evaluate").append(" ").append(this._reflectACLName);
        return tempString.toString();
    }

    public String toCLI1() {
        return this.toCLI();
    }

    public String toFormatedString() {
        return this.toCLI();
    }
}

