/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.ExtendedACE;
import com.cisco.xdm.data.acl.StandardACE;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.common.PortMap;

public class ExtIgmpACE
extends ExtendedACE
implements Cloneable {
    private int _igmpType = -1;
    private String _igmpMessage = null;

    public ExtIgmpACE() {
        this._aceType = 5;
        this._protocol = "igmp";
    }

    public Object clone() {
        ExtIgmpACE newObj = (ExtIgmpACE)super.clone();
        return newObj;
    }

    public int compare(ACEInterface aceRule) {
        if (((StandardACE)aceRule)._aceType == 0) {
            return 2;
        }
        if (aceRule instanceof ExtIgmpACE) {
            ExtIgmpACE ace = (ExtIgmpACE)aceRule;
            return this.compare(ace);
        }
        if (((ExtendedACE)aceRule).getProtocol().equals("ip")) {
            int superCompResult = super.compare(aceRule);
            if (superCompResult == 0) {
                return 3;
            }
            if (superCompResult == 1) {
                return 6;
            }
            return superCompResult;
        }
        return 2;
    }

    protected int compare(ExtIgmpACE aceRule) {
        return super.compare(aceRule);
    }

    public void copy(ACEInterface ace) {
        super.copy(ace);
        if (ace instanceof ExtIgmpACE) {
            ExtIgmpACE tempAce = (ExtIgmpACE)ace;
            this._igmpType = tempAce._igmpType;
            this._igmpMessage = tempAce._igmpMessage;
        }
    }

    protected boolean equals(ExtIgmpACE ace) {
        boolean cmpVal;
        boolean bl = cmpVal = super.equals(ace) && this._igmpType == ace._igmpType;
        if (this._igmpMessage != null) {
            cmpVal = cmpVal && this._igmpMessage.equals(ace._igmpMessage);
        }
        return cmpVal;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ExtIgmpACE ace = (ExtIgmpACE)obj;
            return this.equals(ace);
        }
        return false;
    }

    protected CmdValues generateAceCmd() {
        CmdValues cmdVal = super.generateAceCmd();
        if (this._igmpType != -1) {
            cmdVal.addValue("IGMP-TYPE", String.valueOf(this._igmpType));
        } else if (this._igmpMessage != null && this._igmpMessage.length() != 0) {
            cmdVal.addValue("IGMP-MESSAGE", this._igmpMessage);
        }
        return cmdVal;
    }

    public String getIgmpMessage() {
        return this._igmpMessage;
    }

    public int getIgmpType() {
        return this._igmpType;
    }

    public String getService() {
        StringBuffer tempString = new StringBuffer();
        if (this._igmpType != -1) {
            tempString.append(String.valueOf(this._igmpType)).append("/igmp");
        } else if (this._igmpMessage != null && this._igmpMessage.length() != 0) {
            tempString.append(this._igmpMessage).append("/igmp");
        } else {
            tempString.append("igmp");
        }
        return tempString.toString();
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException {
        super.populate(config, cmdVal);
        String temp = cmdVal.getValue("IGMP-TYPE");
        if (temp != null) {
            this._igmpType = Integer.parseInt(temp);
        }
        this._igmpMessage = cmdVal.getValue("IGMP-MESSAGE");
        if (this._igmpMessage != null || this._igmpType != -1) {
            ((ACLBase)this.getParent()).setUnSupported();
        }
    }

    public boolean setIgmpMessage(String igmpMessage) {
        int temp = PortMap.findValueByKey(igmpMessage, PortMap.igmpTypeTable);
        if (temp == -1) {
            return false;
        }
        this._igmpType = temp;
        this.setModified();
        return true;
    }

    public boolean setIgmpType(int igmpType) {
        if (igmpType > 15) {
            return false;
        }
        this._igmpType = igmpType;
        this._igmpMessage = null;
        this.setModified();
        return true;
    }

    public boolean setProtocol(String protocol) {
        return false;
    }

    public String toCLI() {
        StringBuffer tempString = new StringBuffer();
        if (!this._bGrant) {
            tempString.append("deny");
        } else {
            tempString.append("permit");
        }
        tempString.append(" ").append(this._protocol);
        tempString.append(" ").append(this._source.toCLI());
        tempString.append(" ").append(this._destAddress.toCLI());
        if (this._igmpType != -1) {
            tempString.append(" ").append(String.valueOf(this._igmpType));
        } else if (this._igmpMessage != null && this._igmpMessage.length() != 0) {
            tempString.append(" ").append(this._igmpMessage);
        }
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append(" ").append("dscp").append(" ").append(this._dscp);
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            tempString.append(" ").append("precedence").append(" ").append(this._precedence);
        }
        if (this._tos != null && this._tos.length() != 0) {
            tempString.append(" ").append("tos").append(" ").append(this._tos);
        }
        if (this._bLog) {
            tempString.append(" ").append("log");
        }
        if (this._bLogInput) {
            tempString.append(" ").append("log-input");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            tempString.append(" ").append("time-range").append(" ").append(this._timeRange);
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            tempString.append(" ").append("reflect").append(" ").append(this._reflectACLName);
        }
        return tempString.toString();
    }

    public String toCLI1() {
        StringBuffer tempString = new StringBuffer();
        boolean flag = false;
        if (!this._bGrant) {
            tempString.append("deny all ");
        } else {
            tempString.append("permit all ");
        }
        tempString.append(this._protocol).append(" traffic");
        tempString.append(" from ").append(this._source.toCLI());
        tempString.append(" to ").append(this._destAddress.toCLI()).append(" ");
        if (this._igmpType != -1) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("Igmp Type ").append(String.valueOf(this._igmpType));
        } else if (this._igmpMessage != null && this._igmpMessage.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("Igmp Type ").append(this._igmpMessage);
        }
        if (this._dscp != null && this._dscp.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("dscp").append("=").append(this._dscp);
            flag = true;
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("precedence").append(" = ").append(this._precedence);
        }
        if (this._tos != null && this._tos.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("tos").append(" = ").append(this._tos);
        }
        if (this._bLog) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("log");
        }
        if (this._bLogInput) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("log-input");
        }
        if (this._bFragments) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("fragments");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("time-range").append(" = ").append(this._timeRange);
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("reflect").append(" = ").append(this._reflectACLName);
        }
        return tempString.toString();
    }

    public String toFormatedString() {
        StringBuffer tempString = new StringBuffer();
        if (this._igmpType != -1) {
            tempString.append(String.valueOf(this._igmpType)).append("/igmp,");
        } else if (this._igmpMessage != null && this._igmpMessage.length() != 0) {
            tempString.append(this._igmpMessage).append("/igmp,");
        } else {
            tempString.append("igmp,");
        }
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append(this._dscp).append("/").append("dscp").append(",");
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            tempString.append(this._precedence).append("/").append("precedence").append(",");
        }
        if (this._tos != null && this._tos.length() != 0) {
            tempString.append(this._tos).append("/").append("tos").append(",");
        }
        if (this._bLog) {
            tempString.append("log").append(",");
        }
        if (this._bLogInput) {
            tempString.append("log-input").append(",");
        }
        if (this._bFragments) {
            tempString.append("fragments").append(",");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            tempString.append(this._timeRange).append("/").append("time-range").append(",");
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            tempString.append(this._reflectACLName).append("/").append("reflect").append(",");
        }
        return tempString.toString();
    }
}

