/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.ExtUdpACE;
import com.cisco.xdm.data.acl.ExtendedACE;
import com.cisco.xdm.data.acl.StandardACE;
import com.cisco.xdm.data.base.XDMException;

public class ExtTcpACE
extends ExtUdpACE
implements Cloneable {
    protected boolean _bEstablished;
    protected boolean _bACK;
    protected boolean _bFIN;
    protected boolean _bPSH;
    protected boolean _bRST;
    protected boolean _bSYN;
    protected boolean _bURG;

    public ExtTcpACE() {
        this._aceType = 3;
        this._protocol = "tcp";
        this._sourcePort.setPortType(1);
        this._destPort.setPortType(1);
    }

    public Object clone() {
        ExtUdpACE newObj = (ExtUdpACE)super.clone();
        return newObj;
    }

    public int compare(ACEInterface aceRule) {
        if (((StandardACE)aceRule)._aceType == 0) {
            return 2;
        }
        if (aceRule instanceof ExtTcpACE) {
            ExtTcpACE ace = (ExtTcpACE)aceRule;
            return this.compare(ace);
        }
        if (((ExtendedACE)aceRule).getProtocol().equals("ip")) {
            int superCompResult = super.compare(aceRule);
            if (superCompResult == 0) {
                return 3;
            }
            if (superCompResult == 1) {
                return 6;
            }
            return superCompResult;
        }
        return 2;
    }

    protected int compare(ExtTcpACE aceRule) {
        if (!this.equals(aceRule)) {
            return 2;
        }
        return super.compare(aceRule);
    }

    public void copy(ACEInterface ace) {
        super.copy(ace);
        if (ace instanceof ExtTcpACE) {
            ExtTcpACE tempAce = (ExtTcpACE)ace;
            this._bACK = tempAce._bACK;
            this._bEstablished = tempAce._bEstablished;
            this._bFIN = tempAce._bFIN;
            this._bPSH = tempAce._bPSH;
            this._bRST = tempAce._bRST;
            this._bSYN = tempAce._bSYN;
            this._bURG = tempAce._bURG;
        }
        this._sourcePort.setPortType(1);
        this._destPort.setPortType(1);
    }

    protected boolean equals(ExtTcpACE ace) {
        return super.equals(ace) && this._bEstablished == ace._bEstablished && this._bACK == ace._bACK && this._bFIN == ace._bFIN && this._bPSH == ace._bPSH && this._bRST == ace._bRST && this._bSYN == ace._bSYN && this._bURG == ace._bURG;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ExtTcpACE ace = (ExtTcpACE)obj;
            return this.equals(ace);
        }
        return false;
    }

    protected CmdValues generateAceCmd() {
        CmdValues cmdVal = super.generateAceCmd();
        if (this._bACK) {
            cmdVal.addValue("ack", "ack");
        }
        if (this._bEstablished) {
            cmdVal.addValue("established", "established");
        }
        if (this._bFIN) {
            cmdVal.addValue("fin", "fin");
        }
        if (this._bPSH) {
            cmdVal.addValue("psh", "psh");
        }
        if (this._bRST) {
            cmdVal.addValue("rst", "rst");
        }
        if (this._bSYN) {
            cmdVal.addValue("syn", "syn");
        }
        if (this._bURG) {
            cmdVal.addValue("urg", "urg");
        }
        return cmdVal;
    }

    public boolean getACK() {
        return this._bACK;
    }

    public boolean getEstablished() {
        return this._bEstablished;
    }

    public String getExtParameters() {
        StringBuffer tempString = new StringBuffer();
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append("dscp").append(" = ").append(this._dscp).append(", ");
        }
        if (this._bACK) {
            tempString.append("ack").append(", ");
        }
        if (this._bEstablished) {
            tempString.append("established").append(", ");
        }
        if (this._bFIN) {
            tempString.append("fin").append(", ");
        }
        if (this._bPSH) {
            tempString.append("psh").append(", ");
        }
        if (this._bRST) {
            tempString.append("rst").append(", ");
        }
        if (this._bSYN) {
            tempString.append("syn").append(", ");
        }
        if (this._bURG) {
            tempString.append("urg").append(", ");
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            tempString.append("precedence").append(" = ").append(this._precedence).append(", ");
        }
        if (this._tos != null && this._tos.length() != 0) {
            tempString.append("tos").append(" = ").append(this._tos).append(", ");
        }
        if (this._bFragments) {
            tempString.append("fragments").append(", ");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            tempString.append("time-range").append(" = ").append(this._timeRange).append(", ");
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            tempString.append("reflect").append(" = ").append(this._reflectACLName).append(", ");
        }
        return tempString.toString();
    }

    public boolean getFIN() {
        return this._bFIN;
    }

    public boolean getPSH() {
        return this._bPSH;
    }

    public boolean getRST() {
        return this._bRST;
    }

    public boolean getSYN() {
        return this._bSYN;
    }

    public boolean getURG() {
        return this._bURG;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException {
        super.populate(config, cmdVal);
        if (cmdVal.getValue("ack") != null) {
            this._bACK = true;
        }
        if (cmdVal.getValue("established") != null) {
            this._bEstablished = true;
        }
        if (cmdVal.getValue("fin") != null) {
            this._bFIN = true;
        }
        if (cmdVal.getValue("psh") != null) {
            this._bPSH = true;
        }
        if (cmdVal.getValue("rst") != null) {
            this._bRST = true;
        }
        if (cmdVal.getValue("syn") != null) {
            this._bSYN = true;
        }
        if (cmdVal.getValue("urg") != null) {
            this._bURG = true;
        }
        if (this._bURG || this._bSYN || this._bPSH || this._bFIN || this._bEstablished || this._bACK) {
            ((ACLBase)this.getParent()).setUnSupported();
        }
    }

    public void setACK(boolean ack) {
        this._bACK = ack;
        if (this._bRST && this._bACK) {
            this._bRST = false;
            this._bACK = false;
            this._bEstablished = true;
        }
        this.setModified();
    }

    public void setEstablished(boolean established) {
        this._bEstablished = established;
        this.setModified();
    }

    public void setFIN(boolean fin) {
        this._bFIN = fin;
        this.setModified();
    }

    public void setPSH(boolean psh) {
        this._bPSH = psh;
        this.setModified();
    }

    public void setRST(boolean rst) {
        this._bRST = rst;
        if (this._bRST && this._bACK) {
            this._bRST = false;
            this._bACK = false;
            this._bEstablished = true;
        }
        this.setModified();
    }

    public void setSYN(boolean syn) {
        this._bSYN = syn;
        this.setModified();
    }

    public void setURG(boolean urg) {
        this._bURG = urg;
        this.setModified();
    }

    public String toCLI() {
        StringBuffer tempString = new StringBuffer();
        if (!this._bGrant) {
            tempString.append("deny");
        } else {
            tempString.append("permit");
        }
        tempString.append(" ").append(this._protocol);
        tempString.append(" ").append(this._source.toCLI());
        tempString.append(" ").append(this._sourcePort.toCLI());
        tempString.append(" ").append(this._destAddress.toCLI());
        tempString.append(" ").append(this._destPort.toCLI());
        if (this._bACK) {
            tempString.append(" ").append("ack");
        }
        if (this._bEstablished) {
            tempString.append(" ").append("established");
        }
        if (this._bFIN) {
            tempString.append(" ").append("fin");
        }
        if (this._bPSH) {
            tempString.append(" ").append("psh");
        }
        if (this._bRST) {
            tempString.append(" ").append("rst");
        }
        if (this._bSYN) {
            tempString.append(" ").append("syn");
        }
        if (this._bURG) {
            tempString.append(" ").append("urg");
        }
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append(" ").append("dscp").append(" ").append(this._dscp);
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            tempString.append(" ").append("precedence").append(" ").append(this._precedence);
        }
        if (this._tos != null && this._tos.length() != 0) {
            tempString.append(" ").append("tos").append(" ").append(this._tos);
        }
        if (this._bLog) {
            tempString.append(" ").append("log");
        }
        if (this._bLogInput) {
            tempString.append(" ").append("log-input");
        }
        if (this._bFragments) {
            tempString.append(" ").append("fragments");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            tempString.append(" ").append("time-range").append(" ").append(this._timeRange);
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            tempString.append(" ").append("reflect").append(" ").append(this._reflectACLName);
        }
        return tempString.toString();
    }

    public String toCLI1() {
        StringBuffer tempString = new StringBuffer();
        boolean flag = false;
        if (!this._bGrant) {
            tempString.append("deny all ");
        } else {
            tempString.append("permit all ");
        }
        tempString.append(this._protocol).append(" traffic");
        tempString.append(" from ").append(this._source.toCLI());
        if (!this._sourcePort.isEmpty()) {
            tempString.append(" port ").append(this._sourcePort.toCLI());
        }
        tempString.append(" to ").append(this._destAddress.toCLI()).append(" ");
        if (!this._destPort.isEmpty()) {
            tempString.append(" port ").append(this._destPort.toCLI()).append(" ");
        }
        if (this._bACK) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("ack");
        }
        if (this._bEstablished) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append(" ").append("established");
        }
        if (this._bFIN) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append(" ").append("fin");
        }
        if (this._bPSH) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append(" ").append("psh");
        }
        if (this._bRST) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append(" ").append("rst");
        }
        if (this._bSYN) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append(" ").append("syn");
        }
        if (this._bURG) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append(" ").append("urg");
        }
        if (this._dscp != null && this._dscp.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("dscp").append(" = ").append(this._dscp);
            flag = true;
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("precedence").append(" = ").append(this._precedence);
        }
        if (this._tos != null && this._tos.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("tos").append(" = ").append(this._tos);
        }
        if (this._bLog) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("log");
        }
        if (this._bLogInput) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("log-input");
        }
        if (this._bFragments) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("fragments");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("time-range").append(" = ").append(this._timeRange);
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("reflect").append(" = ").append(this._reflectACLName);
        }
        return tempString.toString();
    }

    public String toFormatedString() {
        StringBuffer tempString = new StringBuffer();
        if (!this._sourcePort.isEmpty()) {
            tempString.append(this._sourcePort.toCLI()).append("/").append(this._protocol).append(",");
        }
        if (!this._destPort.isEmpty()) {
            tempString.append(this._destPort.toCLI()).append("/").append(this._protocol).append(",");
        }
        if (this._sourcePort.isEmpty() && this._destPort.isEmpty()) {
            tempString.append(this._protocol).append(",");
        }
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append(this._dscp).append("/").append("dscp").append(",");
        }
        if (this._bACK) {
            tempString.append("ack").append(",");
        }
        if (this._bEstablished) {
            tempString.append("established").append(",");
        }
        if (this._bFIN) {
            tempString.append("fin").append(",");
        }
        if (this._bPSH) {
            tempString.append("psh").append(",");
        }
        if (this._bRST) {
            tempString.append("rst").append(",");
        }
        if (this._bSYN) {
            tempString.append("syn").append(",");
        }
        if (this._bURG) {
            tempString.append("urg").append(",");
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            tempString.append(this._precedence).append("/").append("precedence").append(",");
        }
        if (this._tos != null && this._tos.length() != 0) {
            tempString.append(this._tos).append("/").append("tos").append(",");
        }
        if (this._bLog) {
            tempString.append("log").append(",");
        }
        if (this._bLogInput) {
            tempString.append("log-input").append(",");
        }
        if (this._bFragments) {
            tempString.append("fragments").append(",");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            tempString.append(this._timeRange).append("/").append("time-range").append(",");
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            tempString.append(this._reflectACLName).append("/").append("reflect").append(",");
        }
        return tempString.toString();
    }
}

