/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.acl.ACEIPAddress;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACEProtocols;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.StandardACE;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.common.PortMap;

public class ExtendedACE
extends StandardACE {
    protected String _protocol = "ip";
    protected ACEIPAddress _destAddress = new ACEIPAddress();
    protected String _dscp;
    protected String _precedence;
    protected String _tos;
    protected boolean _bFragments;
    protected boolean _bLogInput;
    protected String _timeRange;
    protected String _reflectACLName;

    public ExtendedACE() {
        this._aceType = 1;
    }

    public Object clone() {
        ExtendedACE newObj = (ExtendedACE)super.clone();
        newObj._destAddress = (ACEIPAddress)this._destAddress.clone();
        return newObj;
    }

    protected boolean compNonAddressMembers(ExtendedACE ace) {
        boolean equResult;
        boolean bl = equResult = this._bFragments == ace._bFragments && this._bLogInput == ace._bLogInput;
        if (!equResult) {
            return false;
        }
        if (this._dscp != null ? !this._dscp.equals(ace._dscp) : ace._dscp != null) {
            return false;
        }
        if (this._precedence != null ? !this._precedence.equals(ace._precedence) : ace._precedence != null) {
            return false;
        }
        if (this._protocol != null ? !this._protocol.equals(ace._protocol) : ace._protocol != null) {
            return false;
        }
        if (this._timeRange != null ? !this._timeRange.equals(ace._timeRange) : ace._timeRange != null) {
            return false;
        }
        if (this._reflectACLName != null ? !this._reflectACLName.equals(ace._reflectACLName) : ace._reflectACLName != null) {
            return false;
        }
        return !(this._tos != null ? !this._tos.equals(ace._tos) : ace._tos != null);
    }

    public int compare(ACEInterface rule) {
        if (((StandardACE)rule)._aceType == 0) {
            return 2;
        }
        ExtendedACE aceRule = (ExtendedACE)rule;
        int compResult = this.compare(aceRule);
        if (!(this._protocol.equals("ip") || this._protocol.equals("udp") || this._protocol.equals("tcp") || this._protocol.equals("igmp") || this._protocol.equals("icmp"))) {
            if (((ExtendedACE)rule)._protocol.equals("ip")) {
                if (compResult == 0) {
                    return 3;
                }
                if (compResult == 1) {
                    return 6;
                }
            }
            if (!this._protocol.equals(((ExtendedACE)rule)._protocol)) {
                return 2;
            }
        }
        return compResult;
    }

    protected int compare(ExtendedACE aceRule) {
        int supercompResult = super.compare(aceRule);
        if (supercompResult == 2) {
            return 2;
        }
        int compResult = this._destAddress.compare(aceRule._destAddress);
        if (compResult == 5 || compResult == 4) {
            if (this._bGrant == aceRule._bGrant) {
                return supercompResult;
            }
            if (supercompResult == 3) {
                return 3;
            }
            return 1;
        }
        if (compResult == 3) {
            if (this._bGrant == aceRule._bGrant) {
                return 3;
            }
            return 6;
        }
        return 2;
    }

    public void copy(ACEInterface ace) {
        super.copy(ace);
        if (ace instanceof ExtendedACE) {
            ExtendedACE tempAce = (ExtendedACE)ace;
            this._destAddress = (ACEIPAddress)tempAce._destAddress.clone();
            this._bFragments = tempAce._bFragments;
            this._bLogInput = tempAce._bLogInput;
            this._dscp = tempAce._dscp;
            this._precedence = tempAce._precedence;
            this._protocol = tempAce._protocol;
            this._timeRange = tempAce._timeRange;
            this._reflectACLName = tempAce._reflectACLName;
            this._tos = tempAce._tos;
        }
    }

    protected boolean equals(ExtendedACE ace) {
        return super.equals(ace) && this._destAddress.equals(ace._destAddress) && this.compNonAddressMembers(ace);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ExtendedACE ace = (ExtendedACE)obj;
            return this.equals(ace);
        }
        return false;
    }

    protected CmdValues generateAceCmd() {
        CmdValues cmdVal = super.generateAceCmd();
        if (this._protocol != null && this._protocol.length() != 0 && ACEProtocols.isProtocolName(this._protocol)) {
            cmdVal.addValue("ACLProtocol", this._protocol);
        } else {
            cmdVal.addValue("ACLProtocolNum", this._protocol);
        }
        if (this.isDestHost()) {
            cmdVal.addValue("DEST-HOST", "host");
            cmdVal.addValue("DEST-HOST-ADD", this.getDestAddress());
        } else if (this.isDestAny()) {
            cmdVal.addValue("DEST-ANY", "any");
        } else {
            cmdVal.addValue("DEST-ADDRESS", this.getDestAddress());
            cmdVal.addValue("DEST-WILDCARD", this.getDestWildcardMask());
        }
        if (this._dscp != null && this._dscp.length() != 0) {
            cmdVal.addValue("dscp", "dscp");
            cmdVal.addValue("DSCP-VALUE", this._dscp);
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            cmdVal.addValue("precedence", "precedence");
            cmdVal.addValue("PRECEDENCE-VALUE", this._precedence);
        }
        if (this._tos != null && this._tos.length() != 0) {
            cmdVal.addValue("tos", "tos");
            cmdVal.addValue("TOS-VALUE", this._tos);
        }
        if (this._bFragments) {
            cmdVal.addValue("fragments", "fragments");
        }
        if (this._bLogInput) {
            cmdVal.addValue("log-input", "log-input");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            cmdVal.addValue("time-range", "time-range");
            cmdVal.addValue("TIME-RANGE-VALUE", this._timeRange);
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            cmdVal.addValue("reflect", "reflect");
            cmdVal.addValue("REFLECT-ACL-NAME", this._reflectACLName);
        }
        return cmdVal;
    }

    public String getDSCP() {
        return this._dscp;
    }

    public String getDestAddress() {
        return this._destAddress.getIPAddress();
    }

    public String getDestFormated() {
        if (this._source != null) {
            return this._destAddress.toFormatedString();
        }
        return null;
    }

    public String getDestWildcardMask() {
        return this._destAddress.getWildcardMask();
    }

    public String getExtParameters() {
        StringBuffer tempString = new StringBuffer();
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append("dscp").append(" = ").append(this._dscp).append(", ");
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            tempString.append("precedence").append(" = ").append(this._precedence).append(", ");
        }
        if (this._tos != null && this._tos.length() != 0) {
            tempString.append("tos").append(" = ").append(this._tos).append(", ");
        }
        if (this._bFragments) {
            tempString.append("fragments").append(", ");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            tempString.append("time-range").append(" = ").append(this._timeRange).append(", ");
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            tempString.append("reflect").append(" = ").append(this._reflectACLName).append(", ");
        }
        return tempString.toString();
    }

    public boolean getFragments() {
        return this._bFragments;
    }

    public boolean getLogInput() {
        return this._bLogInput;
    }

    public String getPrecedence() {
        return this._precedence;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getReflectACLName() {
        return this._reflectACLName;
    }

    public String getService() {
        return this._protocol;
    }

    public String getTimeRange() {
        return this._timeRange;
    }

    public String getTos() {
        return this._tos;
    }

    public boolean isDestAny() {
        return this._destAddress.isAny();
    }

    public boolean isDestHost() {
        return this._destAddress.isHost();
    }

    void mirrorACE() {
        ACEIPAddress tempSource = (ACEIPAddress)this._source.clone();
        this._source = this._destAddress;
        this._destAddress = tempSource;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException {
        super.populate(config, cmdVal);
        this._protocol = cmdVal.getValue("ACLProtocol");
        if (this._protocol != null && !ACEProtocols.isProtocolSupported(this._protocol)) {
            ((ACLBase)this.getParent()).setUnSupported();
        }
        if (this._protocol == null || this._protocol.length() == 0) {
            this._protocol = cmdVal.getValue("ACLProtocolNum");
        }
        if (cmdVal.getValue("DEST-ANY") != null) {
            this.setDestAny();
        } else if (cmdVal.getValue("DEST-HOST") != null) {
            this.setDestHost(cmdVal.getValue("DEST-HOST-ADD"));
        } else {
            String tempDest = cmdVal.getValue("DEST-ADDRESS");
            String tempWildCard = cmdVal.getValue("DEST-WILDCARD");
            if (tempWildCard != null) {
                this.setDestAddress(tempDest, tempWildCard);
            } else {
                this.setDestHost(tempDest);
            }
        }
        this._bLogInput = cmdVal.getValue("log-input") != null;
        this._dscp = cmdVal.getValue("DSCP-VALUE");
        this._precedence = cmdVal.getValue("PRECEDENCE-VALUE");
        this._tos = cmdVal.getValue("TOS-VALUE");
        this._bFragments = cmdVal.getValue("fragments") != null;
        this._timeRange = cmdVal.getValue("TIME-RANGE-VALUE");
        this._reflectACLName = cmdVal.getValue("REFLECT-ACL-NAME");
        if (this._timeRange != null || this._reflectACLName != null || this._bLogInput || this._dscp != null || this._precedence != null || this._tos != null || this._bFragments) {
            ((ACLBase)this.getParent()).setUnSupported();
        }
    }

    public boolean setDSCP(String dscp) {
        try {
            int dscpNum = Integer.parseInt(dscp);
            if (dscpNum > 63) {
                return false;
            }
            String dscpValue = PortMap.findKeyByValue(dscpNum, PortMap.dscpTable);
            this._dscp = dscpValue != null ? dscpValue : dscp;
        }
        catch (NumberFormatException numberFormatException) {
            if (PortMap.findValueByKey(dscp, PortMap.dscpTable) == -1) {
                return false;
            }
            this._dscp = dscp;
        }
        this.setModified();
        return true;
    }

    public void setDestAddress(String dest, String wildcardMask) {
        if (dest.equals("any")) {
            this.setDestAny();
        } else if (wildcardMask == null || wildcardMask.length() == 0) {
            this.setDestHost(dest);
        } else {
            this._destAddress.setIPAddress(dest, wildcardMask);
        }
        this.setModified();
    }

    public void setDestAny() {
        this._destAddress.setAny();
    }

    public void setDestHost(String source) {
        this.setModified();
        this._destAddress.setHost(source);
    }

    public void setFragments(boolean fragments) {
        this._bFragments = fragments;
    }

    public void setLog(boolean log) {
        super.setLog(log);
        this._bLogInput = false;
        this.setModified();
    }

    public void setLogInput(boolean logInput) {
        this._bLogInput = logInput;
        this._bLog = false;
        this.setModified();
    }

    public boolean setPrecedence(String precedence) {
        try {
            int precedenceNum = Integer.parseInt(precedence);
            if (precedenceNum > 7) {
                return false;
            }
            String precedenceValue = PortMap.findKeyByValue(precedenceNum, PortMap.precedenceTable);
            if (precedenceValue == null) {
                return false;
            }
            this._precedence = precedenceValue;
        }
        catch (NumberFormatException numberFormatException) {
            if (PortMap.findValueByKey(precedence, PortMap.precedenceTable) == -1) {
                return false;
            }
            this._precedence = precedence;
        }
        this.setModified();
        return true;
    }

    public boolean setProtocol(String protocol) {
        if (protocol == null) {
            return false;
        }
        if (ACEProtocols.isIpProtocolName(protocol)) {
            this._protocol = protocol;
        } else {
            try {
                int protoNum = Integer.parseInt(protocol);
                if (protoNum > 255) {
                    return false;
                }
                String protocolName = PortMap.findKeyByValue(protoNum, PortMap.ipProtTable);
                if (protoNum == 0) {
                    this._protocol = protocol;
                    protocolName = null;
                }
                if (protocolName != null) {
                    if (protocolName.equals("udp") || protocolName.equals("tcp") || protocolName.equals("icmp") || protocolName.equals("igmp")) {
                        return false;
                    }
                    this._protocol = protocolName;
                } else {
                    this._protocol = protocol;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.getLog().debug("Number format exception in set protocol");
                return false;
            }
        }
        this.setModified();
        return true;
    }

    public void setReflectACLName(String reflectACLName) {
        this._reflectACLName = reflectACLName;
        this.setModified();
    }

    public void setTimeRange(String timeRange) {
        this._timeRange = timeRange;
        this.setModified();
    }

    public boolean setTos(String tos) {
        try {
            int tosNum = Integer.parseInt(tos);
            if (tosNum > 15) {
                return false;
            }
            String tosValue = PortMap.findKeyByValue(tosNum, PortMap.tosTable);
            this._tos = tosValue != null ? tosValue : tos;
        }
        catch (NumberFormatException numberFormatException) {
            if (PortMap.findValueByKey(tos, PortMap.tosTable) == -1) {
                return false;
            }
            this._tos = tos;
        }
        this.setModified();
        return true;
    }

    public String toCLI() {
        StringBuffer tempString = new StringBuffer();
        if (!this._bGrant) {
            tempString.append("deny");
        } else {
            tempString.append("permit");
        }
        tempString.append(" ").append(this._protocol);
        tempString.append(" ").append(this._source.toCLI());
        tempString.append(" ").append(this._destAddress.toCLI());
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append(" ").append("dscp").append(" ").append(this._dscp);
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            tempString.append(" ").append("precedence").append(" ").append(this._precedence);
        }
        if (this._tos != null && this._tos.length() != 0) {
            tempString.append(" ").append("tos").append(" ").append(this._tos);
        }
        if (this._bLog) {
            tempString.append(" ").append("log");
        }
        if (this._bLogInput) {
            tempString.append(" ").append("log-input");
        }
        if (this._bFragments) {
            tempString.append(" ").append("fragments");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            tempString.append(" ").append("time-range").append(" ").append(this._timeRange);
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            tempString.append(" ").append("reflect").append(" ").append(this._reflectACLName);
        }
        return tempString.toString();
    }

    public String toCLI1() {
        StringBuffer tempString = new StringBuffer();
        boolean flag = false;
        if (!this._bGrant) {
            tempString.append("deny all ");
        } else {
            tempString.append("permit all ");
        }
        tempString.append(this._protocol).append(" traffic");
        tempString.append(" from ").append(this._source.toCLI());
        tempString.append(" to ").append(this._destAddress.toCLI()).append(" ");
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append("with ").append("dscp").append("=").append(this._dscp);
            flag = true;
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("precedence").append(" = ").append(this._precedence);
        }
        if (this._tos != null && this._tos.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("tos").append(" = ").append(this._tos);
        }
        if (this._bLog) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("log");
        }
        if (this._bLogInput) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("log-input");
        }
        if (this._bFragments) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("fragments");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("time-range").append(" = ").append(this._timeRange);
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("reflect").append(" = ").append(this._reflectACLName);
        }
        return tempString.toString();
    }

    public String toFormatedString() {
        StringBuffer tempString = new StringBuffer();
        tempString.append(this._protocol).append(",");
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append(this._dscp).append("/").append("dscp").append(",");
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            tempString.append(this._precedence).append("/").append("precedence").append(",");
        }
        if (this._tos != null && this._tos.length() != 0) {
            tempString.append(this._tos).append("/").append("tos").append(",");
        }
        if (this._bLog) {
            tempString.append("log").append(",");
        }
        if (this._bLogInput) {
            tempString.append("log-input").append(",");
        }
        if (this._bFragments) {
            tempString.append("fragments").append(",");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            tempString.append(this._timeRange).append("/").append("time-range").append(",");
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            tempString.append(this._reflectACLName).append("/").append("reflect").append(",");
        }
        return tempString.toString();
    }
}

